/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.fx;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.BorderPane;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.fx.code.editor.Constants;
import org.eclipse.fx.code.editor.Input;
import org.eclipse.fx.code.editor.SourceSelection;
import org.eclipse.fx.code.editor.fx.services.ContextInformationPresenter;
import org.eclipse.fx.code.editor.fx.services.EditorContextMenuProvider;
import org.eclipse.fx.code.editor.services.ContextInformation;
import org.eclipse.fx.code.editor.services.DelegatingEditingContext;
import org.eclipse.fx.code.editor.services.EditingContext;
import org.eclipse.fx.code.editor.services.URIProvider;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.di.ContextValue;
import org.eclipse.fx.core.event.EventBus;
import org.eclipse.fx.core.preferences.Preference;
import org.eclipse.fx.core.text.TextEditAction;
import org.eclipse.fx.text.ui.contentassist.IContextInformation;
import org.eclipse.fx.text.ui.source.ISourceViewer;
import org.eclipse.fx.text.ui.source.SourceViewer;
import org.eclipse.fx.text.ui.source.SourceViewerConfiguration;
import org.eclipse.fx.ui.controls.styledtext.TextSelection;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class TextEditor {
    private IDocument document;
    private SourceViewerConfiguration configuration;
    private IDocumentPartitioner partitioner;
    private Input<?> input;
    private Property<Input<?>> activeInput;
    private SourceViewer viewer;
    private Integer tabAdvance;
    private Boolean spacesForTab;
    private EditingContext editingContext;
    private ContextInformationPresenter contextInformationPresenter;
    private EditorContextMenuProvider contextMenuProvider;
    private List<Subscription> toDispose = new ArrayList<Subscription>();

    private <T> void installListener(Property<T> property, ChangeListener<? super T> listener) {
        property.addListener(listener);
        this.toDispose.add(() -> property.removeListener(listener));
    }

    private void disposeListeners() {
        this.toDispose.forEach(s -> s.dispose());
        this.toDispose.clear();
    }

    public void setContextMenuProvider(EditorContextMenuProvider contextMenuProvider) {
        this.contextMenuProvider = contextMenuProvider;
    }

    public void setContextInformationPresenter(ContextInformationPresenter contextInformationPresenter) {
        this.contextInformationPresenter = contextInformationPresenter;
    }

    public void setEditingContext(EditingContext editingContext) {
        if (this.viewer != null) {
            throw new IllegalArgumentException("The EditingContext has to be set before the editor is initialized");
        }
        this.editingContext = editingContext;
    }

    public void setDocument(IDocument document) {
        if (this.viewer != null) {
            throw new IllegalArgumentException("The document has to be set before the editor is initialized");
        }
        this.document = document;
    }

    public void setSourceViewerConfiguration(SourceViewerConfiguration configuration) {
        if (this.viewer != null) {
            throw new IllegalArgumentException("The configuration has to be set before the editor is initialized");
        }
        this.configuration = configuration;
    }

    public void setPartitioner(IDocumentPartitioner partitioner) {
        if (this.viewer != null) {
            throw new IllegalArgumentException("The partitioner has to be set before the editor is initialized");
        }
        this.partitioner = partitioner;
    }

    @Inject
    public void setTabAdvance(@Preference(nodePath="org.eclipse.fx.code.editor", key="tabAdvance") Integer tabAdvance) {
        if (tabAdvance != null && tabAdvance > 0) {
            this.tabAdvance = tabAdvance;
        }
        if (this.viewer != null && tabAdvance != null) {
            this.viewer.getTextWidget().setTabAdvance(tabAdvance.intValue());
        }
    }

    @Inject
    public void setInsertSpacesForTab(@Preference(nodePath="org.eclipse.fx.code.editor", key="spacesForTab") Boolean spacesForTab) {
        this.spacesForTab = spacesForTab;
        if (this.viewer != null && spacesForTab != null) {
            this.viewer.getTextWidget().setInsertSpacesForTab(spacesForTab.booleanValue());
        }
    }

    @Inject
    public void setZoomFactor(@Preference(nodePath="org.eclipse.fx.code.editor", key="zoomFactor", defaultValue="1.0") double zoomFactor) {
        if (this.viewer != null) {
            this.viewer.getTextWidget().setFontZoomFactor(zoomFactor);
        }
    }

    public void setInput(Input<?> input) {
        if (this.viewer != null) {
            throw new IllegalArgumentException("The input has to be set before the editor is initialized");
        }
        this.input = input;
    }

    public void setActiveInputTracker(@ContextValue(value="activeInput") Property<Input<?>> activeInput) {
        this.activeInput = activeInput;
    }

    @PostConstruct
    public void initUI(BorderPane pane, EventBus eventBus, EditorContextMenuProvider contextMenuProvider, final ContextInformationPresenter contextInformationPresenter, EditingContext editingContext, IDocument document, SourceViewerConfiguration configuration, IDocumentPartitioner partitioner, Input<?> input, @Optional @ContextValue(value="activeInput") Property<Input<?>> activeInput, @Preference(nodePath="org.eclipse.fx.code.editor", key="zoomFactor", defaultValue="1.0") Property<Double> zoomFactor) {
        this.setContextMenuProvider(contextMenuProvider);
        this.setContextInformationPresenter(contextInformationPresenter);
        this.setEditingContext(editingContext);
        this.setDocument(document);
        this.setSourceViewerConfiguration(configuration);
        this.setPartitioner(partitioner);
        this.setInput(input);
        this.setActiveInputTracker(activeInput);
        this.viewer = this.createSourceViewer();
        if (this.tabAdvance != null) {
            this.viewer.getTextWidget().setTabAdvance(this.tabAdvance.intValue());
        }
        if (this.spacesForTab != null) {
            this.viewer.getTextWidget().setInsertSpacesForTab(this.spacesForTab.booleanValue());
        }
        if (document instanceof IDocumentExtension3) {
            ((IDocumentExtension3)document).setDocumentPartitioner(configuration.getConfiguredDocumentPartitioning((ISourceViewer)this.viewer), partitioner);
        } else {
            document.setDocumentPartitioner(partitioner);
        }
        document.setDocumentPartitioner(partitioner);
        partitioner.connect(document);
        this.viewer.configure(configuration);
        this.viewer.setDocument(document, configuration.getAnnotationModel());
        pane.setCenter((Node)this.viewer);
        if (activeInput != null) {
            activeInput.setValue(input);
        }
        this.viewer.getTextWidget().setFontZoomFactor(zoomFactor.getValue() != null ? (Double)zoomFactor.getValue() : 1.0);
        this.installListener((Property)this.viewer.getTextWidget().fontZoomFactorProperty(), (ChangeListener)(o, ol, ne) -> zoomFactor.setValue((Object)ne.doubleValue()));
        this.toDispose.add(eventBus.subscribe(Constants.TOPIC_SELECT_SOURCE, EventBus.data(this::onSourceSelect)));
        if (editingContext instanceof DelegatingEditingContext) {
            DelegatingEditingContext c = (DelegatingEditingContext)editingContext;
            c.setDelegate(new EditingContext(){

                private TextSelection convert(IRegion selection) {
                    return new TextSelection(selection.getOffset(), selection.getLength());
                }

                private IRegion convert(TextSelection selection) {
                    return new Region(selection.offset, selection.length);
                }

                public void showContextInformation(ContextInformation info) {
                    if (contextInformationPresenter != null) {
                        IContextInformation ci = contextInformationPresenter.createInformation(info);
                        TextEditor.this.viewer.showContextInformation(ci);
                    }
                }

                public void triggerAction(TextEditAction action) {
                    TextEditor.this.viewer.getTextWidget().triggerAction(action);
                }

                public void setSelection(IRegion selection) {
                    TextEditor.this.viewer.getTextWidget().setSelection(this.convert(selection));
                }

                public void setCaretOffset(int offset, boolean keepSelection) {
                    TextEditor.this.viewer.getTextWidget().impl_setCaretOffset(offset, keepSelection);
                }

                public void setCaretOffset(int offset) {
                    TextEditor.this.viewer.getTextWidget().setCaretOffset(offset);
                }

                public void revealCaret() {
                    TextEditor.this.viewer.getTextWidget().revealCaret();
                }

                public Subscription registerOnSelectionChanged(Consumer<IRegion> listener) {
                    final ChangeListener l = (x, o, n) -> {
                        if (n != null) {
                            listener.accept(this.convert((TextSelection)n));
                        } else {
                            listener.accept(null);
                        }
                    };
                    TextEditor.this.viewer.getTextWidget().selectionProperty().addListener(l);
                    return new Subscription(){

                        public void dispose() {
                            (this).TextEditor.this.viewer.getTextWidget().selectionProperty().removeListener(l);
                        }
                    };
                }

                public Subscription registerOnCaretOffsetChanged(Consumer<Integer> listener) {
                    final ChangeListener l = (x, o, n) -> listener.accept(n.intValue());
                    TextEditor.this.viewer.getTextWidget().caretOffsetProperty().addListener(l);
                    return new Subscription(){

                        public void dispose() {
                            (this).TextEditor.this.viewer.getTextWidget().caretOffsetProperty().removeListener(l);
                        }
                    };
                }

                public IRegion getSelection() {
                    TextSelection selection = TextEditor.this.viewer.getTextWidget().getSelection();
                    return this.convert(selection);
                }

                public int getCaretOffset() {
                    return TextEditor.this.viewer.getTextWidget().getCaretOffset();
                }
            });
        }
        contextMenuProvider.attacheMenu((Control)this.viewer.getTextWidget(), EditorContextMenuProvider.Type.CONTENT);
    }

    private void onSourceSelect(SourceSelection data) {
        if (((URIProvider)this.input).getURI().equals(data.uri)) {
            this.getSourceViewer().getTextWidget().setCaretOffset(data.selection.getOffset() + data.selection.getLength());
            this.getSourceViewer().getTextWidget().setSelection(new TextSelection(data.selection.getOffset(), data.selection.getLength()));
            this.getSourceViewer().getTextWidget().revealCaret();
        }
    }

    protected SourceViewer createSourceViewer() {
        return new SourceViewer();
    }

    public SourceViewer getSourceViewer() {
        return this.viewer;
    }

    @Persist
    public void save() {
        this.input.persist();
        this.documentSaved();
    }

    protected void documentSaved() {
    }

    @Focus
    void focused() {
        if (this.activeInput != null) {
            this.activeInput.setValue(this.input);
        }
        this.viewer.getTextWidget().requestFocus();
        if (this.viewer.getTextWidget().getCaretOffset() == -1 && this.viewer.getTextWidget().getContent().getCharCount() > 0) {
            this.viewer.getTextWidget().setCaretOffset(0);
        }
    }

    @PreDestroy
    void destroy() {
        if (this.activeInput != null && this.activeInput.getValue() == this.input) {
            this.activeInput.setValue(null);
        }
        this.input = null;
        if (this.editingContext instanceof DelegatingEditingContext) {
            DelegatingEditingContext c = (DelegatingEditingContext)this.editingContext;
            c.dispose();
        }
        this.disposeListeners();
        this.viewer.dispose();
    }
}

