/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.osgi.util.internal;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Optional;
import org.eclipse.fx.core.URLStreamHandler;
import org.eclipse.fx.osgi.util.internal.DelegatingURLStreamHandlerService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.url.URLStreamHandlerService;

@Component(immediate=true)
public class URLStreamComponent {
    private final BundleContext context;
    private final Map<String, ServiceRegistration<URLStreamHandlerService>> serviceRegistrations = new HashMap<String, ServiceRegistration<URLStreamHandlerService>>();

    public URLStreamComponent() {
        this.context = FrameworkUtil.getBundle(URLStreamComponent.class).getBundleContext();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void registerUrlStreamHandler(URLStreamHandler handler) {
        Hashtable<String, String[]> t = new Hashtable<String, String[]>();
        t.put("url.handler.protocol", new String[]{handler.getProtocol()});
        ServiceRegistration serviceRegistration = this.context.registerService(URLStreamHandlerService.class, (Object)new DelegatingURLStreamHandlerService(handler), t);
        this.serviceRegistrations.put(handler.getProtocol(), (ServiceRegistration<URLStreamHandlerService>)serviceRegistration);
    }

    public void unregisterUrlStreamHandler(URLStreamHandler handler) {
        Optional.ofNullable(this.serviceRegistrations.get(handler.getProtocol())).ifPresent(sr -> {
            sr.unregister();
            this.serviceRegistrations.remove(handler.getProtocol());
        });
    }
}

