/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.xtend.ast;

import java.util.Set;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.TypeNameUtil;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceImportStatement
extends SyntaxElement {
    private final Identifier importedId;

    public NamespaceImportStatement(Identifier importedID) {
        this.importedId = importedID;
    }

    public Identifier getImportedId() {
        return this.importedId;
    }

    public void analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        try {
            if (ctx.getCallback() != null && !ctx.getCallback().pre(this, ctx)) {
                return;
            }
            boolean knownNamespace = false;
            String importedIdValue = this.importedId.toString();
            if (!ctx.getNamespaces().contains(importedIdValue)) {
                Type[] typeArray = ctx.getAllTypes();
                int n = typeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Type t = typeArray[n2];
                    if (importedIdValue.equals(TypeNameUtil.withoutLastSegment(t.getName()))) {
                        knownNamespace = true;
                        break;
                    }
                    ++n2;
                }
            } else {
                knownNamespace = true;
            }
            if (!knownNamespace) {
                String msg = "Namespace " + importedIdValue + " is unknown or unused.";
                issues.add(new AnalysationIssue(AnalysationIssue.INTERNAL_ERROR, msg, this, true));
            }
        }
        finally {
            if (ctx.getCallback() != null) {
                ctx.getCallback().post(this, ctx, null);
            }
        }
    }
}

