/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.keybindings.e4;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MBindingContext;
import org.eclipse.e4.ui.model.application.commands.MBindingTable;
import org.eclipse.e4.ui.model.application.commands.MBindings;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MKeyBinding;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.services.EContextService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fx.core.SystemUtils;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.ui.keybindings.Binding;
import org.eclipse.fx.ui.keybindings.TriggerSequence;
import org.eclipse.fx.ui.keybindings.e4.EBindingService;
import org.eclipse.fx.ui.keybindings.e4.internal.BindingTable;
import org.eclipse.fx.ui.keybindings.e4.internal.BindingTableManager;
import org.eclipse.jdt.annotation.NonNull;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class BindingProcessingAddon {
    @Inject
    private MApplication application;
    @Inject
    private IEventBroker broker;
    @Inject
    private ContextManager contextManager;
    @Inject
    private BindingTableManager bindingTables;
    @Inject
    private ECommandService commandService;
    @Inject
    private EBindingService bindingService;
    @Inject
    @Log
    private Logger logger;
    private EventHandler additionHandler;
    private EventHandler contextHandler;

    @PostConstruct
    void init() {
        this.defineBindingTables();
        this.activateContexts(this.application);
        this.registerModelListeners();
    }

    private void activateContexts(Object me) {
        if (me instanceof MBindings) {
            MContext contextModel = (MContext)me;
            MBindings container = (MBindings)me;
            List bindingContexts = container.getBindingContexts();
            IEclipseContext context = contextModel.getContext();
            if (context != null && !bindingContexts.isEmpty()) {
                EContextService cs = (EContextService)context.get(EContextService.class);
                for (MBindingContext element : bindingContexts) {
                    cs.activateContext(element.getElementId());
                }
            }
        }
        if (me instanceof MElementContainer) {
            List children = ((MElementContainer)me).getChildren();
            for (MUIElement e : children) {
                this.activateContexts(e);
            }
        }
    }

    private void defineBindingTables() {
        BindingProcessingAddon.handleOverrides(this.application.getBindingTables());
        for (MBindingTable bindingTable : this.application.getBindingTables()) {
            this.defineBindingTable(bindingTable);
        }
    }

    private void defineBindingTable(MBindingTable bindingTable) {
        Context bindingContext = this.contextManager.getContext(bindingTable.getBindingContext().getElementId());
        BindingTable table = this.bindingTables.getTable(bindingTable.getBindingContext().getElementId());
        if (table == null && bindingContext != null) {
            table = new BindingTable(bindingContext);
            this.bindingTables.addTable(table);
        }
        for (MKeyBinding binding : bindingTable.getBindings()) {
            this.defineBinding(table, bindingContext, binding);
        }
    }

    private static void handleOverrides(Collection<MBindingTable> allTables) {
        HashMap<String, MKeyBinding> bindingsById = new HashMap<String, MKeyBinding>();
        for (MBindingTable table : allTables) {
            for (MKeyBinding binding : table.getBindings()) {
                bindingsById.put(binding.getElementId(), binding);
            }
        }
        String prefix = "override:";
        for (MKeyBinding binding : bindingsById.values()) {
            for (String tag : binding.getTags()) {
                String bindingId;
                if (!tag.startsWith(prefix) || (bindingId = tag.substring(prefix.length())) == null || !bindingsById.containsKey(bindingId) || !BindingProcessingAddon.appliesToPlatformAndLocale(binding)) continue;
                MKeyBinding overridden = (MKeyBinding)bindingsById.get(bindingId);
                overridden.getTags().add("deleted");
            }
        }
    }

    private static boolean appliesToPlatformAndLocale(MKeyBinding binding) {
        if (binding == null) {
            return false;
        }
        for (String tag : binding.getTags()) {
            String platform;
            String locale;
            if (!(tag.startsWith("locale") ? (locale = tag.substring(7)) != null && !BindingProcessingAddon.isCurrentLocale(locale) : tag.startsWith("platform") && (platform = tag.substring(9)) != null && !BindingProcessingAddon.isCurrentPlatform(platform))) continue;
            return false;
        }
        return true;
    }

    private static boolean isCurrentLocale(@NonNull String locale) {
        Locale currentLocale = Locale.getDefault();
        return currentLocale.toString().equals(locale);
    }

    private static boolean isCurrentPlatform(@NonNull String platform) {
        switch (platform) {
            case "gtk": {
                String osName = System.getProperty("os.name").toLowerCase();
                return osName.contains("linux");
            }
            case "cocoa": {
                return SystemUtils.isMacOS();
            }
            case "wpf": 
            case "win32": {
                return SystemUtils.isWindows();
            }
        }
        return false;
    }

    private void defineBinding(BindingTable bindingTable, Context bindingContext, MKeyBinding binding) {
        Binding keyBinding;
        String keySequence = binding.getKeySequence();
        if (keySequence != null && (keyBinding = this.createBinding(bindingContext, binding.getCommand(), binding.getParameters(), keySequence, binding)) != null && !binding.getTags().contains("deleted")) {
            bindingTable.addBinding(keyBinding);
        }
    }

    private Binding createBinding(Context bindingContext, MCommand cmdModel, List<MParameter> modelParms, @NonNull String keySequence, MKeyBinding binding) {
        if (!BindingProcessingAddon.appliesToPlatformAndLocale(binding)) {
            return null;
        }
        Binding keyBinding = null;
        if (binding.getTransientData().get("binding") != null) {
            try {
                keyBinding = (Binding)binding.getTransientData().get("binding");
                return keyBinding;
            }
            catch (ClassCastException cce) {
                System.err.println("Invalid type stored in transient data with the key binding");
                return null;
            }
        }
        if (cmdModel == null) {
            return null;
        }
        HashMap<String, String> parameters = null;
        if (modelParms != null && !modelParms.isEmpty()) {
            parameters = new HashMap<String, String>();
            for (MParameter mParm : modelParms) {
                parameters.put(mParm.getName(), mParm.getValue());
            }
        }
        ParameterizedCommand cmd = this.commandService.createCommand(cmdModel.getElementId(), parameters);
        TriggerSequence sequence = null;
        sequence = this.bindingService.createSequence(keySequence);
        if (cmd == null) {
            this.logger.error("Failed to find command for binding: " + binding);
        } else if (sequence == null) {
            this.logger.error("Failed to map binding: " + binding);
        } else {
            try {
                String schemeId = null;
                String locale = null;
                String platform = null;
                HashMap<@NonNull String, @NonNull String> attrs = new HashMap<String, String>();
                List tags = binding.getTags();
                for (String tag : tags) {
                    if (tag.startsWith("schemeId")) {
                        schemeId = tag.substring(9);
                        if (schemeId == null) continue;
                        attrs.put("schemeId", schemeId);
                        continue;
                    }
                    if (tag.startsWith("locale")) {
                        locale = tag.substring(7);
                        if (locale == null) continue;
                        attrs.put("locale", locale);
                        continue;
                    }
                    if (tag.startsWith("platform")) {
                        platform = tag.substring(9);
                        if (platform == null) continue;
                        attrs.put("platform", platform);
                        continue;
                    }
                    if (!tag.startsWith("type")) continue;
                    attrs.put("type", "user");
                }
                String id = bindingContext.getId();
                if (id != null) {
                    keyBinding = this.bindingService.createBinding(sequence, cmd, id, attrs);
                }
            }
            catch (IllegalArgumentException e) {
                this.logger.error("failed to create: " + binding, (Throwable)e);
                return null;
            }
        }
        return keyBinding;
    }

    private void updateBinding(MKeyBinding binding, boolean add, Object eObj) {
        Binding keyBinding;
        Object parentObj = ((EObject)binding).eContainer();
        if (!(parentObj instanceof MBindingTable) && eObj instanceof MBindingTable) {
            parentObj = eObj;
        }
        if (parentObj == null) {
            return;
        }
        MBindingTable bt = (MBindingTable)parentObj;
        Context bindingContext = this.contextManager.getContext(bt.getBindingContext().getElementId());
        BindingTable table = this.bindingTables.getTable(bindingContext.getId());
        if (table == null) {
            this.logger.error("Trying to create '" + binding + "' without binding table " + bindingContext.getId());
            return;
        }
        String keySequence = binding.getKeySequence();
        if (keySequence != null && (keyBinding = this.createBinding(bindingContext, binding.getCommand(), binding.getParameters(), keySequence, binding)) != null) {
            if (add) {
                table.addBinding(keyBinding);
            } else {
                table.removeBinding(keyBinding);
            }
        }
    }

    @PreDestroy
    void dispose() {
        this.unregsiterModelListeners();
    }

    private void additionHandler(Event event) {
        Object elementObj = event.getProperty("ChangedElement");
        if (elementObj instanceof MApplication) {
            MBindingTable bt;
            Context bindingContext;
            Object newObj = event.getProperty("NewValue");
            if ("ADD".equals(event.getProperty("EventType")) && newObj instanceof MBindingTable && (bindingContext = this.contextManager.getContext((bt = (MBindingTable)newObj).getBindingContext().getElementId())) != null) {
                BindingTable table = new BindingTable(bindingContext);
                this.bindingTables.addTable(table);
                List bindings = bt.getBindings();
                for (MKeyBinding binding : bindings) {
                    Binding keyBinding;
                    String keySequence = binding.getKeySequence();
                    if (keySequence == null || (keyBinding = this.createBinding(bindingContext, binding.getCommand(), binding.getParameters(), keySequence, binding)) == null) continue;
                    table.addBinding(keyBinding);
                }
            }
        } else if (elementObj instanceof MBindingTable) {
            Object newObj = event.getProperty("NewValue");
            Object oldObj = event.getProperty("OldValue");
            if ("ADD".equals(event.getProperty("EventType")) && newObj instanceof MKeyBinding) {
                MKeyBinding binding = (MKeyBinding)newObj;
                this.updateBinding(binding, true, elementObj);
            } else if ("REMOVE".equals(event.getProperty("EventType")) && oldObj instanceof MKeyBinding) {
                MKeyBinding binding = (MKeyBinding)oldObj;
                this.updateBinding(binding, false, elementObj);
            }
        } else if (elementObj instanceof MKeyBinding) {
            MKeyBinding binding = (MKeyBinding)elementObj;
            String attrName = (String)event.getProperty("AttName");
            if ("SET".equals(event.getProperty("EventType"))) {
                Object oldObj = event.getProperty("OldValue");
                if ("command".equals(attrName)) {
                    MKeyBinding oldBinding = (MKeyBinding)EcoreUtil.copy((EObject)((EObject)binding));
                    oldBinding.setCommand((MCommand)oldObj);
                    this.updateBinding(oldBinding, false, ((EObject)binding).eContainer());
                    this.updateBinding(binding, true, null);
                } else if ("keySequence".equals(attrName)) {
                    MKeyBinding oldBinding = (MKeyBinding)EcoreUtil.copy((EObject)((EObject)binding));
                    oldBinding.setKeySequence((String)oldObj);
                    this.updateBinding(oldBinding, false, ((EObject)binding).eContainer());
                    this.updateBinding(binding, true, null);
                }
            } else if ("parameters".equals(attrName)) {
                if ("ADD".equals(event.getProperty("EventType"))) {
                    Object newObj = event.getProperty("NewValue");
                    MKeyBinding oldBinding = (MKeyBinding)EcoreUtil.copy((EObject)((EObject)binding));
                    oldBinding.getParameters().remove(newObj);
                    this.updateBinding(oldBinding, false, ((EObject)binding).eContainer());
                    this.updateBinding(binding, true, null);
                } else if ("REMOVE".equals(event.getProperty("EventType"))) {
                    Object oldObj = event.getProperty("OldValue");
                    MKeyBinding oldBinding = (MKeyBinding)EcoreUtil.copy((EObject)((EObject)binding));
                    oldBinding.getParameters().add((MParameter)oldObj);
                    this.updateBinding(oldBinding, false, ((EObject)binding).eContainer());
                    this.updateBinding(binding, true, null);
                }
            } else if ("tags".equals(attrName)) {
                List tags = binding.getTags();
                if (tags.contains("deleted")) {
                    this.updateBinding(binding, false, elementObj);
                } else {
                    this.updateBinding(binding, true, elementObj);
                }
            }
        }
    }

    private void contextHandler(Event event) {
        Object elementObj = event.getProperty("ChangedElement");
        Object newObj = event.getProperty("NewValue");
        if ("SET".equals(event.getProperty("EventType")) && newObj instanceof IEclipseContext) {
            this.activateContexts(elementObj);
        }
    }

    private void registerModelListeners() {
        this.additionHandler = this::additionHandler;
        this.broker.subscribe("org/eclipse/e4/ui/model/commands/BindingTableContainer/bindingTables/*", this.additionHandler);
        this.broker.subscribe("org/eclipse/e4/ui/model/commands/BindingTable/bindings/*", this.additionHandler);
        this.broker.subscribe("org/eclipse/e4/ui/model/commands/KeyBinding/command/*", this.additionHandler);
        this.broker.subscribe("org/eclipse/e4/ui/model/commands/KeyBinding/parameters/*", this.additionHandler);
        this.broker.subscribe("org/eclipse/e4/ui/model/commands/KeySequence/keySequence/*", this.additionHandler);
        this.broker.subscribe("org/eclipse/e4/ui/model/application/ApplicationElement/tags/*", this.additionHandler);
        this.contextHandler = this::contextHandler;
        this.broker.subscribe("org/eclipse/e4/ui/model/ui/Context/context/*", this.contextHandler);
    }

    private void unregsiterModelListeners() {
        this.broker.unsubscribe(this.additionHandler);
        this.broker.unsubscribe(this.additionHandler);
        this.broker.unsubscribe(this.additionHandler);
        this.broker.unsubscribe(this.additionHandler);
        this.broker.unsubscribe(this.additionHandler);
        this.broker.unsubscribe(this.contextHandler);
    }
}

