/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.command;

import java.util.ArrayList;
import java.util.List;
import org.apache.felix.gogo.command.Inspect;
import org.apache.felix.gogo.command.Util;
import org.apache.felix.service.command.Descriptor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.RequiredBundle;

public class Inspect42 {
    public static final String LEGACY_PACKAGE_NAMESPACE = "package";
    public static final String LEGACY_BUNDLE_NAMESPACE = "bundle";
    public static final String LEGACY_HOST_NAMESPACE = "host";
    public static final String NONSTANDARD_SERVICE_NAMESPACE = "service";
    public static final String CAPABILITY = "capability";
    public static final String REQUIREMENT = "requirement";
    private static final String EMPTY_MESSAGE = "[EMPTY]";
    private static final String UNUSED_MESSAGE = "[UNUSED]";
    private static final String UNRESOLVED_MESSAGE = "[UNRESOLVED]";
    private final BundleContext m_bc;

    public Inspect42(BundleContext bc) {
        this.m_bc = bc;
    }

    @Descriptor(value="inspects bundle capabilities and requirements")
    public void inspect(@Descriptor(value="('capability' | 'requirement')") String direction, @Descriptor(value="('package' | 'bundle' | 'host' | 'service')") String namespace, @Descriptor(value="target bundles") Bundle[] bundles) {
        Inspect42.inspect(this.m_bc, direction, namespace, bundles);
    }

    private static void inspect(BundleContext bc, String direction, String namespace, Bundle[] bundles) {
        if (Inspect42.isValidDirection(direction)) {
            Bundle[] bundleArray = bundles = bundles == null || bundles.length == 0 ? bc.getBundles() : bundles;
            if (CAPABILITY.startsWith(direction)) {
                Inspect42.printNonstandardCapabilities(bc, Util.parseSubstring(namespace), bundles);
            } else {
                Inspect42.printNonstandardRequirements(bc, Util.parseSubstring(namespace), bundles);
            }
        } else if (!Inspect42.isValidDirection(direction)) {
            System.out.println("Invalid argument: " + direction);
        }
    }

    private static void printNonstandardCapabilities(BundleContext bc, List<String> namespace, Bundle[] bundles) {
        boolean separatorNeeded = false;
        for (Bundle b : bundles) {
            if (separatorNeeded) {
                System.out.println("");
            }
            String title = b + " provides:";
            System.out.println(title);
            System.out.println(Util.getUnderlineString(title.length()));
            boolean matches = false;
            if (Inspect42.matchNamespace(namespace, LEGACY_BUNDLE_NAMESPACE)) {
                matches |= Inspect42.printRequiringBundles(bc, b);
            }
            if (Inspect42.matchNamespace(namespace, LEGACY_HOST_NAMESPACE)) {
                matches |= Inspect42.printHostedFragments(bc, b);
            }
            if (Inspect42.matchNamespace(namespace, LEGACY_PACKAGE_NAMESPACE)) {
                matches |= Inspect42.printExportedPackages(bc, b);
            }
            if (Inspect42.matchNamespace(namespace, NONSTANDARD_SERVICE_NAMESPACE)) {
                matches |= Inspect.printServiceCapabilities(b);
            }
            if (!matches) {
                System.out.println(Util.unparseSubstring(namespace) + " " + EMPTY_MESSAGE);
            }
            separatorNeeded = true;
        }
    }

    private static void printNonstandardRequirements(BundleContext bc, List<String> namespace, Bundle[] bundles) {
        boolean separatorNeeded = false;
        for (Bundle b : bundles) {
            if (separatorNeeded) {
                System.out.println("");
            }
            String title = b + " requires:";
            System.out.println(title);
            System.out.println(Util.getUnderlineString(title.length()));
            boolean matches = false;
            if (Inspect42.matchNamespace(namespace, LEGACY_BUNDLE_NAMESPACE)) {
                matches |= Inspect42.printRequiredBundles(bc, b);
            }
            if (Inspect42.matchNamespace(namespace, LEGACY_HOST_NAMESPACE)) {
                matches |= Inspect42.printFragmentHosts(bc, b);
            }
            if (Inspect42.matchNamespace(namespace, LEGACY_PACKAGE_NAMESPACE)) {
                matches |= Inspect42.printImportedPackages(bc, b);
            }
            if (Inspect42.matchNamespace(namespace, NONSTANDARD_SERVICE_NAMESPACE)) {
                matches |= Inspect.printServiceRequirements(b);
            }
            if (!matches) {
                System.out.println(Util.unparseSubstring(namespace) + " " + EMPTY_MESSAGE);
            }
            separatorNeeded = true;
        }
    }

    public static boolean printExportedPackages(BundleContext bc, Bundle b) {
        ArrayList refs;
        boolean matches;
        block8: {
            matches = false;
            refs = new ArrayList();
            if (!Inspect42.isFragment(b)) {
                PackageAdmin pa = Util.getService(bc, PackageAdmin.class, refs);
                if (pa == null) {
                    System.out.println("PackageAdmin service is unavailable.");
                } else {
                    try {
                        ExportedPackage[] exports = pa.getExportedPackages(b);
                        if (exports == null) break block8;
                        for (ExportedPackage ep : exports) {
                            matches = true;
                            Bundle[] importers = ep.getImportingBundles();
                            if (importers != null && importers.length > 0) {
                                String msg = "package; " + ep.getName() + "; " + ep.getVersion().toString() + " required by:";
                                System.out.println(msg);
                                for (Bundle importer : importers) {
                                    System.out.println("   " + importer);
                                }
                                continue;
                            }
                            System.out.println("package; " + ep.getName() + "; " + ep.getVersion().toString() + " " + UNUSED_MESSAGE);
                        }
                    }
                    catch (Exception ex) {
                        System.err.println(ex.toString());
                    }
                }
            }
        }
        Util.ungetServices(bc, refs);
        return matches;
    }

    private static boolean printImportedPackages(BundleContext bc, Bundle b) {
        boolean matches = false;
        ArrayList refs = new ArrayList();
        if (!Inspect42.isFragment(b)) {
            PackageAdmin pa = Util.getService(bc, PackageAdmin.class, refs);
            if (pa == null) {
                System.out.println("PackageAdmin service is unavailable.");
            } else {
                ExportedPackage[] exports = pa.getExportedPackages((Bundle)null);
                if (exports != null) {
                    for (ExportedPackage ep : exports) {
                        Bundle[] importers = ep.getImportingBundles();
                        if (importers == null) continue;
                        for (Bundle importer : importers) {
                            if (importer != b) continue;
                            matches = true;
                            System.out.println("package; " + ep.getName() + " resolved by:");
                            System.out.println("   " + ep.getName() + "; " + ep.getVersion().toString() + " from " + ep.getExportingBundle());
                        }
                    }
                }
            }
        }
        Util.ungetServices(bc, refs);
        return matches;
    }

    public static boolean printRequiringBundles(BundleContext bc, Bundle b) {
        boolean matches = false;
        ArrayList refs = new ArrayList();
        if (!Inspect42.isFragment(b)) {
            PackageAdmin pa = Util.getService(bc, PackageAdmin.class, refs);
            if (pa == null) {
                System.out.println("PackageAdmin service is unavailable.");
            } else {
                try {
                    RequiredBundle[] rbs = pa.getRequiredBundles(b.getSymbolicName());
                    if (rbs != null) {
                        for (RequiredBundle rb : rbs) {
                            Bundle[] requires;
                            if (rb.getBundle() != b || (requires = rb.getRequiringBundles()) == null || requires.length <= 0) continue;
                            matches = true;
                            System.out.println("bundle; " + b.getSymbolicName() + "; " + b.getVersion().toString() + " required by:");
                            for (Bundle requirer : requires) {
                                System.out.println("   " + requirer);
                            }
                        }
                    }
                    if (!matches) {
                        matches = true;
                        System.out.println("bundle; " + b.getSymbolicName() + "; " + b.getVersion().toString() + " " + UNUSED_MESSAGE);
                    }
                }
                catch (Exception ex) {
                    System.err.println(ex.toString());
                }
            }
        }
        Util.ungetServices(bc, refs);
        return matches;
    }

    private static boolean printRequiredBundles(BundleContext bc, Bundle b) {
        boolean matches = false;
        ArrayList refs = new ArrayList();
        if (!Inspect42.isFragment(b)) {
            PackageAdmin pa = Util.getService(bc, PackageAdmin.class, refs);
            if (pa == null) {
                System.out.println("PackageAdmin service is unavailable.");
            } else {
                RequiredBundle[] rbs = pa.getRequiredBundles(null);
                if (rbs != null) {
                    for (RequiredBundle rb : rbs) {
                        Bundle[] requirers = rb.getRequiringBundles();
                        if (requirers == null) continue;
                        for (Bundle requirer : requirers) {
                            if (requirer != b) continue;
                            matches = true;
                            System.out.println("bundle; " + rb.getSymbolicName() + " resolved by:");
                            System.out.println("   " + rb.getBundle());
                        }
                    }
                }
            }
        }
        Util.ungetServices(bc, refs);
        return matches;
    }

    public static boolean printHostedFragments(BundleContext bc, Bundle b) {
        boolean matches = false;
        ArrayList refs = new ArrayList();
        PackageAdmin pa = Util.getService(bc, PackageAdmin.class, refs);
        if (pa == null) {
            System.out.println("PackageAdmin service is unavailable.");
        } else {
            try {
                if (!Inspect42.isFragment(b)) {
                    matches = true;
                    Bundle[] fragments = pa.getFragments(b);
                    if (fragments != null && fragments.length > 0) {
                        System.out.println("host; " + b.getSymbolicName() + "; " + b.getVersion().toString() + " required by:");
                        for (Bundle fragment : fragments) {
                            System.out.println("   " + fragment);
                        }
                    } else {
                        System.out.println("host; " + b.getSymbolicName() + "; " + b.getVersion().toString() + " " + UNUSED_MESSAGE);
                    }
                }
            }
            catch (Exception ex) {
                System.err.println(ex.toString());
            }
            Util.ungetServices(bc, refs);
        }
        return matches;
    }

    public static boolean printFragmentHosts(BundleContext bc, Bundle b) {
        boolean matches = false;
        ArrayList refs = new ArrayList();
        PackageAdmin pa = Util.getService(bc, PackageAdmin.class, refs);
        if (pa == null) {
            System.out.println("PackageAdmin service is unavailable.");
        } else {
            try {
                if (Inspect42.isFragment(b)) {
                    matches = true;
                    Bundle[] hosts = pa.getHosts(b);
                    if (hosts != null && hosts.length > 0) {
                        System.out.println("host; " + (String)b.getHeaders().get("Fragment-Host") + " resolved by:");
                        for (Bundle host : hosts) {
                            System.out.println("   " + host);
                        }
                    } else {
                        System.out.println("host; " + (String)b.getHeaders().get("Fragment-Host") + " " + UNRESOLVED_MESSAGE);
                    }
                }
            }
            catch (Exception ex) {
                System.err.println(ex.toString());
            }
            Util.ungetServices(bc, refs);
        }
        return matches;
    }

    private static boolean matchNamespace(List<String> namespace, String actual) {
        return Util.compareSubstring(namespace, actual);
    }

    private static boolean isValidDirection(String direction) {
        return CAPABILITY.startsWith(direction) || REQUIREMENT.startsWith(direction);
    }

    private static boolean isFragment(Bundle bundle) {
        return bundle.getHeaders().get("Fragment-Host") != null;
    }
}

