/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.configuration.gson;

import com.google.gson.JsonObject;
import org.eclipse.fx.code.editor.configuration.Condition;
import org.eclipse.fx.code.editor.configuration.EditorGModel;
import org.eclipse.fx.code.editor.configuration.EqualsCondition;
import org.eclipse.fx.code.editor.configuration.gson.GsonBase;

public final class GsonEqualsConditionImpl
implements GsonBase,
EqualsCondition,
Condition {
    private final String name;
    private final String value;

    public GsonEqualsConditionImpl(JsonObject jsonObject) {
        this.name = jsonObject.has("name") ? jsonObject.get("name").getAsString() : null;
        this.value = jsonObject.has("value") ? jsonObject.get("value").getAsString() : null;
    }

    public GsonEqualsConditionImpl(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public JsonObject toJSONObject() {
        JsonObject o = new JsonObject();
        o.addProperty("$gtype", "EqualsCondition");
        o.addProperty("name", this.getName());
        o.addProperty("value", this.getValue());
        return o;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "@" + Integer.toHexString(this.hashCode()) + " { " + "name : " + this.name + ", " + "value : " + this.value + " }";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public static class Builder
    implements EqualsCondition.Builder {
        private final EditorGModel instance;
        private String name;
        private String value;

        public Builder(EditorGModel instance) {
            this.instance = instance;
        }

        @Override
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public EqualsCondition build() {
            return new GsonEqualsConditionImpl(this.name, this.value);
        }
    }
}

