package org.eclipse.fx.formats.svg;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.Region;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Ellipse;
import javafx.scene.shape.Line;
import javafx.scene.shape.Path;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Polyline;
import javafx.scene.shape.QuadCurve;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.Shape;
import javafx.scene.text.Text;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fx.formats.svg.fx.FXToSvgUtils;
import org.eclipse.fx.formats.svg.fx.PresentationAttributesUtil;
import org.eclipse.fx.formats.svg.svg.SvgClipPathElement;
import org.eclipse.fx.formats.svg.svg.SvgDefsElement;
import org.eclipse.fx.formats.svg.svg.SvgElement;
import org.eclipse.fx.formats.svg.svg.SvgFactory;
import org.eclipse.fx.formats.svg.svg.SvgGElement;
import org.eclipse.fx.formats.svg.svg.SvgImageElement;
import org.eclipse.fx.formats.svg.svg.SvgPathElement;
import org.eclipse.fx.formats.svg.svg.SvgRectElement;
import org.eclipse.fx.formats.svg.svg.SvgSvgElement;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@SuppressWarnings("all")
public class FXToSvg {
  private SvgSvgElement root;
  
  private SvgDefsElement defs;
  
  private Scene s;
  
  private Parent p;
  
  @Extension
  private PresentationAttributesUtil e = new PresentationAttributesUtil(new Supplier<SvgDefsElement>() {
    @Override
    public SvgDefsElement get() {
      return FXToSvg.this.getDefs();
    }
  });
  
  public FXToSvg(final Scene s) {
    this.s = s;
  }
  
  public FXToSvg(final Parent p) {
    this.p = p;
  }
  
  public SvgDefsElement getDefs() {
    boolean _equals = Objects.equal(this.defs, null);
    if (_equals) {
      this.defs = SvgFactory.eINSTANCE.createSvgDefsElement();
      this.root.getChildren().add(0, this.defs);
    }
    return this.defs;
  }
  
  public SvgSvgElement getSvgRoot() {
    boolean _equals = Objects.equal(this.root, null);
    if (_equals) {
      this.root = SvgFactory.eINSTANCE.createSvgSvgElement();
      boolean _notEquals = (!Objects.equal(this.s, null));
      if (_notEquals) {
        this.root.setWidth(Double.valueOf(this.s.getWidth()).toString());
        this.root.setHeight(Double.valueOf(this.s.getHeight()).toString());
        Paint _fill = this.s.getFill();
        boolean _notEquals_1 = (!Objects.equal(_fill, null));
        if (_notEquals_1) {
          this.e.applyFill(this.root, this.s.getFill());
        }
        EList<SvgElement> _children = this.root.getChildren();
        SvgElement _transform = this.transform(this.s.getRoot());
        _children.add(_transform);
      } else {
        this.root = SvgFactory.eINSTANCE.createSvgSvgElement();
        this.root.setWidth(Double.valueOf(this.p.getLayoutBounds().getWidth()).toString());
        this.root.setHeight(Double.valueOf(this.p.getLayoutBounds().getHeight()).toString());
        SvgElement _transform_1 = this.transform(this.p);
        final SvgGElement rr = ((SvgGElement) _transform_1);
        rr.setTransform(null);
        EList<SvgElement> _children_1 = this.root.getChildren();
        _children_1.add(rr);
      }
    }
    return this.root;
  }
  
  protected SvgElement _transform(final Region r) {
    SvgGElement e = SvgFactory.eINSTANCE.createSvgGElement();
    e.setVisibility(FXToSvgUtils.toVisibility(r.isVisible()));
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("translate(");
    double _minX = r.getBoundsInParent().getMinX();
    _builder.append(_minX);
    _builder.append(",");
    double _minY = r.getBoundsInParent().getMinY();
    _builder.append(_minY);
    _builder.append(")");
    e.setTransform(_builder.toString());
    Shape _shape = r.getShape();
    boolean _notEquals = (!Objects.equal(_shape, null));
    if (_notEquals) {
      final SvgClipPathElement cp = SvgFactory.eINSTANCE.createSvgClipPathElement();
      cp.setId(EcoreUtil.generateUUID());
      EList<SvgElement> _children = cp.getChildren();
      SvgElement _transform = this.transform(r.getShape());
      _children.add(_transform);
      EList<SvgElement> _children_1 = this.getDefs().getChildren();
      _children_1.add(cp);
      StringConcatenation _builder_1 = new StringConcatenation();
      _builder_1.append("url(#");
      String _id = cp.getId();
      _builder_1.append(_id);
      _builder_1.append(")");
      e.setClip_path(_builder_1.toString());
      Background _background = r.getBackground();
      boolean _notEquals_1 = (!Objects.equal(_background, null));
      if (_notEquals_1) {
        EList<SvgElement> _children_2 = e.getChildren();
        final Function1<BackgroundFill, SvgElement> _function = new Function1<BackgroundFill, SvgElement>() {
          @Override
          public SvgElement apply(final BackgroundFill it) {
            return FXToSvg.this.e.createBackgroundFill(it, r);
          }
        };
        List<SvgElement> _list = IterableExtensions.<SvgElement>toList(ListExtensions.<BackgroundFill, SvgElement>map(r.getBackground().getFills(), _function));
        Iterables.<SvgElement>addAll(_children_2, _list);
      }
      Border _border = r.getBorder();
      boolean _notEquals_2 = (!Objects.equal(_border, null));
      if (_notEquals_2) {
        EList<SvgElement> _children_3 = e.getChildren();
        List<SvgElement> _createBorder = this.e.createBorder(r.getBorder(), r);
        Iterables.<SvgElement>addAll(_children_3, _createBorder);
      }
    } else {
      Background _background_1 = r.getBackground();
      boolean _notEquals_3 = (!Objects.equal(_background_1, null));
      if (_notEquals_3) {
        EList<SvgElement> _children_4 = e.getChildren();
        final Function1<BackgroundFill, SvgElement> _function_1 = new Function1<BackgroundFill, SvgElement>() {
          @Override
          public SvgElement apply(final BackgroundFill it) {
            return FXToSvg.this.e.createBackgroundFill(it, r);
          }
        };
        List<SvgElement> _list_1 = IterableExtensions.<SvgElement>toList(ListExtensions.<BackgroundFill, SvgElement>map(r.getBackground().getFills(), _function_1));
        Iterables.<SvgElement>addAll(_children_4, _list_1);
      }
      Border _border_1 = r.getBorder();
      boolean _notEquals_4 = (!Objects.equal(_border_1, null));
      if (_notEquals_4) {
        EList<SvgElement> _children_5 = e.getChildren();
        List<SvgElement> _createBorder_1 = this.e.createBorder(r.getBorder(), r);
        Iterables.<SvgElement>addAll(_children_5, _createBorder_1);
      }
    }
    EList<SvgElement> _children_6 = e.getChildren();
    final Function1<Node, Boolean> _function_2 = new Function1<Node, Boolean>() {
      @Override
      public Boolean apply(final Node it) {
        return Boolean.valueOf(it.isVisible());
      }
    };
    final Function1<Node, SvgElement> _function_3 = new Function1<Node, SvgElement>() {
      @Override
      public SvgElement apply(final Node it) {
        return FXToSvg.this.transform(it);
      }
    };
    List<SvgElement> _list_2 = IterableExtensions.<SvgElement>toList(IterableExtensions.<Node, SvgElement>map(IterableExtensions.<Node>filter(r.getChildrenUnmodifiable(), _function_2), _function_3));
    Iterables.<SvgElement>addAll(_children_6, _list_2);
    Node _clip = r.getClip();
    boolean _notEquals_5 = (!Objects.equal(_clip, null));
    if (_notEquals_5) {
      Node _clip_1 = r.getClip();
      String _plus = ("Region-Clip " + _clip_1);
      InputOutput.<String>println(_plus);
      final SvgClipPathElement cp_1 = SvgFactory.eINSTANCE.createSvgClipPathElement();
      cp_1.setId(EcoreUtil.generateUUID());
      EList<SvgElement> _children_7 = cp_1.getChildren();
      SvgElement _transform_1 = this.transform(r.getClip());
      _children_7.add(_transform_1);
      EList<SvgElement> _children_8 = this.getDefs().getChildren();
      _children_8.add(cp_1);
      StringConcatenation _builder_2 = new StringConcatenation();
      _builder_2.append("url(#");
      String _id_1 = cp_1.getId();
      _builder_2.append(_id_1);
      _builder_2.append(")");
      e.setClip_path(_builder_2.toString());
    }
    return e;
  }
  
  protected SvgElement _transform(final Group g) {
    SvgGElement e = SvgFactory.eINSTANCE.createSvgGElement();
    e.setVisibility(FXToSvgUtils.toVisibility(g.isVisible()));
    EList<SvgElement> _children = e.getChildren();
    final Function1<Node, Boolean> _function = new Function1<Node, Boolean>() {
      @Override
      public Boolean apply(final Node it) {
        return Boolean.valueOf(it.isVisible());
      }
    };
    final Function1<Node, SvgElement> _function_1 = new Function1<Node, SvgElement>() {
      @Override
      public SvgElement apply(final Node it) {
        return FXToSvg.this.transform(it);
      }
    };
    List<SvgElement> _list = IterableExtensions.<SvgElement>toList(IterableExtensions.<Node, SvgElement>map(IterableExtensions.<Node>filter(g.getChildrenUnmodifiable(), _function), _function_1));
    Iterables.<SvgElement>addAll(_children, _list);
    Node _clip = g.getClip();
    boolean _notEquals = (!Objects.equal(_clip, null));
    if (_notEquals) {
      Node _clip_1 = g.getClip();
      String _plus = ("Group-CLIP: " + _clip_1);
      InputOutput.<String>println(_plus);
      final SvgClipPathElement cp = SvgFactory.eINSTANCE.createSvgClipPathElement();
      cp.setId(EcoreUtil.generateUUID());
      EList<SvgElement> _children_1 = cp.getChildren();
      SvgElement _transform = this.transform(g.getClip());
      _children_1.add(_transform);
      EList<SvgElement> _children_2 = this.getDefs().getChildren();
      _children_2.add(cp);
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("url(#");
      String _id = cp.getId();
      _builder.append(_id);
      _builder.append(")");
      e.setClip_path(_builder.toString());
    }
    return e;
  }
  
  protected SvgElement _transform(final ImageView v) {
    SvgImageElement e = SvgFactory.eINSTANCE.createSvgImageElement();
    e.setVisibility(FXToSvgUtils.toVisibility(v.isVisible()));
    return e;
  }
  
  protected SvgElement _transform(final Arc a) {
    SvgPathElement e = FXToSvgUtils.createPath(a);
    e.setVisibility(FXToSvgUtils.toVisibility(a.isVisible()));
    this.e.applyFill(e, a.getFill());
    return e;
  }
  
  protected SvgElement _transform(final Circle c) {
    InputOutput.<String>print("Circle arc");
    return null;
  }
  
  protected SvgElement _transform(final Ellipse e) {
    InputOutput.<String>print("Ellipse arc");
    return null;
  }
  
  protected SvgElement _transform(final Line e) {
    InputOutput.<String>print("Line arc");
    return null;
  }
  
  protected SvgElement _transform(final Path p) {
    SvgPathElement e = FXToSvgUtils.createPath(p);
    e.setVisibility(FXToSvgUtils.toVisibility(p.isVisible()));
    this.e.applyFill(e, p.getFill());
    Node _clip = p.getClip();
    boolean _notEquals = (!Objects.equal(_clip, null));
    if (_notEquals) {
      Node _clip_1 = p.getClip();
      String _plus = ("PATH_CLIP:" + _clip_1);
      InputOutput.<String>println(_plus);
      final SvgClipPathElement cp = SvgFactory.eINSTANCE.createSvgClipPathElement();
      cp.setId(EcoreUtil.generateUUID());
      EList<SvgElement> _children = cp.getChildren();
      SvgElement _transform = this.transform(p.getClip());
      _children.add(_transform);
      EList<SvgElement> _children_1 = this.getDefs().getChildren();
      _children_1.add(cp);
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("url(#");
      String _id = cp.getId();
      _builder.append(_id);
      _builder.append(")");
      e.setClip_path(_builder.toString());
    }
    return e;
  }
  
  protected SvgElement _transform(final Polygon e) {
    InputOutput.<String>print("Polygon arc");
    return null;
  }
  
  protected SvgElement _transform(final Polyline e) {
    InputOutput.<String>print("Polyline arc");
    return null;
  }
  
  protected SvgElement _transform(final QuadCurve e) {
    InputOutput.<String>print("QuadCurve arc");
    return null;
  }
  
  protected SvgElement _transform(final Rectangle e) {
    final SvgRectElement r = SvgFactory.eINSTANCE.createSvgRectElement();
    r.setX(Double.valueOf(e.getX()).toString());
    r.setY(Double.valueOf(e.getY()).toString());
    r.setWidth(Double.valueOf(e.getWidth()).toString());
    r.setHeight(Double.valueOf(e.getHeight()).toString());
    r.setVisibility(FXToSvgUtils.toVisibility(e.isVisible()));
    this.e.applyFill(r, e.getFill());
    return r;
  }
  
  protected SvgElement _transform(final SVGPath e) {
    final SvgPathElement p = SvgFactory.eINSTANCE.createSvgPathElement();
    p.setD(e.getContent());
    return p;
  }
  
  protected SvgElement _transform(final Text e) {
    final SvgPathElement p = FXToSvgUtils.createPath(e);
    p.setVisibility(FXToSvgUtils.toVisibility(e.isVisible()));
    this.e.applyFill(p, e.getFill());
    SvgGElement g = SvgFactory.eINSTANCE.createSvgGElement();
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("translate(");
    double _minX = e.getBoundsInParent().getMinX();
    _builder.append(_minX);
    _builder.append(",");
    double _minY = e.getBoundsInParent().getMinY();
    double _baselineOffset = e.getBaselineOffset();
    double _plus = (_minY + _baselineOffset);
    _builder.append(_plus);
    _builder.append(")");
    g.setTransform(_builder.toString());
    EList<SvgElement> _children = g.getChildren();
    _children.add(p);
    return g;
  }
  
  public SvgElement transform(final Node g) {
    if (g instanceof Group) {
      return _transform((Group)g);
    } else if (g instanceof Region) {
      return _transform((Region)g);
    } else if (g instanceof Arc) {
      return _transform((Arc)g);
    } else if (g instanceof Circle) {
      return _transform((Circle)g);
    } else if (g instanceof Ellipse) {
      return _transform((Ellipse)g);
    } else if (g instanceof Line) {
      return _transform((Line)g);
    } else if (g instanceof Path) {
      return _transform((Path)g);
    } else if (g instanceof Polygon) {
      return _transform((Polygon)g);
    } else if (g instanceof Polyline) {
      return _transform((Polyline)g);
    } else if (g instanceof QuadCurve) {
      return _transform((QuadCurve)g);
    } else if (g instanceof Rectangle) {
      return _transform((Rectangle)g);
    } else if (g instanceof SVGPath) {
      return _transform((SVGPath)g);
    } else if (g instanceof Text) {
      return _transform((Text)g);
    } else if (g instanceof ImageView) {
      return _transform((ImageView)g);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(g).toString());
    }
  }
}
