/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.GraphVisitor;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.draw2d.graph.Subgraph;
import org.eclipse.draw2d.graph.SubgraphBoundary;

class ConvertCompoundGraph
extends GraphVisitor {
    ConvertCompoundGraph() {
    }

    /*
     * WARNING - void declaration
     */
    private static void addContainmentEdges(CompoundDirectedGraph graph) {
        for (Node node : graph.nodes) {
            Subgraph parent = node.getParent();
            if (parent == null) continue;
            Node node2 = node;
            if (node2 instanceof Subgraph) {
                void sub;
                Subgraph cfr_ignored_0 = (Subgraph)node2;
                Subgraph cfr_ignored_1 = (Subgraph)node2;
                ConvertCompoundGraph.connectHead(graph, sub.head, parent);
                ConvertCompoundGraph.connectTail(graph, sub.tail, parent);
                continue;
            }
            ConvertCompoundGraph.connectHead(graph, node, parent);
            ConvertCompoundGraph.connectTail(graph, node, parent);
        }
    }

    /*
     * WARNING - void declaration
     */
    int buildNestingTreeIndices(NodeList nodes, int base) {
        for (Node node : nodes) {
            Node node2 = node;
            if (node2 instanceof Subgraph) {
                void s;
                Subgraph cfr_ignored_0 = (Subgraph)node2;
                Subgraph cfr_ignored_1 = (Subgraph)node2;
                s.nestingTreeMin = base;
                base = this.buildNestingTreeIndices(s.members, base);
            }
            node.nestingIndex = base++;
        }
        return base++;
    }

    private static void connectHead(CompoundDirectedGraph graph, Node node, Subgraph parent) {
        boolean connectHead = true;
        int j = 0;
        while (connectHead && j < node.incoming.size()) {
            Node ancestor = ((Edge)node.incoming.get((int)j)).source;
            if (parent.isNested(ancestor)) {
                connectHead = false;
            }
            ++j;
        }
        if (connectHead) {
            Edge e = new Edge(parent.head, node);
            e.weight = 0;
            graph.edges.add(e);
            graph.containment.add(e);
        }
    }

    private static void connectTail(CompoundDirectedGraph graph, Node node, Subgraph parent) {
        boolean connectTail = true;
        int j = 0;
        while (connectTail && j < node.outgoing.size()) {
            Node ancestor = ((Edge)node.outgoing.get((int)j)).target;
            if (parent.isNested(ancestor)) {
                connectTail = false;
            }
            ++j;
        }
        if (connectTail) {
            Edge e = new Edge(node, parent.tail);
            e.weight = 0;
            graph.edges.add(e);
            graph.containment.add(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void convertSubgraphEndpoints(CompoundDirectedGraph graph) {
        int i = 0;
        while (i < graph.edges.size()) {
            Node node;
            Edge edge = (Edge)graph.edges.get(i);
            Node node2 = edge.source;
            if (node2 instanceof Subgraph) {
                void s;
                Subgraph cfr_ignored_0 = (Subgraph)node2;
                Subgraph cfr_ignored_1 = (Subgraph)node2;
                Node newSource = s.isNested(edge.target) ? s.head : s.tail;
                edge.source = newSource;
                newSource.outgoing.add(edge);
            }
            if ((node = edge.target) instanceof Subgraph) {
                void s;
                Subgraph cfr_ignored_2 = (Subgraph)node;
                Subgraph cfr_ignored_3 = (Subgraph)node;
                Node newTarget = s.isNested(edge.source) ? s.tail : s.head;
                edge.target = newTarget;
                newTarget.incoming.add(edge);
            }
            ++i;
        }
    }

    private static void replaceSubgraphsWithBoundaries(CompoundDirectedGraph graph) {
        int i = 0;
        while (i < graph.subgraphs.size()) {
            Subgraph s = (Subgraph)graph.subgraphs.get(i);
            graph.nodes.add(s.head);
            graph.nodes.add(s.tail);
            graph.nodes.remove(s);
            ++i;
        }
    }

    @Override
    void revisit(DirectedGraph g) {
        for (Edge e : g.edges) {
            if (e.source instanceof SubgraphBoundary) {
                e.source.outgoing.remove(e);
                e.source = e.source.getParent();
            }
            if (!(e.target instanceof SubgraphBoundary)) continue;
            e.target.incoming.remove(e);
            e.target = e.target.getParent();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visit(DirectedGraph dg) {
        CompoundDirectedGraph graph = (CompoundDirectedGraph)dg;
        NodeList roots = new NodeList();
        for (Node node : graph.nodes) {
            void s;
            Node node2 = node;
            if (!(node2 instanceof Subgraph)) continue;
            Subgraph cfr_ignored_0 = (Subgraph)node2;
            Subgraph cfr_ignored_1 = (Subgraph)node2;
            Insets padding = dg.getPadding((Node)s);
            s.head = new SubgraphBoundary((Subgraph)s, padding, 0);
            s.tail = new SubgraphBoundary((Subgraph)s, padding, 2);
            Edge headToTail = new Edge(s.head, s.tail);
            headToTail.weight = 10;
            graph.edges.add(headToTail);
            graph.containment.add(headToTail);
            graph.subgraphs.add(s);
            if (s.getParent() == null) {
                roots.add(s);
            }
            if (s.members.size() != 2) continue;
            graph.edges.add(new Edge(s.head, s.tail));
        }
        this.buildNestingTreeIndices(roots, 0);
        ConvertCompoundGraph.convertSubgraphEndpoints(graph);
        ConvertCompoundGraph.addContainmentEdges(graph);
        ConvertCompoundGraph.replaceSubgraphsWithBoundaries(graph);
    }
}

