/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.team.core.diff.FastDiffFilter;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.MergeAllActionHandler;
import org.eclipse.team.ui.mapping.SaveableComparison;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ModelParticipantAction;
import org.eclipse.ui.PlatformUI;

public class MergeIncomingChangesAction
extends ModelParticipantAction
implements IHandlerListener {
    IHandler handler;

    public MergeIncomingChangesAction(ISynchronizePageConfiguration configuration) {
        super(null, configuration);
        this.handler = (IHandler)configuration.getProperty("org.eclipse.team.ui.mergeAll");
        if (this.handler == null) {
            this.handler = new MergeAllActionHandler(configuration);
        }
        this.handler.addHandlerListener((IHandlerListener)this);
    }

    public void runWithEvent(Event event) {
        if (this.handler == null || !this.handler.isEnabled()) {
            return;
        }
        try {
            this.handleTargetSaveableChange();
        }
        catch (InvocationTargetException e) {
            this.handle(e);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        try {
            this.handler.execute(new ExecutionEvent(null, Collections.EMPTY_MAP, (Object)event, null));
        }
        catch (ExecutionException e) {
            this.handle(e);
        }
    }

    private void handle(Throwable throwable) {
        ExecutionException ee;
        if (throwable instanceof ExecutionException && (ee = (ExecutionException)throwable).getCause() != null) {
            throwable = ee.getCause();
        }
        Utils.handle(throwable);
    }

    @Override
    protected boolean isEnabledForSelection(IStructuredSelection selection) {
        return this.handler.isEnabled();
    }

    protected FastDiffFilter getDiffFilter() {
        return new FastDiffFilter(){

            public boolean select(IDiff node) {
                IThreeWayDiff twd;
                return node instanceof IThreeWayDiff && ((twd = (IThreeWayDiff)node).getDirection() == 768 || twd.getDirection() == 512);
            }
        };
    }

    @Override
    protected void handleTargetSaveableChange() throws InvocationTargetException, InterruptedException {
        SaveableComparison currentBuffer = this.getActiveSaveable();
        if (currentBuffer != null && currentBuffer.isDirty()) {
            PlatformUI.getWorkbench().getProgressService().run(true, true, monitor -> {
                try {
                    MergeIncomingChangesAction.handleTargetSaveableChange(this.getConfiguration().getSite().getShell(), null, currentBuffer, true, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        this.setActiveSaveable(null);
    }

    public void dispose() {
        this.handler.dispose();
    }

    public void handlerChanged(HandlerEvent handlerEvent) {
        this.setEnabled(this.handler.isEnabled());
    }
}

