/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.SymmetricKeyAlgorithmTags;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.StreamGenerator;
import org.bouncycastle.openpgp.WrappedGeneratorStream;
import org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PGPAEADDataEncryptor;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.util.io.TeeOutputStream;

public class PGPEncryptedDataGenerator
implements SymmetricKeyAlgorithmTags,
StreamGenerator {
    public static final int S2K_SHA1 = 2;
    public static final int S2K_SHA224 = 11;
    public static final int S2K_SHA256 = 8;
    public static final int S2K_SHA384 = 9;
    public static final int S2K_SHA512 = 10;
    private BCPGOutputStream pOut;
    private OutputStream cOut;
    private boolean oldFormat = false;
    private PGPDigestCalculator digestCalc;
    private OutputStream genOut;
    private PGPDataEncryptorBuilder dataEncryptorBuilder;
    private List methods = new ArrayList();
    private int defAlgorithm;
    private SecureRandom rand;

    public PGPEncryptedDataGenerator(PGPDataEncryptorBuilder pGPDataEncryptorBuilder) {
        this(pGPDataEncryptorBuilder, false);
    }

    public PGPEncryptedDataGenerator(PGPDataEncryptorBuilder pGPDataEncryptorBuilder, boolean bl) {
        this.dataEncryptorBuilder = pGPDataEncryptorBuilder;
        this.oldFormat = bl;
        this.defAlgorithm = this.dataEncryptorBuilder.getAlgorithm();
        this.rand = this.dataEncryptorBuilder.getSecureRandom();
    }

    public void addMethod(PGPKeyEncryptionMethodGenerator pGPKeyEncryptionMethodGenerator) {
        this.methods.add(pGPKeyEncryptionMethodGenerator);
    }

    private void addCheckSum(byte[] byArray) {
        int n = 0;
        for (int i = 1; i != byArray.length - 2; ++i) {
            n += byArray[i] & 0xFF;
        }
        byArray[byArray.length - 2] = (byte)(n >> 8);
        byArray[byArray.length - 1] = (byte)n;
    }

    private byte[] createSessionInfo(int n, byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + 3];
        byArray2[0] = (byte)n;
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        this.addCheckSum(byArray2);
        return byArray2;
    }

    private OutputStream open(OutputStream outputStream, long l, byte[] byArray) throws IOException, PGPException, IllegalStateException {
        Object object;
        Object object2;
        Object object3;
        if (this.cOut != null) {
            throw new IllegalStateException("generator already in open state");
        }
        if (this.methods.size() == 0) {
            throw new IllegalStateException("no encryption methods specified");
        }
        byte[] byArray2 = null;
        this.pOut = new BCPGOutputStream(outputStream);
        this.defAlgorithm = this.dataEncryptorBuilder.getAlgorithm();
        this.rand = this.dataEncryptorBuilder.getSecureRandom();
        if (this.methods.size() == 1) {
            if (this.methods.get(0) instanceof PBEKeyEncryptionMethodGenerator) {
                object3 = (PBEKeyEncryptionMethodGenerator)this.methods.get(0);
                byArray2 = ((PBEKeyEncryptionMethodGenerator)object3).getKey(this.dataEncryptorBuilder.getAlgorithm());
                this.pOut.writePacket(((PGPKeyEncryptionMethodGenerator)this.methods.get(0)).generate(this.defAlgorithm, null));
            } else {
                byArray2 = PGPUtil.makeRandomKey(this.defAlgorithm, this.rand);
                object3 = this.createSessionInfo(this.defAlgorithm, byArray2);
                object2 = (PGPKeyEncryptionMethodGenerator)this.methods.get(0);
                this.pOut.writePacket(((PGPKeyEncryptionMethodGenerator)object2).generate(this.defAlgorithm, (byte[])object3));
            }
        } else {
            byArray2 = PGPUtil.makeRandomKey(this.defAlgorithm, this.rand);
            object3 = this.createSessionInfo(this.defAlgorithm, byArray2);
            for (int i = 0; i != this.methods.size(); ++i) {
                object = (PGPKeyEncryptionMethodGenerator)this.methods.get(i);
                this.pOut.writePacket(((PGPKeyEncryptionMethodGenerator)object).generate(this.defAlgorithm, (byte[])object3));
            }
        }
        try {
            object3 = this.dataEncryptorBuilder.build(byArray2);
            this.digestCalc = object3.getIntegrityCalculator();
            if (object3 instanceof PGPAEADDataEncryptor) {
                object2 = (PGPAEADDataEncryptor)object3;
                object = object2.getIV();
                if (byArray != null) {
                    this.pOut = new ClosableBCPGOutputStream(outputStream, 20, byArray);
                } else {
                    long l2 = 1L << object2.getChunkSize() + 6;
                    long l3 = (l + l2 - 1L) / l2 * 16L + 16L;
                    this.pOut = new ClosableBCPGOutputStream(outputStream, 20, l + l3 + 4L + (long)((Object)object).length);
                }
                this.pOut.write(1);
                this.pOut.write(this.dataEncryptorBuilder.getAlgorithm());
                this.pOut.write(object2.getAEADAlgorithm());
                this.pOut.write(object2.getChunkSize());
                this.pOut.write((byte[])object);
                this.genOut = this.cOut = object3.getOutputStream(this.pOut);
                return new WrappedGeneratorStream(this.genOut, this);
            }
            if (byArray == null) {
                if (this.digestCalc != null) {
                    this.pOut = new ClosableBCPGOutputStream(outputStream, 18, l + (long)object3.getBlockSize() + 2L + 1L + 22L);
                    this.pOut.write(1);
                } else {
                    this.pOut = new ClosableBCPGOutputStream(outputStream, 9, l + (long)object3.getBlockSize() + 2L, this.oldFormat);
                }
            } else if (this.digestCalc != null) {
                this.pOut = new ClosableBCPGOutputStream(outputStream, 18, byArray);
                this.pOut.write(1);
            } else {
                this.pOut = new ClosableBCPGOutputStream(outputStream, 9, byArray);
            }
            this.genOut = this.cOut = object3.getOutputStream(this.pOut);
            if (this.digestCalc != null) {
                this.genOut = new TeeOutputStream(this.digestCalc.getOutputStream(), this.cOut);
            }
            object2 = new byte[object3.getBlockSize() + 2];
            this.rand.nextBytes((byte[])object2);
            object2[((Object)object2).length - 1] = object2[((Object)object2).length - 3];
            object2[((Object)object2).length - 2] = object2[((Object)object2).length - 4];
            this.genOut.write((byte[])object2);
            return new WrappedGeneratorStream(this.genOut, this);
        }
        catch (Exception exception) {
            throw new PGPException("Exception creating cipher", exception);
        }
    }

    public OutputStream open(OutputStream outputStream, long l) throws IOException, PGPException {
        return this.open(outputStream, l, null);
    }

    public OutputStream open(OutputStream outputStream, byte[] byArray) throws IOException, PGPException {
        return this.open(outputStream, 0L, byArray);
    }

    @Override
    public void close() throws IOException {
        if (this.cOut != null) {
            if (this.digestCalc != null) {
                BCPGOutputStream bCPGOutputStream = new BCPGOutputStream(this.genOut, 19, 20L);
                bCPGOutputStream.flush();
                byte[] byArray = this.digestCalc.getDigest();
                this.cOut.write(byArray);
            }
            this.cOut.close();
            this.cOut = null;
            this.pOut = null;
        }
    }

    private static class ClosableBCPGOutputStream
    extends BCPGOutputStream {
        public ClosableBCPGOutputStream(OutputStream outputStream, int n, byte[] byArray) throws IOException {
            super(outputStream, n, byArray);
        }

        public ClosableBCPGOutputStream(OutputStream outputStream, int n, long l, boolean bl) throws IOException {
            super(outputStream, n, l, bl);
        }

        public ClosableBCPGOutputStream(OutputStream outputStream, int n, long l) throws IOException {
            super(outputStream, n, l);
        }

        @Override
        public void close() throws IOException {
            this.finish();
        }
    }
}

