/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.api.jakarta_servlet.servletcontext40;

import java.net.InetAddress;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import servlet.tck.api.jakarta_servlet.servletcontext40.AddListener;
import servlet.tck.api.jakarta_servlet.servletcontext40.TestListener;
import servlet.tck.api.jakarta_servlet.servletcontext40.TestServlet;
import servlet.tck.api.jakarta_servlet.servletcontext40.TestServlet2;
import servlet.tck.common.client.AbstractTckTest;
import servlet.tck.common.servlets.CommonServlets;
import servlet.tck.util.WebUtil;

public class ServletContext40Tests
extends AbstractTckTest {
    private WebUtil.Response response = null;
    private String request = null;

    @Deployment(testable=false)
    public static WebArchive getTestArchive() throws Exception {
        JavaArchive javaArchive = (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"tldjar.jar")).addAsResource(ServletContext40Tests.class.getResource("listener.tld"), "META-INF/listener.tld");
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"servlet_js_servletcontext40_web.war")).addAsLibraries((Archive[])CommonServlets.getCommonServletsArchive())).addAsLibraries(new Archive[]{javaArchive})).addClasses(new Class[]{AddListener.class, TestListener.class, TestServlet.class, TestServlet2.class})).addAsWebResource("api/jakarta_servlet/servletcontext40/addJspFile.jsp", "addJspFile.jsp")).setWebXML(ServletContext40Tests.class.getResource("servlet_js_servletcontext40_web.xml"));
    }

    @Test
    public void addJspTest() throws Exception {
        try {
            this.request = this.getContextRoot() + "/servlet/addJspFile";
            this.logMsg("Sending request \"" + this.request + "\"");
            this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this._hostname), (int)this._port, (String)this.getRequest(this.request), null, null);
            this.logMsg("response.statusToken:" + this.response.statusToken);
            this.logMsg("response.content:" + this.response.content);
            if (this.response.isError()) {
                this.logErr("Could not find " + this.request);
                throw new Exception("addJspTest failed.");
            }
            if (this.response.content.indexOf("addJspFile is accessed") < 0) {
                this.logErr("The test jsp is accessed incorrectly: " + this.request);
                throw new Exception("addJspTest failed.");
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("addJspTest failed: ", e);
        }
    }

    @Test
    public void changeSessionTimeoutTest() throws Exception {
        try {
            this.request = this.getContextRoot() + "/TestServlet";
            this.logMsg("Sending request \"" + this.request + "\"");
            this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this._hostname), (int)this._port, (String)this.getRequest(this.request), null, null);
            this.logMsg("response.statusToken:" + this.response.statusToken);
            this.logMsg("response.content:" + this.response.content);
            if (this.response.isError()) {
                this.logErr("Could not find " + this.request);
                throw new Exception("changeSessionTimeoutTest failed.");
            }
            if (this.response.content.indexOf("changeSessionTimeout_correctly") < 0) {
                throw new Exception("changeSessionTimeoutTest failed.");
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("changeSessionTimeoutTest failed: ", e);
        }
    }

    @Test
    public void addJspContextInitialized() throws Exception {
        try {
            this.request = this.getContextRoot() + "/TestServlet2";
            this.logMsg("Sending request \"" + this.request + "\"");
            this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this._hostname), (int)this._port, (String)this.getRequest(this.request), null, null);
            this.logMsg("response.statusToken:" + this.response.statusToken);
            this.logMsg("response.content:" + this.response.content);
            if (this.response.isError()) {
                this.logErr("Could not find " + this.request);
                throw new Exception("addJspContextInitialized failed.");
            }
            if (this.response.content.indexOf("IllegalStateException_when_addJsp__ContextInitialized") < 0) {
                this.logErr("IllegalStateException should be thrown if this ServletContext has already been initialized");
                throw new Exception("addJspContextInitialized failed.");
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("addJspContextInitialized failed: ", e);
        }
    }

    @Test
    public void setSessionTimeoutContextInitialized() throws Exception {
        try {
            this.request = this.getContextRoot() + "/TestServlet2";
            this.logMsg("Sending request \"" + this.request + "\"");
            this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this._hostname), (int)this._port, (String)this.getRequest(this.request), null, null);
            this.logMsg("response.statusToken:" + this.response.statusToken);
            this.logMsg("response.content:" + this.response.content);
            if (this.response.isError()) {
                this.logErr("Could not find " + this.request);
                throw new Exception("setSessionTimeoutContextInitialized failed.");
            }
            if (this.response.content.indexOf("IllegalStateException_when_setSessionTimeout_ContextInitialized") < 0) {
                this.logErr("IllegalStateException should be thrown if this ServletContext has already been initialized");
                throw new Exception("setSessionTimeoutContextInitialized failed.");
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("setSessionTimeoutContextInitialized failed: ", e);
        }
    }

    @Test
    public void addJspContextListenerInTLD() throws Exception {
        try {
            this.request = this.getContextRoot() + "/TestServlet";
            this.logMsg("Sending request \"" + this.request + "\"");
            this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this._hostname), (int)this._port, (String)this.getRequest(this.request), null, null);
            this.logMsg("response.statusToken:" + this.response.statusToken);
            this.logMsg("response.content:" + this.response.content);
            if (this.response.isError()) {
                this.logErr("Could not find " + this.request);
                throw new Exception("addJspContextListenerInTLD failed.");
            }
            if (this.response.content.indexOf("UnsupportedOperationException_when_addJsp_addedListener") < 0) {
                this.logErr("UnsupportedOperationException should be thrown.");
                throw new Exception("addJspContextListenerInTLD failed.");
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("addJspContextListenerInTLD failed: ", e);
        }
    }

    @Test
    public void setSessionTimeoutContextListenerInTLD() throws Exception {
        try {
            this.request = this.getContextRoot() + "/TestServlet";
            this.logMsg("Sending request \"" + this.request + "\"");
            this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this._hostname), (int)this._port, (String)this.getRequest(this.request), null, null);
            this.logMsg("response.statusToken:" + this.response.statusToken);
            this.logMsg("response.content:" + this.response.content);
            if (this.response.isError()) {
                this.logErr("Could not find " + this.request);
                throw new Exception("setSessionTimeoutContextListenerInTLD failed.");
            }
            if (this.response.content.indexOf("UnsupportedOperationException_when_setSessionTimeout_addedListener") < 0) {
                this.logErr("UnsupportedOperationException should be thrown.");
                throw new Exception("setSessionTimeoutContextListenerInTLD failed.");
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("setSessionTimeoutContextListenerInTLD failed: ", e);
        }
    }

    @Test
    public void addJspEmptyAndNullName() throws Exception {
        try {
            this.request = this.getContextRoot() + "/TestServlet";
            this.logMsg("Sending request \"" + this.request + "\"");
            this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this._hostname), (int)this._port, (String)this.getRequest(this.request), null, null);
            this.logMsg("response.statusToken:" + this.response.statusToken);
            this.logMsg("response.content:" + this.response.content);
            if (this.response.isError()) {
                this.logErr("Could not find " + this.request);
                throw new Exception("addJspEmptyAndNullName failed.");
            }
            if (this.response.content.indexOf("IllegalArgumentException_when_empty_name") < 0) {
                this.logErr("IllegalArgumentException should be thrown if servletName is an empty String");
                throw new Exception("addJspEmptyAndNullName failed.");
            }
            if (this.response.content.indexOf("IllegalArgumentException_when_null_name") < 0) {
                this.logErr("IllegalArgumentException should be thrown if servletName is null");
                throw new Exception("addJspEmptyAndNullName failed.");
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("addJspEmptyAndNullName failed: ", e);
        }
    }

    @Test
    public void getAttributeWithNullName() throws Exception {
        try {
            this.request = this.getContextRoot() + "/TestServlet2";
            this.logMsg("Sending request \"" + this.request + "\"");
            this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this._hostname), (int)this._port, (String)this.getRequest(this.request), null, null);
            this.logMsg("response.statusToken:" + this.response.statusToken);
            this.logMsg("response.content:" + this.response.content);
            if (this.response.isError()) {
                this.logErr("Could not find " + this.request);
                throw new Exception("getAttributeWithNullName failed.");
            }
            if (this.response.content.indexOf("NullPointerException_when_getAttribute_with_null") < 0) {
                this.logErr("NullPointerException should be thrown if getAttribute with a null name.");
                throw new Exception("getAttributeWithNullName failed.");
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("getAttributeWithNullName failed: ", e);
        }
    }

    @Test
    public void getInitParameterWithNullName() throws Exception {
        try {
            this.request = this.getContextRoot() + "/TestServlet2";
            this.logMsg("Sending request \"" + this.request + "\"");
            this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this._hostname), (int)this._port, (String)this.getRequest(this.request), null, null);
            this.logMsg("response.statusToken:" + this.response.statusToken);
            this.logMsg("response.content:" + this.response.content);
            if (this.response.isError()) {
                this.logErr("Could not find " + this.request);
                throw new Exception("getInitParameterWithNullName failed.");
            }
            if (this.response.content.indexOf("NullPointerException_when_getInitParameter_with_null") < 0) {
                this.logErr("NullPointerException should be thrown if getInitParameter with a null name.");
                throw new Exception("getAttributeWithNullName failed.");
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("getInitParameterWithNullName failed: ", e);
        }
    }

    @Test
    public void setAttributeWithNullName() throws Exception {
        try {
            this.request = this.getContextRoot() + "/TestServlet2";
            this.logMsg("Sending request \"" + this.request + "\"");
            this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this._hostname), (int)this._port, (String)this.getRequest(this.request), null, null);
            this.logMsg("response.statusToken:" + this.response.statusToken);
            this.logMsg("response.content:" + this.response.content);
            if (this.response.isError()) {
                this.logErr("Could not find " + this.request);
                throw new Exception("setAttributeWithNullName failed.");
            }
            if (this.response.content.indexOf("NullPointerException_when_setAttribute_with_null") < 0) {
                this.logErr("NullPointerException should be thrown if setAttribute with a null name.");
                throw new Exception("setAttributeWithNullName failed.");
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("setAttributeWithNullName failed: ", e);
        }
    }

    @Test
    public void setInitParameterWithNullName() throws Exception {
        try {
            this.request = this.getContextRoot() + "/TestServlet2";
            this.logMsg("Sending request \"" + this.request + "\"");
            this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this._hostname), (int)this._port, (String)this.getRequest(this.request), null, null);
            this.logMsg("response.statusToken:" + this.response.statusToken);
            this.logMsg("response.content:" + this.response.content);
            if (this.response.isError()) {
                this.logErr("Could not find " + this.request);
                throw new Exception("setInitParameterWithNullName failed.");
            }
            if (this.response.content.indexOf("NullPointerException_when_setInitParameter_with_null") < 0) {
                this.logErr("NullPointerException should be thrown if setInitParameter with a null name.");
                throw new Exception("setAttributeWithNullName failed.");
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("setInitParameterWithNullName failed: ", e);
        }
    }

    @Test
    public void getEffectiveSessionTrackingModes() throws Exception {
        try {
            this.request = this.getContextRoot() + "/TestServlet2";
            this.logMsg("Sending request \"" + this.request + "\"");
            this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this._hostname), (int)this._port, (String)this.getRequest(this.request), null, null);
            this.logMsg("response.statusToken:" + this.response.statusToken);
            this.logMsg("response.content:" + this.response.content);
            if (this.response.isError()) {
                this.logErr("Could not find " + this.request);
                throw new Exception("getEffectiveSessionTrackingModes failed.");
            }
            if (this.response.content.indexOf("getEffectiveSessionTrackingModes_test_passed") < 0) {
                this.logErr("getEffectiveSessionTrackingModes return a wrong set.");
                throw new Exception("getEffectiveSessionTrackingModes failed.");
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("getEffectiveSessionTrackingModes failed: ", e);
        }
    }
}

