/*
 * Copyright (c) 2002-2015 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.internet.MimeMessage;

import java.util.*;
import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>addRecipients()</strong> API.
 * It does by passing various valid input values and then checking
 * the type of the returned object.	<p>
 *
 *		Add the given addresses to the specified recipient type. <p>
 * api2test: public void addRecipients(int, Address[])  <p>
 *
 * how2test: Call API with various arguments, then call getRecipients() api, verify
 *	     that user specified recipient address types have been added. If so then this
 *	     testcase passes, otherwise it fails.
 */

public class addRecipients_Test extends MailTest {

    public static void main( String argv[] )
    {
        addRecipients_Test test = new addRecipients_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options

        out.println("\nTesting class MimeMessage: addRecipients(int, Address[])\n");

        try {
          // Connect to host server
             Store store = connect2host(protocol, host, user, password);

          // Get a Folder object
	     Folder root = getRootFolder(store);
             Folder folder = root.getFolder(mailbox);

             if( folder == null ) {
                 return Status.failed("Invalid folder object!");
             }
             folder.open(Folder.READ_WRITE);

             if( msgcount == -1 ) {
                 msgcount = folder.getMessageCount();
                 if( msgcount < 1 )
                     return Status.failed("Mail folder is empty!");
             }
	  // Get message object
	     MimeMessage dmsg = (MimeMessage)folder.getMessage(1);

	     if( dmsg == null ) {
		 log.println("Warning: Failed to get message number 1");
		 return Status.failed("Failed to get message number 1");
	     }
          // Create a MimeMessage object
             Session session = Session.getInstance(properties, null);
             MimeMessage msg = new MimeMessage(session);

             if( msg == null ) {
                 log.println("WARNING: FAILED TO CREATE MESSAGE OBJECT");
                 return Status.failed("Failed to create Message object");
             }
	  // BEGIN UNIT TEST:
	     out.println("UNIT TEST 1: addRecipients(int, Address[])");

	     // add new To: recipients
	     msg.addRecipients(Message.RecipientType.TO, dmsg.getRecipients(Message.RecipientType.TO));	// API TEST
	     Address[] addrTOlist = msg.getRecipients(Message.RecipientType.TO);

	     if( addrTOlist != null ) {
		 for( int j = 0; j < addrTOlist.length; j++ ) {
		      if ( addrTOlist[j] != null )
			   out.println( ((InternetAddress)addrTOlist[j]).getAddress() );
		 }
	     } else
		   out.println("Warning: getRecipients(Message.RecipientType.TO) returned null pointer");

	     // add new Cc: recipients
	     msg.addRecipients(Message.RecipientType.CC, dmsg.getRecipients(Message.RecipientType.TO));	// API TEST
	     Address[] addrCClist = msg.getRecipients(Message.RecipientType.CC);

	     if( addrCClist != null ) {
		 for( int k = 0; k < addrCClist.length; k++ ) {
		      if( addrCClist[k] != null )
			  out.println( ((InternetAddress)addrCClist[k]).getAddress() );
		 }
	     } else
		   out.println("Warning: getRecipients(Message.RecipientType.CC) returned null pointer");

	     // add new Bcc; recipients
	     msg.addRecipients(Message.RecipientType.BCC, dmsg.getRecipients(Message.RecipientType.TO));	// API TEST
	     Address[] addrBCClist = msg.getRecipients(Message.RecipientType.BCC);

	     if( addrBCClist != null ) {
		 for( int n = 0; n < addrBCClist.length; n++ ) {
		      if( addrBCClist[n] != null )
			  out.println( ((InternetAddress)addrBCClist[n]).getAddress() );
		 }
	     } else
		   out.println("Warning: getRecipients(Message.RecipientType.BCC) returned null pointer");

	     out.println("UNIT TEST 1: passed\n");
	  // END UNIT TEST:

             folder.close(false);
             store.close();
             checkStatus();

        } catch ( Exception e ) {
	     handlException(e);
        }
	return status;
     }
}
