/*
 * Copyright (c) 2002-2015 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.Store;

import java.util.*;
import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>connect(...)</strong> API.
 * It does this by passing various valid input values or no input values. <p>
 *
 *		A generic connect method that takes no parameters. <p>
 * api2test: public void connect()  <p>
 *
 *		Connect to the specified address.  <p>
 * api2test: public void connect(String host, String user, String password) <p>
 * api3test: public void connect(String user, String password) <p>
 *
 * how2test: Call the 'connect(..)' API with various valid strings values. If this <p>
 *	     operation is successfull then the test passes otherwise it fails.
 */

public class connect_Test extends MailTest {

    public static void main ( String argv[] )
    {
        connect_Test test = new connect_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options

        out.println("\nTesting class Store: connect(String,String,String)\n");

        try {
          // Get a Session object
             Session session_1 = Session.getInstance(properties, null);

          // Get store object
             Store store_1 = session_1.getStore(protocol);

             if( store_1 == null ) {
                 return Status.failed("Invalid/Null Store object!");
             }
          // BEGIN UNIT TEST 1:
             out.println("UNIT TEST 1: connect(null, null, "+ password +")");

          // Connect
             store_1.connect(null, null, password);		// API TEST

          // Get a Folder object
	     Folder root = getRootFolder(store_1);
             Folder folder_1 = root.getFolder(mailbox);

             if ( folder_1 == null ) {
                  return Status.failed("Invalid/Null folder object!");
             } else
		  out.println("UNIT TEST 1:  passed\n");

             store_1.close();

	  // END UNIT TEST 1:
          // BEGIN UNIT TEST 2:

	  // Get a Session object
             Session session_2 = Session.getInstance(properties, null);

             if( session_2 == null ) {
                 return Status.failed("Invalid/Null Session object!");
             }
          // Get store object
             Store store_2 = session_2.getStore(protocol);

             if( store_2 == null ) {
                 return Status.failed("Invalid/Null Store object!");
             }
             out.println("UNIT TEST 2: connect("+ host +", "+ user +", "+ password +")");

          // Connect
             store_2.connect(host, user, password);		// API TEST

          // Get a Folder object
	     root = getRootFolder(store_2);
             Folder folder_2 = root.getFolder(mailbox);

             if( folder_2 == null )
                 return Status.failed("Invalid folder object!");
             else
		 out.println("UNIT TEST 2:  passed\n");

	     store_2.close();
          // END UNIT TEST 2:

          // BEGIN UNIT TEST 3:

             Session session_3 = Session.getInstance(properties, null);
             
          // Get store object
             Store store_3 = session_3.getStore(protocol);

             if( store_3 == null ) {
                 return Status.failed("Invalid/Null Store object!");
             }
             out.println("UNIT TEST 3: connect("+ user +", "+ password +")");

          // Connect
             
             store_3.connect(user, password);		// API TEST

          // Get a Folder object
             root = getRootFolder(store_3);
             Folder folder_3 = root.getFolder(mailbox);

             if (folder_3 == null)
                 return Status.failed("Invalid folder object!");
             else
		 out.println("UNIT TEST 3:  passed\n");

	     store_3.close();
          // END UNIT TEST 3:             
             status = Status.passed("OKAY");

        } catch (Exception e) {
	     handlException(e);
        }
	return status;
     }
}
