/*
 * Copyright (c) 2002-2015 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.Message;

import java.util.*;
import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>getSession()</strong> API.
 * It does this by invoking the test api and then checking
 * that the returned object is the same object used to create the message.<p>
 *
 *		Get the session of this message. <p>
 * api2test: public String getSession()  <p>
 *
 * how2test: Call this API on given message object, verify that it returns
 *	     the Session object used to create this message.
 *	     If this operation is successfull then this
 *	     testcase passes, otherwise it fails. <p>
 *
 *	     Returns the Session object used when the message was created.
 *           Returns null if no Session is available.
 */

public class getSession_Test extends MailTest {

    public static void main( String argv[] )
    {
        getSession_Test test = new getSession_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options

        out.println("\nTesting class Message: getSession()\n");

        try {
	    Session s = createSession();

	    // BEGIN UNIT TEST 1:
	       Message msg = new MimeMessage(s);
	       out.println("UNIT TEST 1:  getSession()");

	       Session sess = msg.getSession();	// API TEST

	       if (sess == s) {
                   out.println("UNIT TEST 1:  passed\n");
	       } else {
		       out.println("got Session: " + sess);
		       out.println("UNIT TEST 1:  Failed\n");
		       errors++;
	       }
	    // END UNIT TEST 1:

	    // BEGIN UNIT TEST 2:
	       msg = new MimeMessage((Session)null);
	       out.println("UNIT TEST 2:  getSession() null");

	       sess = msg.getSession();	// API TEST

	       if (sess == null) {
                   out.println("UNIT TEST 2:  passed\n");
	       } else {
		       out.println("got Session: " + sess);
		       out.println("UNIT TEST 2:  Failed\n");
		       errors++;
	       }
	    // END UNIT TEST 2:
	     checkStatus();

        } catch ( Exception e ) {
	     handlException(e);
        }
	return status;
     }
}
