/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.ee.pluggability.contracts.jta;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.common.pluggability.altprovider.implementation.EntityManagerFactoryImpl;
import ee.jakarta.tck.persistence.common.pluggability.altprovider.implementation.EntityManagerImpl;
import ee.jakarta.tck.persistence.common.pluggability.util.LogFileProcessor;
import jakarta.persistence.Persistence;
import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.ValidationMode;
import jakarta.persistence.spi.PersistenceUnitInfo;
import jakarta.persistence.spi.PersistenceUnitTransactionType;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Client
extends PMClientBase {
    private transient EntityManagerImpl emImpl;
    private transient EntityManagerFactoryImpl emfImpl;
    private PersistenceUnitInfo puInfo;
    private long currentSeqNum = 0L;
    private static LogFileProcessor logProcessor = null;
    private String LOGMESSAGE_PREFIX = "JPA_ALTERNATE_PROVIDER : ";

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties props) throws Exception {
        this.logTrace("setup");
        super.setup(args, props);
        logProcessor = new LogFileProcessor(props);
        if (!logProcessor.fetchLog()) {
            throw new Exception("Could not fetch log file");
        }
        this.currentSeqNum = logProcessor.getCurrentSequenceNumber();
        this.getEntityManager();
    }

    public void createEMF() throws Exception {
        String[] expected = new String[]{this.LOGMESSAGE_PREFIX + "Called createContainerEntityManagerFactory(PersistenceUnitInfo, Map)"};
        logProcessor.fetchLog();
        boolean pass = logProcessor.verifyLogContains(expected);
        if (!pass) {
            throw new Exception("createEMF failed");
        }
    }

    public void getPersistenceProviderClassName() throws Exception {
        boolean pass1 = false;
        String expected1 = "ee.jakarta.tck.persistence.common.pluggability.altprovider.implementation.PersistenceProvider";
        this.getClassObjects();
        String actual = this.puInfo.getPersistenceProviderClassName();
        if (actual.equals(expected1)) {
            this.logTrace("Received expected result:" + actual);
            pass1 = true;
        } else {
            this.logErr("Expected: " + expected1 + ", actual:" + actual);
        }
        String[] expected2 = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getPersistenceProviderClassName()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected2, this.currentSeqNum);
        if (!pass1 || pass2) {
            throw new Exception("getPersistenceProviderClassName failed");
        }
    }

    public void getPersistenceUnitNameTest() throws Exception {
        boolean pass1 = false;
        ArrayList<String> expected1 = new ArrayList<String>();
        expected1.add("CTS-EM");
        expected1.add("CTS-EM2");
        expected1.add("CTS-EM-NOTX");
        this.getClassObjects();
        String actual = this.puInfo.getPersistenceUnitName();
        if (expected1.contains(actual)) {
            this.logTrace("Received expected result:" + actual);
            pass1 = true;
        } else {
            this.logErr("Did not get one of the expected results");
            this.logErr("Expected:");
            for (String s : expected1) {
                this.logErr(s);
            }
            this.logErr("actual:" + actual);
        }
        String[] expected2 = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getPersistenceUnitName()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected2, this.currentSeqNum);
        if (!pass1 || pass2) {
            throw new Exception("getPersistenceUnitNameTest failed");
        }
    }

    public void getTransactionType() throws Exception {
        boolean pass1 = false;
        this.getClassObjects();
        PersistenceUnitTransactionType expected1 = PersistenceUnitTransactionType.JTA;
        PersistenceUnitTransactionType actual = this.puInfo.getTransactionType();
        if (actual.equals((Object)expected1)) {
            pass1 = true;
            this.logTrace("Received expected result:" + String.valueOf(actual));
        } else {
            this.logErr("Expected: " + expected1.name() + ", actual:" + actual.name());
        }
        String[] expected2 = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getTransactionType()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected2, this.currentSeqNum);
        if (!pass1 || pass2) {
            throw new Exception("getTransactionType failed");
        }
    }

    public void getManagedClassNames() throws Exception {
        boolean pass1 = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("ee.jakarta.tck.persistence.ee.pluggability.contracts.jta.Order");
        this.getClassObjects();
        List actual = this.puInfo.getManagedClassNames();
        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
            pass1 = true;
            this.logTrace("Received expected result:" + (String)actual.get(0));
        } else {
            this.logErr("Did not get expected ManagedClassNames");
            this.logErr("Expected:");
            for (String s : expected) {
                this.logErr(s);
            }
            this.logErr("Actual:");
            for (String s : actual) {
                this.logErr(s);
            }
        }
        String[] expected1 = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getManagedClassNames()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected1, this.currentSeqNum);
        if (!pass1 || pass2) {
            throw new Exception("getManagedClassNames failed");
        }
    }

    public void getJarFileUrls() throws Exception {
        boolean pass1 = false;
        String expected1 = "pluggability_contracts_jta.jar";
        this.getClassObjects();
        List actual = this.puInfo.getJarFileUrls();
        if (actual.size() > 0) {
            for (URL u : actual) {
                String sURL = u.toString();
                if (sURL.contains(expected1)) {
                    this.logTrace("actual:" + sURL);
                    pass1 = true;
                    continue;
                }
                this.logErr("getJarFileUrls() did not return a URL that contains:" + expected1);
                this.logTrace("actual:" + sURL);
            }
        } else {
            this.logErr("getJarFileUrls() returned no results");
        }
        String[] expected2 = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getJarFileUrls()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected2, this.currentSeqNum);
        if (!pass1 || pass2) {
            throw new Exception("getJarFileUrls failed");
        }
    }

    public void getPersistenceUnitRootUrl() throws Exception {
        boolean pass1 = false;
        String expected1 = "pluggability_contracts_jta.jar";
        this.getClassObjects();
        URL actual = this.puInfo.getPersistenceUnitRootUrl();
        if (actual.toString().contains(expected1)) {
            this.logTrace("Received expected result:" + actual.toString());
            pass1 = true;
        } else {
            this.logErr("Expected the actual to contain:" + expected1);
            this.logErr("actual: " + actual.toString());
        }
        String[] expected2 = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getPersistenceUnitRootUrl()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected2, this.currentSeqNum);
        if (!pass1 || pass2) {
            throw new Exception("getPersistenceUnitRootUrl failed");
        }
    }

    public void getPersistenceXMLSchemaVersion() throws Exception {
        boolean pass1 = false;
        String expected1 = "3.2";
        this.getClassObjects();
        String actual = this.puInfo.getPersistenceXMLSchemaVersion();
        if (actual.toString().equals(expected1)) {
            this.logTrace("Received expected result:" + actual.toString());
            pass1 = true;
        } else {
            this.logErr("expected: " + expected1);
            this.logErr("actual: " + actual.toString());
        }
        String[] expected2 = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getPersistenceXMLSchemaVersion()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected2, this.currentSeqNum);
        if (!pass1 || pass2) {
            throw new Exception("getPersistenceXMLSchemaVersion failed");
        }
    }

    public void getProperties() throws Exception {
        boolean pass1 = true;
        Properties expected1 = new Properties();
        expected1.put("eclipselink.logging.level", "INFO");
        expected1.put("eclipselink.logging.logger", "DefaultLogger");
        this.getClassObjects();
        Properties actual = this.puInfo.getProperties();
        if (!actual.isEmpty()) {
            for (Map.Entry<Object, Object> e : expected1.entrySet()) {
                String eKey = (String)e.getKey();
                String eVal = (String)e.getValue();
                this.logTrace("key:" + eKey + ", value:" + eVal);
                if (!actual.containsKey(eKey)) continue;
                String aVal = (String)actual.get(eKey);
                if (aVal.equals(eVal)) {
                    this.logTrace("Found expected result:" + eKey + "," + eVal);
                    continue;
                }
                pass1 = false;
                this.logErr("Actual did not contain expected property:" + eKey + "," + eVal);
            }
        } else {
            this.logErr("getProperties() returned no properties");
        }
        if (!pass1) {
            String value;
            String key;
            this.logErr("Expected:");
            for (Map.Entry<Object, Object> e : expected1.entrySet()) {
                key = (String)e.getKey();
                value = (String)e.getValue();
                this.logErr("key:" + key + ", value:" + value);
            }
            this.logErr("Actual:");
            for (Map.Entry<Object, Object> e : actual.entrySet()) {
                key = (String)e.getKey();
                value = (String)e.getValue();
                this.logErr("key:" + key + ", value:" + value);
            }
        }
        String[] expected = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getProperties()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected, this.currentSeqNum);
        if (!pass1 || pass2) {
            throw new Exception("getProperties failed");
        }
    }

    public void getSharedCacheMode() throws Exception {
        boolean pass1 = false;
        SharedCacheMode expected1 = SharedCacheMode.NONE;
        this.getClassObjects();
        SharedCacheMode actual = this.puInfo.getSharedCacheMode();
        if (actual.equals((Object)expected1)) {
            this.logTrace("Received expected result:" + actual.name());
            pass1 = true;
        } else {
            this.logErr("expected: " + expected1.name());
            this.logErr("actual: " + actual.name());
        }
        String[] expected2 = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getSharedCacheMode()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected2, this.currentSeqNum);
        if (!pass1 || pass2) {
            throw new Exception("getSharedCacheMode failed");
        }
    }

    public void getValidationMode() throws Exception {
        boolean pass1 = false;
        ValidationMode expected1 = ValidationMode.NONE;
        this.getClassObjects();
        ValidationMode actual = this.puInfo.getValidationMode();
        if (actual.equals((Object)expected1)) {
            this.logTrace("Received expected result:" + actual.name());
            pass1 = true;
        } else {
            this.logErr("expected: " + expected1.name());
            this.logErr("actual: " + actual.name());
        }
        String[] expected2 = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getValidationMode()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected2, this.currentSeqNum);
        if (!pass1 || pass2) {
            throw new Exception("getValidationMode failed");
        }
    }

    public void getClassLoader() throws Exception {
        boolean pass1 = false;
        this.getClassObjects();
        ClassLoader actual = this.puInfo.getClassLoader();
        if (actual != null) {
            pass1 = true;
            this.logTrace("Received expected non null ClassLoader:" + actual.toString());
        } else {
            this.logErr("Received null ClassLoader");
        }
        String[] expected = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getClassLoader()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected, this.currentSeqNum);
        if (!pass1 || pass2) {
            throw new Exception("getClassLoader failed");
        }
    }

    public void getNewTempClassLoader() throws Exception {
        boolean pass1 = false;
        this.getClassObjects();
        ClassLoader actual = this.emfImpl.newTempClassloader;
        if (actual != null) {
            pass1 = true;
            this.logTrace("Received expected non null ClassLoader:" + actual.toString());
        } else {
            this.logErr("Received null ClassLoader");
        }
        String[] expected = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getNewTempClassLoader()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected, this.currentSeqNum);
        if (!pass1 || pass2) {
            throw new Exception("getNewTempClassLoader failed");
        }
    }

    public void getMappingFileNames() throws Exception {
        boolean pass1 = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("META-INF/myMappingFile1.xml");
        expected.add("META-INF/myMappingFile2.xml");
        this.getClassObjects();
        List actual = this.puInfo.getMappingFileNames();
        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
            pass1 = true;
            this.logTrace("Received expected result:");
            for (String s : actual) {
                this.logTrace("result:" + s);
            }
        } else {
            this.logErr("Did not get expected ManagedClassNames");
            this.logErr("Expected:");
            for (String s : expected) {
                this.logErr(s);
            }
            this.logErr("Actual:");
            for (String s : actual) {
                this.logErr(s);
            }
        }
        String[] expected1 = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getMappingFileNames()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected1, this.currentSeqNum);
        if (!pass1 || pass2) {
            throw new Exception("getMappingFileNames failed");
        }
    }

    public void getJtaDataSource() throws Exception {
        boolean pass1 = false;
        String[] expected = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getJtaDataSource()"};
        this.getClassObjects();
        if (this.puInfo.getJtaDataSource() != null) {
            this.logTrace("getJtaDataSource() returned non-null result:" + this.puInfo.getJtaDataSource().toString());
            pass1 = true;
        } else {
            this.logTrace("getJtaDataSource() returned null result");
        }
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected, this.currentSeqNum);
        if (!pass1 || pass2) {
            throw new Exception("getJtaDataSource failed");
        }
    }

    public void excludeUnlistedClasses() throws Exception {
        boolean pass1 = false;
        String[] expected = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.excludeUnlistedClasses()"};
        this.getClassObjects();
        if (!this.puInfo.excludeUnlistedClasses()) {
            this.logTrace("excludeUnlistedClasses() returned expected result:" + this.puInfo.excludeUnlistedClasses());
            pass1 = true;
        } else {
            this.logTrace("excludeUnlistedClasses() returned null result");
        }
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected, this.currentSeqNum);
        if (!pass1 || pass2) {
            throw new Exception("excludeUnlistedClasses failed");
        }
    }

    public void getProviderUtil() throws Exception {
        String[] expected = new String[]{this.LOGMESSAGE_PREFIX + "Called getProviderUtil()"};
        Persistence.getPersistenceUtil().isLoaded((Object)"Order");
        logProcessor.fetchLog();
        boolean pass = logProcessor.verifyLogContains(expected, this.currentSeqNum);
        if (!pass) {
            throw new Exception("getProviderUtil failed");
        }
    }

    public void isLoaded() throws Exception {
        String[] expected = new String[]{this.LOGMESSAGE_PREFIX + "Called isLoaded()"};
        Persistence.getPersistenceUtil().isLoaded((Object)"Order");
        logProcessor.fetchLog();
        boolean pass = logProcessor.verifyLogContains(expected, this.currentSeqNum);
        if (!pass) {
            throw new Exception("isLoaded failed");
        }
    }

    public void getClassObjects() {
        this.emImpl = (EntityManagerImpl)this.getEntityManager(false).unwrap(EntityManagerImpl.class);
        this.emfImpl = (EntityManagerFactoryImpl)this.emImpl.getEntityManagerFactory();
        this.puInfo = this.emfImpl.puInfo;
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.logTrace("calling super.cleanup");
        super.cleanup();
    }
}

