/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.pluggability.jsonprovidertests;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jsonp.common.JSONP_Util;
import com.sun.ts.tests.jsonp.provider.MyJsonGenerator;
import com.sun.ts.tests.jsonp.provider.MyJsonProvider;
import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonException;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonGeneratorFactory;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParserFactory;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceLoader;

public class Client
extends ServiceEETest {
    static final System.Logger logger = System.getLogger(Client.class.getName());
    private static final String MY_JSONPROVIDER_CLASS = "com.sun.ts.tests.jsonp.provider.MyJsonProvider";

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        logger.log(System.Logger.Level.INFO, "setup ok");
    }

    public void cleanup() throws Exception {
        MyJsonProvider.clearCalls();
        MyJsonGenerator.clearCalls();
        logger.log(System.Logger.Level.INFO, "cleanup ok");
    }

    public void jsonProviderTest1() throws Exception {
        boolean pass = true;
        try {
            JsonProvider provider = JsonProvider.provider();
            String providerClass = provider.getClass().getName();
            logger.log(System.Logger.Level.INFO, "provider class=" + providerClass);
            if (providerClass.equals(MY_JSONPROVIDER_CLASS)) {
                logger.log(System.Logger.Level.INFO, "Current provider is my provider - expected.");
            } else {
                logger.log(System.Logger.Level.ERROR, "Current provider is not my provider - unexpected.");
                pass = false;
                ServiceLoader<JsonProvider> loader = ServiceLoader.load(JsonProvider.class);
                Iterator<JsonProvider> it = loader.iterator();
                ArrayList<JsonProvider> providers = new ArrayList<JsonProvider>();
                while (it.hasNext()) {
                    providers.add(it.next());
                }
                logger.log(System.Logger.Level.INFO, "Providers: " + String.valueOf(providers));
            }
        }
        catch (Exception e) {
            throw new Exception("jsonProviderTest1 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonProviderTest1 Failed");
        }
    }

    public void jsonProviderTest2() throws Exception {
        boolean pass = true;
        String expString = "public JsonGenerator createGenerator(Writer)";
        String expString2 = "public JsonGenerator writeStartArray()";
        try {
            logger.log(System.Logger.Level.INFO, "Calling SPI provider method: " + expString);
            JsonGenerator generator = Json.createGenerator((Writer)new StringWriter());
            String actString = MyJsonProvider.getCalls();
            logger.log(System.Logger.Level.INFO, "Verify SPI provider method was called: " + expString);
            pass = JSONP_Util.assertEquals(expString, actString);
            generator.writeStartArray();
            String actString2 = MyJsonGenerator.getCalls();
            logger.log(System.Logger.Level.INFO, "Verify SPI generator method was called: " + expString2);
            pass = JSONP_Util.assertEquals(expString2, actString2);
        }
        catch (Exception e) {
            throw new Exception("jsonProviderTest2 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonProviderTest2 Failed");
        }
    }

    public void jsonProviderTest3() throws Exception {
        boolean pass = true;
        String expString = "public JsonGenerator createGenerator(OutputStream)";
        String expString2 = "public JsonGenerator writeStartObject()";
        try {
            logger.log(System.Logger.Level.INFO, "Calling SPI provider method: " + expString);
            JsonGenerator generator = Json.createGenerator((OutputStream)new ByteArrayOutputStream());
            String actString = MyJsonProvider.getCalls();
            logger.log(System.Logger.Level.INFO, "Verify SPI provider method was called: " + expString);
            pass = JSONP_Util.assertEquals(expString, actString);
            generator.writeStartObject();
            String actString2 = MyJsonGenerator.getCalls();
            logger.log(System.Logger.Level.INFO, "Verify SPI generator method was called: " + expString2);
            pass = JSONP_Util.assertEquals(expString2, actString2);
        }
        catch (Exception e) {
            throw new Exception("jsonProviderTest3 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonProviderTest3 Failed");
        }
    }

    public void jsonProviderTest4() throws Exception {
        boolean pass = true;
        String expString = "public JsonParser createParser(Reader)";
        try {
            logger.log(System.Logger.Level.INFO, "Calling SPI provider method: " + expString);
            JsonParser parser = Json.createParser((Reader)new StringReader("{}"));
            String actString = MyJsonProvider.getCalls();
            logger.log(System.Logger.Level.INFO, "Verify SPI provider method was called: " + expString);
            pass = JSONP_Util.assertEquals(expString, actString);
        }
        catch (Exception e) {
            throw new Exception("jsonProviderTest4 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonProviderTest4 Failed");
        }
    }

    public void jsonProviderTest5() throws Exception {
        boolean pass = true;
        String expString = "public JsonParser createParser(InputStream)";
        try {
            logger.log(System.Logger.Level.INFO, "Calling SPI provider method: " + expString);
            JsonParser parser = Json.createParser((InputStream)JSONP_Util.getInputStreamFromString("{}"));
            String actString = MyJsonProvider.getCalls();
            logger.log(System.Logger.Level.INFO, "Verify SPI provider method was called: " + expString);
            pass = JSONP_Util.assertEquals(expString, actString);
        }
        catch (Exception e) {
            throw new Exception("jsonProviderTest5 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonProviderTest5 Failed");
        }
    }

    public void jsonProviderTest6() throws Exception {
        boolean pass = true;
        String expString = "public JsonParserFactory createParserFactory(Map<String, ?>)";
        try {
            logger.log(System.Logger.Level.INFO, "Calling SPI provider method: " + expString);
            JsonParserFactory parserFactory = Json.createParserFactory(JSONP_Util.getEmptyConfig());
            String actString = MyJsonProvider.getCalls();
            logger.log(System.Logger.Level.INFO, "Verify SPI provider method was called: " + expString);
            pass = JSONP_Util.assertEquals(expString, actString);
        }
        catch (Exception e) {
            throw new Exception("jsonProviderTest6 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonProviderTest6 Failed");
        }
    }

    public void jsonProviderTest7() throws Exception {
        boolean pass = true;
        String expString = "public JsonParserFactory createParserFactory(Map<String, ?>)";
        try {
            logger.log(System.Logger.Level.INFO, "Calling SPI provider method: " + expString);
            JsonParserFactory parserFactory = Json.createParserFactory(new HashMap());
            String actString = MyJsonProvider.getCalls();
            logger.log(System.Logger.Level.INFO, "Verify SPI provider method was called: " + expString);
            pass = JSONP_Util.assertEquals(expString, actString);
        }
        catch (Exception e) {
            throw new Exception("jsonProviderTest7 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonProviderTest7 Failed");
        }
    }

    public void jsonProviderTest8() throws Exception {
        boolean pass = true;
        String expString = "public JsonGeneratorFactory createGeneratorFactory(Map<String, ?>)";
        try {
            logger.log(System.Logger.Level.INFO, "Calling SPI provider method: " + expString);
            JsonGeneratorFactory generatorFactory = Json.createGeneratorFactory(new HashMap());
            String actString = MyJsonProvider.getCalls();
            logger.log(System.Logger.Level.INFO, "Verify SPI provider method was called: " + expString);
            pass = JSONP_Util.assertEquals(expString, actString);
        }
        catch (Exception e) {
            throw new Exception("jsonProviderTest8 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonProviderTest8 Failed");
        }
    }

    public void jsonProviderTest9() throws Exception {
        boolean pass = true;
        String expString = "public JsonWriterFactory createWriterFactory(Map<String, ?>)";
        try {
            logger.log(System.Logger.Level.INFO, "Calling SPI provider method: " + expString);
            JsonWriterFactory factory = Json.createWriterFactory(JSONP_Util.getEmptyConfig());
            String actString = MyJsonProvider.getCalls();
            logger.log(System.Logger.Level.INFO, "Verify SPI provider method was called: " + expString);
            pass = JSONP_Util.assertEquals(expString, actString);
        }
        catch (Exception e) {
            throw new Exception("jsonProviderTest9 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonProviderTest9 Failed");
        }
    }

    public void jsonProviderTest10() throws Exception {
        boolean pass = true;
        String expString = "public JsonParser createParser(InputStream)";
        try {
            logger.log(System.Logger.Level.INFO, "Calling SPI provider method: " + expString);
            InputStream in = null;
            JsonParser parser = Json.createParser(in);
            pass = false;
        }
        catch (JsonException e) {
            logger.log(System.Logger.Level.INFO, "Caught expected JsonException: " + String.valueOf((Object)e));
        }
        catch (Exception e) {
            throw new Exception("jsonProviderTest10 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonProviderTest10 Failed");
        }
    }

    public void jsonProviderTest11() throws Exception {
        boolean pass = true;
        String expString = "public JsonArrayBuilder createArrayBuilder()";
        try {
            logger.log(System.Logger.Level.INFO, "Calling SPI provider method: " + expString);
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            String actString = MyJsonProvider.getCalls();
            logger.log(System.Logger.Level.INFO, "Verify SPI provider method was called: " + expString);
            pass = JSONP_Util.assertEquals(expString, actString);
        }
        catch (Exception e) {
            throw new Exception("jsonProviderTest11 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonProviderTest11 Failed");
        }
    }

    public void jsonProviderTest12() throws Exception {
        boolean pass = true;
        String expString = "public JsonObjectBuilder createObjectBuilder()";
        try {
            logger.log(System.Logger.Level.INFO, "Calling SPI provider method: " + expString);
            JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
            String actString = MyJsonProvider.getCalls();
            logger.log(System.Logger.Level.INFO, "Verify SPI provider method was called: " + expString);
            pass = JSONP_Util.assertEquals(expString, actString);
        }
        catch (Exception e) {
            throw new Exception("jsonProviderTest12 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonProviderTest12 Failed");
        }
    }

    public void jsonProviderTest13() throws Exception {
        boolean pass = true;
        String expString = "public JsonBuilderFactory createBuilderFactory(Map<String, ?>)";
        try {
            logger.log(System.Logger.Level.INFO, "Calling SPI provider method: " + expString);
            JsonBuilderFactory objectBuilder = Json.createBuilderFactory(JSONP_Util.getEmptyConfig());
            String actString = MyJsonProvider.getCalls();
            logger.log(System.Logger.Level.INFO, "Verify SPI provider method was called: " + expString);
            pass = JSONP_Util.assertEquals(expString, actString);
        }
        catch (Exception e) {
            throw new Exception("jsonProviderTest13 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonProviderTest13 Failed");
        }
    }

    public void jsonProviderTest14() throws Exception {
        boolean pass = true;
        String expString = "public JsonReader createReader(Reader)";
        try {
            logger.log(System.Logger.Level.INFO, "Calling SPI provider method: " + expString);
            JsonReader reader = Json.createReader((Reader)new StringReader("{}"));
            String actString = MyJsonProvider.getCalls();
            logger.log(System.Logger.Level.INFO, "Verify SPI provider method was called: " + expString);
            pass = JSONP_Util.assertEquals(expString, actString);
        }
        catch (Exception e) {
            throw new Exception("jsonProviderTest14 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonProviderTest14 Failed");
        }
    }

    public void jsonProviderTest15() throws Exception {
        boolean pass = true;
        String expString = "public JsonReader createReader(InputStream)";
        try {
            logger.log(System.Logger.Level.INFO, "Calling SPI provider method: " + expString);
            JsonReader reader = Json.createReader((InputStream)JSONP_Util.getInputStreamFromString("{}"));
            String actString = MyJsonProvider.getCalls();
            logger.log(System.Logger.Level.INFO, "Verify SPI provider method was called: " + expString);
            pass = JSONP_Util.assertEquals(expString, actString);
        }
        catch (Exception e) {
            throw new Exception("jsonProviderTest15 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonProviderTest15 Failed");
        }
    }

    public void jsonProviderTest16() throws Exception {
        boolean pass = true;
        String expString = "public JsonWriter createWriter(Writer)";
        try {
            logger.log(System.Logger.Level.INFO, "Calling SPI provider method: " + expString);
            JsonWriter writer = Json.createWriter((Writer)new StringWriter());
            String actString = MyJsonProvider.getCalls();
            logger.log(System.Logger.Level.INFO, "Verify SPI provider method was called: " + expString);
            pass = JSONP_Util.assertEquals(expString, actString);
        }
        catch (Exception e) {
            throw new Exception("jsonProviderTest16 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonProviderTest16 Failed");
        }
    }

    public void jsonProviderTest17() throws Exception {
        boolean pass = true;
        String expString = "public JsonWriter createWriter(OutputStream)";
        try {
            logger.log(System.Logger.Level.INFO, "Calling SPI provider method: " + expString);
            JsonWriter writer = Json.createWriter((OutputStream)new ByteArrayOutputStream());
            String actString = MyJsonProvider.getCalls();
            logger.log(System.Logger.Level.INFO, "Verify SPI provider method was called: " + expString);
            pass = JSONP_Util.assertEquals(expString, actString);
        }
        catch (Exception e) {
            throw new Exception("jsonProviderTest17 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonProviderTest17 Failed");
        }
    }

    public void jsonProviderTest18() throws Exception {
        boolean pass = true;
        String expString = "public JsonReaderFactory createReaderFactory(Map<String, ?>)";
        try {
            logger.log(System.Logger.Level.INFO, "Calling SPI provider method: " + expString);
            JsonReaderFactory factory = Json.createReaderFactory(JSONP_Util.getEmptyConfig());
            String actString = MyJsonProvider.getCalls();
            logger.log(System.Logger.Level.INFO, "Verify SPI provider method was called: " + expString);
            pass = JSONP_Util.assertEquals(expString, actString);
        }
        catch (Exception e) {
            throw new Exception("jsonProviderTest18 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonProviderTest18 Failed");
        }
    }
}

