/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.interview;

import com.sun.interview.FinalQuestion;
import com.sun.interview.Interview;
import com.sun.interview.NullQuestion;
import com.sun.interview.Question;
import com.sun.interview.StringQuestion;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.KnownFailuresList;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.interview.ConcurrencyInterview;
import com.sun.javatest.interview.ExcludeListInterview;
import com.sun.javatest.interview.KeywordsInterview;
import com.sun.javatest.interview.KnownFailuresListInterview;
import com.sun.javatest.interview.PriorStatusInterview;
import com.sun.javatest.interview.TestsInterview;
import com.sun.javatest.interview.TimeoutFactorInterview;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.text.MessageFormat;
import java.util.MissingResourceException;

public abstract class BasicInterviewParameters
extends InterviewParameters {
    private TestSuite testSuite;
    private WorkDirectory workDir;
    protected TestsInterview iTests;
    private ExcludeListInterview iExcludeList;
    private KnownFailuresListInterview iKfl;
    private KeywordsInterview iKeywords;
    private PriorStatusInterview iPriorStatus;
    private ConcurrencyInterview iConcurrency;
    private TimeoutFactorInterview iTimeoutFactor;
    private boolean nameAndDescriptionInPrologEnabled;
    private NullQuestion qProlog = new NullQuestion(this, "prolog"){
        private Object helpID;
        private String summary;
        private String text;

        @Override
        public Question getNext() {
            if (BasicInterviewParameters.this.nameAndDescriptionInPrologEnabled) {
                return BasicInterviewParameters.this.qName;
            }
            return BasicInterviewParameters.this.getPrologSuccessorQuestion();
        }

        @Override
        public Object getHelpID() {
            Object id = super.getHelpID();
            if (id == null) {
                id = BasicInterviewParameters.this.getHelpIDX("BasicInterviewParameters.prolog");
                this.setHelpID(id);
            }
            return id;
        }

        @Override
        public String getSummary() {
            if (this.summary == null) {
                this.summary = BasicInterviewParameters.this.getResourceStringX("BasicInterviewParameters.prolog.smry");
            }
            return this.summary;
        }

        @Override
        public String getText() {
            if (this.text == null) {
                this.text = BasicInterviewParameters.this.getResourceStringX("BasicInterviewParameters.prolog.text");
            }
            return MessageFormat.format(this.text, this.getTextArgs());
        }

        @Override
        public Object[] getTextArgs() {
            String name = BasicInterviewParameters.this.testSuite == null ? null : BasicInterviewParameters.this.testSuite.getName();
            return new Object[]{new Integer(name == null ? 0 : 1), name};
        }
    };
    private StringQuestion qName;
    private StringQuestion qDescription;
    private FinalQuestion qEpilog = new FinalQuestion(this, "epilog"){
        private Object helpID;
        private String summary;
        private String text;

        @Override
        public Object getHelpID() {
            Object id = super.getHelpID();
            if (id == null) {
                id = BasicInterviewParameters.this.getHelpIDX("BasicInterviewParameters.epilog");
                this.setHelpID(id);
            }
            return id;
        }

        @Override
        public String getSummary() {
            if (this.summary == null) {
                this.summary = BasicInterviewParameters.this.getResourceStringX("BasicInterviewParameters.epilog.smry");
            }
            return this.summary;
        }

        @Override
        public String getText() {
            if (this.text == null) {
                this.text = BasicInterviewParameters.this.getResourceStringX("BasicInterviewParameters.epilog.text");
            }
            return MessageFormat.format(this.text, this.getTextArgs());
        }
    };
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(BasicInterviewParameters.class);

    protected BasicInterviewParameters(String tag) throws Interview.Fault {
        super(tag);
        this.iTests = this.createTestsInterview(this);
        this.iExcludeList = new ExcludeListInterview(this);
        this.iKeywords = new KeywordsInterview(this);
        this.iKfl = new KnownFailuresListInterview(this);
        this.iPriorStatus = new PriorStatusInterview(this);
        this.iConcurrency = new ConcurrencyInterview((Interview)this, this.getMaxConcurrency());
        this.iTimeoutFactor = new TimeoutFactorInterview(this);
        this.setFirstQuestion(this.qProlog);
    }

    protected BasicInterviewParameters(String tag, TestSuite ts) throws Interview.Fault {
        this(tag);
        this.setTestSuite(ts);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.iConcurrency = null;
        this.iExcludeList.dispose();
        this.iExcludeList = null;
        this.iKeywords.dispose();
        this.iKeywords = null;
        this.iKfl.dispose();
        this.iKfl = null;
        this.iPriorStatus = null;
        this.iTests.dispose();
        this.iTests = null;
        this.iTimeoutFactor = null;
        this.workDir = null;
        this.testSuite = null;
    }

    protected TestsInterview createTestsInterview(InterviewParameters parent) throws Interview.Fault {
        return new TestsInterview(parent);
    }

    public void setNameAndDescriptionInPrologEnabled(boolean on) {
        if (on) {
            this.initNameQuestion();
            this.initDescriptionQuestion();
        }
        this.nameAndDescriptionInPrologEnabled = on;
    }

    public boolean isNameAndDescriptionInPrologEnabled() {
        return this.nameAndDescriptionInPrologEnabled;
    }

    @Override
    public String getName() {
        if (this.nameAndDescriptionInPrologEnabled) {
            return this.qName.getValue();
        }
        return super.getName();
    }

    @Override
    public String getDescription() {
        if (this.nameAndDescriptionInPrologEnabled) {
            return this.qDescription.getValue();
        }
        return super.getDescription();
    }

    @Override
    public TestSuite getTestSuite() {
        return this.testSuite;
    }

    @Override
    public void setTestSuite(TestSuite ts) {
        if (ts == null) {
            throw new NullPointerException();
        }
        if (this.testSuite != null && this.testSuite != ts) {
            throw new IllegalStateException();
        }
        this.testSuite = ts;
    }

    @Override
    public WorkDirectory getWorkDirectory() {
        return this.workDir;
    }

    @Override
    public void setWorkDirectory(WorkDirectory wd) {
        if (wd == null) {
            throw new NullPointerException();
        }
        if (this.workDir != null && this.workDir != wd) {
            throw new IllegalStateException();
        }
        this.workDir = wd;
    }

    @Override
    public Parameters.TestsParameters getTestsParameters() {
        return this.iTests;
    }

    @Override
    protected Question getTestsFirstQuestion() {
        return this.callInterview(this.iTests, this.getTestsSuccessorQuestion());
    }

    @Override
    public Parameters.ExcludeListParameters getExcludeListParameters() {
        return this.iExcludeList;
    }

    @Override
    protected Question getExcludeListFirstQuestion() {
        return this.callInterview(this.iExcludeList, this.getExcludeListSuccessorQuestion());
    }

    @Override
    protected Question getExcludeListSuccessorQuestion() {
        return this.getKflFirstQuestion();
    }

    protected Question getKflFirstQuestion() {
        return this.callInterview(this.iKfl, this.getKflSuccessorQuestion());
    }

    protected Question getKflSuccessorQuestion() {
        return this.getKeywordsFirstQuestion();
    }

    @Override
    public KnownFailuresList getKnownFailuresList() {
        return this.iKfl.getKfl();
    }

    @Override
    public void setKnownFailureFiles(File[] files) {
        super.setKnownFailureFiles(files);
        this.iKfl.setKflFiles(files);
    }

    @Override
    public File[] getKnownFailureFiles() {
        return this.iKfl.getKflFiles();
    }

    @Override
    public Parameters.KeywordsParameters getKeywordsParameters() {
        TestSuite ts = this.getTestSuite();
        String[] kw = ts == null ? null : ts.getKeywords();
        return kw == null || kw.length > 0 ? this.iKeywords : null;
    }

    @Override
    protected Question getKeywordsFirstQuestion() {
        String[] kw;
        TestSuite ts = this.getTestSuite();
        String[] stringArray = kw = ts == null ? null : ts.getKeywords();
        if (kw == null || kw.length > 0) {
            return this.callInterview(this.iKeywords, this.getKeywordsSuccessorQuestion());
        }
        return this.getKeywordsSuccessorQuestion();
    }

    @Override
    public Parameters.PriorStatusParameters getPriorStatusParameters() {
        return this.iPriorStatus;
    }

    @Override
    protected Question getPriorStatusFirstQuestion() {
        return this.callInterview(this.iPriorStatus, this.getPriorStatusSuccessorQuestion());
    }

    @Override
    public Parameters.ConcurrencyParameters getConcurrencyParameters() {
        return this.iConcurrency;
    }

    @Override
    protected Question getConcurrencyFirstQuestion() {
        return this.callInterview(this.iConcurrency, this.getConcurrencySuccessorQuestion());
    }

    protected int getMaxConcurrency() {
        return 256;
    }

    @Override
    public Parameters.TimeoutFactorParameters getTimeoutFactorParameters() {
        return this.iTimeoutFactor;
    }

    @Override
    protected Question getTimeoutFactorFirstQuestion() {
        return this.callInterview(this.iTimeoutFactor, this.getTimeoutFactorSuccessorQuestion());
    }

    @Override
    protected Question getEpilogFirstQuestion() {
        return this.qEpilog;
    }

    private String getResourceStringX(String key) {
        String s = this.getResourceString(key, true);
        if (s != null) {
            return s;
        }
        try {
            return i18n.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    private Object getHelpIDX(String target) {
        return helpSetFactory.createHelpID(this.getHelpSet(), target);
    }

    private void initNameQuestion() {
        this.qName = new StringQuestion(this, "name"){
            private Object helpID;
            private String summary;
            private String text;

            @Override
            public boolean isValueValid() {
                return BasicInterviewParameters.isValidIdentifier(this.value);
            }

            @Override
            public Question getNext() {
                return BasicInterviewParameters.this.qDescription;
            }

            @Override
            public Object getHelpID() {
                Object id = super.getHelpID();
                if (id == null) {
                    id = BasicInterviewParameters.this.getHelpIDX("BasicInterviewParameters.name");
                    this.setHelpID(id);
                }
                return id;
            }

            @Override
            public String getSummary() {
                if (this.summary == null) {
                    this.summary = BasicInterviewParameters.this.getResourceStringX("BasicInterviewParameters.name.smry");
                }
                return this.summary;
            }

            @Override
            public String getText() {
                if (this.text == null) {
                    this.text = BasicInterviewParameters.this.getResourceStringX("BasicInterviewParameters.name.text");
                }
                return MessageFormat.format(this.text, this.getTextArgs());
            }

            @Override
            public Object[] getTextArgs() {
                String name = BasicInterviewParameters.this.testSuite == null ? null : BasicInterviewParameters.this.testSuite.getName();
                return new Object[]{new Integer(name == null ? 0 : 1), name};
            }
        };
    }

    private static boolean isValidIdentifier(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        if (!Character.isLetter(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            return false;
        }
        return true;
    }

    private void initDescriptionQuestion() {
        this.qDescription = new StringQuestion(this, "description"){
            private Object helpID;
            private String summary;
            private String text;

            @Override
            public boolean isValueValid() {
                return this.value != null && this.value.length() > 0;
            }

            @Override
            public Question getNext() {
                return BasicInterviewParameters.this.getPrologSuccessorQuestion();
            }

            @Override
            public Object getHelpID() {
                Object id = super.getHelpID();
                if (id == null) {
                    id = BasicInterviewParameters.this.getHelpIDX("BasicInterviewParameters.description");
                    this.setHelpID(id);
                }
                return id;
            }

            @Override
            public String getSummary() {
                if (this.summary == null) {
                    this.summary = BasicInterviewParameters.this.getResourceStringX("BasicInterviewParameters.description.smry");
                }
                return this.summary;
            }

            @Override
            public String getText() {
                if (this.text == null) {
                    this.text = BasicInterviewParameters.this.getResourceStringX("BasicInterviewParameters.description.text");
                }
                return MessageFormat.format(this.text, this.getTextArgs());
            }

            @Override
            public Object[] getTextArgs() {
                String name = BasicInterviewParameters.this.testSuite == null ? null : BasicInterviewParameters.this.testSuite.getName();
                return new Object[]{new Integer(name == null ? 0 : 1), name};
            }
        };
    }
}

