/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.tree;

import java.io.PrintStream;
import java.util.Hashtable;
import org.glassfish.rmic.tools.asm.Assembler;
import org.glassfish.rmic.tools.asm.Label;
import org.glassfish.rmic.tools.java.ClassNotFound;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.java.Type;
import org.glassfish.rmic.tools.tree.BinaryExpression;
import org.glassfish.rmic.tools.tree.ConditionVars;
import org.glassfish.rmic.tools.tree.Context;
import org.glassfish.rmic.tools.tree.Expression;
import org.glassfish.rmic.tools.tree.NotExpression;
import org.glassfish.rmic.tools.tree.UnaryExpression;
import org.glassfish.rmic.tools.tree.Vset;

public class ConditionalExpression
extends BinaryExpression {
    Expression cond;

    public ConditionalExpression(long where, Expression cond, Expression left, Expression right) {
        super(13, where, Type.tError, left, right);
        this.cond = cond;
    }

    @Override
    public Expression order() {
        if (this.precedence() > this.cond.precedence()) {
            UnaryExpression e = (UnaryExpression)this.cond;
            this.cond = e.right;
            e.right = this.order();
            return e;
        }
        return this;
    }

    @Override
    public Vset checkValue(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        ConditionVars cvars = this.cond.checkCondition(env, ctx, vset, exp);
        vset = this.left.checkValue(env, ctx, cvars.vsTrue, exp).join(this.right.checkValue(env, ctx, cvars.vsFalse, exp));
        this.cond = this.convert(env, ctx, Type.tBoolean, this.cond);
        int tm = this.left.type.getTypeMask() | this.right.type.getTypeMask();
        if ((tm & 0x2000) != 0) {
            this.type = Type.tError;
            return vset;
        }
        if (this.left.type.equals(this.right.type)) {
            this.type = this.left.type;
        } else if ((tm & 0x80) != 0) {
            this.type = Type.tDouble;
        } else if ((tm & 0x40) != 0) {
            this.type = Type.tFloat;
        } else if ((tm & 0x20) != 0) {
            this.type = Type.tLong;
        } else if ((tm & 0x700) != 0) {
            try {
                this.type = env.implicitCast(this.right.type, this.left.type) ? this.left.type : this.right.type;
            }
            catch (ClassNotFound e) {
                this.type = Type.tError;
            }
        } else {
            this.type = (tm & 4) != 0 && this.left.fitsType(env, ctx, Type.tChar) && this.right.fitsType(env, ctx, Type.tChar) ? Type.tChar : ((tm & 8) != 0 && this.left.fitsType(env, ctx, Type.tShort) && this.right.fitsType(env, ctx, Type.tShort) ? Type.tShort : ((tm & 2) != 0 && this.left.fitsType(env, ctx, Type.tByte) && this.right.fitsType(env, ctx, Type.tByte) ? Type.tByte : Type.tInt));
        }
        this.left = this.convert(env, ctx, this.type, this.left);
        this.right = this.convert(env, ctx, this.type, this.right);
        return vset;
    }

    @Override
    public Vset check(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        vset = this.cond.checkValue(env, ctx, vset, exp);
        this.cond = this.convert(env, ctx, Type.tBoolean, this.cond);
        return this.left.check(env, ctx, vset.copy(), exp).join(this.right.check(env, ctx, vset, exp));
    }

    @Override
    public boolean isConstant() {
        return this.cond.isConstant() && this.left.isConstant() && this.right.isConstant();
    }

    @Override
    Expression simplify() {
        if (this.cond.equals(true)) {
            return this.left;
        }
        if (this.cond.equals(false)) {
            return this.right;
        }
        return this;
    }

    @Override
    public Expression inline(Environment env, Context ctx) {
        this.left = this.left.inline(env, ctx);
        this.right = this.right.inline(env, ctx);
        if (this.left == null && this.right == null) {
            return this.cond.inline(env, ctx);
        }
        if (this.left == null) {
            this.left = this.right;
            this.right = null;
            this.cond = new NotExpression(this.where, this.cond);
        }
        this.cond = this.cond.inlineValue(env, ctx);
        return this.simplify();
    }

    @Override
    public Expression inlineValue(Environment env, Context ctx) {
        this.cond = this.cond.inlineValue(env, ctx);
        this.left = this.left.inlineValue(env, ctx);
        this.right = this.right.inlineValue(env, ctx);
        return this.simplify();
    }

    @Override
    public int costInline(int thresh, Environment env, Context ctx) {
        return 1 + this.cond.costInline(thresh, env, ctx) + this.left.costInline(thresh, env, ctx) + (this.right == null ? 0 : this.right.costInline(thresh, env, ctx));
    }

    @Override
    public Expression copyInline(Context ctx) {
        ConditionalExpression e = (ConditionalExpression)this.clone();
        e.cond = this.cond.copyInline(ctx);
        e.left = this.left.copyInline(ctx);
        e.right = this.right == null ? null : this.right.copyInline(ctx);
        return e;
    }

    @Override
    public void codeValue(Environment env, Context ctx, Assembler asm) {
        Label l1 = new Label();
        Label l2 = new Label();
        this.cond.codeBranch(env, ctx, asm, l1, false);
        this.left.codeValue(env, ctx, asm);
        asm.add(this.where, 167, l2);
        asm.add(l1);
        this.right.codeValue(env, ctx, asm);
        asm.add(l2);
    }

    @Override
    public void code(Environment env, Context ctx, Assembler asm) {
        Label l1 = new Label();
        this.cond.codeBranch(env, ctx, asm, l1, false);
        this.left.code(env, ctx, asm);
        if (this.right != null) {
            Label l2 = new Label();
            asm.add(this.where, 167, l2);
            asm.add(l1);
            this.right.code(env, ctx, asm);
            asm.add(l2);
        } else {
            asm.add(l1);
        }
    }

    @Override
    public void print(PrintStream out) {
        out.print("(" + opNames[this.op] + " ");
        this.cond.print(out);
        out.print(" ");
        this.left.print(out);
        out.print(" ");
        if (this.right != null) {
            this.right.print(out);
        } else {
            out.print("<null>");
        }
        out.print(")");
    }
}

