/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.HK2Loader;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.HK2LoaderImpl;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigInjector;
import org.jvnet.hk2.config.ConfigurationException;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.tiger.Types;

public final class ConfigModel {
    public final ActiveDescriptor<? extends ConfigInjector> injector;
    final Map<String, AttributeLeaf> attributes = new HashMap<String, AttributeLeaf>();
    final Map<String, Property> elements = new HashMap<String, Property>();
    final Map<Method, Property> methodCache = new HashMap<Method, Property>();
    final List<String> contracts;
    final Set<String> symbolSpaces;
    final String tagName;
    public final HK2Loader classLoaderHolder;
    public final String targetTypeName;
    private Class targetTypeClass;
    public final String keyedAs;
    public final String key;
    private final ServiceLocator locator;
    private static final String INDEX_KEY = "index";
    private static final String ELEMENT_NAME_PREFIX = ConfigInjector.class.getName() + ":";

    public String getTagName() {
        return this.tagName;
    }

    public Set<String> getAttributeNames() {
        return Collections.unmodifiableSet(this.attributes.keySet());
    }

    public <T extends ConfigBeanProxy> Class<T> getProxyType() {
        if (this.targetTypeClass == null) {
            this.targetTypeClass = this.classLoaderHolder.loadClass(this.targetTypeName);
        }
        return this.targetTypeClass;
    }

    public Set<String> getLeafElementNames() {
        HashSet<String> results = new HashSet<String>();
        for (Map.Entry<String, Property> prop : this.elements.entrySet()) {
            if (!prop.getValue().isLeaf()) continue;
            results.add(prop.getKey());
        }
        return Collections.unmodifiableSet(results);
    }

    public Set<String> getElementNames() {
        return Collections.unmodifiableSet(this.elements.keySet());
    }

    public Property getElement(String elementName) {
        return this.elements.get(elementName);
    }

    public Property getElementFromXMlName(String xmlName) {
        Property cmp = this.findIgnoreCase(xmlName);
        if (cmp == null) {
            throw new IllegalArgumentException("Illegal name: " + xmlName);
        }
        return cmp;
    }

    void inject(Dom dom, Object target) {
        try {
            ((ConfigInjector)ServiceLocatorUtilities.getService((ServiceLocator)this.locator, this.injector)).inject(dom, target);
        }
        catch (ConfigurationException e) {
            e.setLocation(dom.getLocation());
            throw e;
        }
    }

    public Map<String, List<String>> getMetadata() {
        return this.injector.getMetadata();
    }

    public Property toProperty(Method method) {
        String an;
        String en;
        Property prop = this.methodCache.get(method);
        if (prop != null) {
            return prop;
        }
        String name = method.getName();
        Element e = method.getAnnotation(Element.class);
        if (e != null && (en = e.value()).length() > 0) {
            prop = this.elements.get(en);
            this.methodCache.put(method, prop);
            return prop;
        }
        Attribute a = method.getAnnotation(Attribute.class);
        if (a != null && (an = a.value()).length() > 0) {
            prop = this.attributes.get(an);
            this.methodCache.put(method, prop);
            return prop;
        }
        for (String p : Dom.PROPERTY_PREFIX) {
            if (!name.startsWith(p)) continue;
            name = name.substring(p.length());
            break;
        }
        name = ConfigModel.camelCaseToXML(name);
        prop = this.findIgnoreCase(name);
        this.methodCache.put(method, prop);
        return prop;
    }

    public static String trimPrefix(String name) {
        for (String p : Dom.PROPERTY_PREFIX) {
            if (!name.startsWith(p)) continue;
            name = name.substring(p.length());
            break;
        }
        return name.toLowerCase(Locale.ENGLISH).charAt(0) + name.substring(1);
    }

    public static String camelCaseToXML(String camelCase) {
        StringBuilder buf = new StringBuilder(camelCase.length() + 5);
        for (String t : Dom.TOKENIZER.split(camelCase)) {
            if (buf.length() > 0) {
                buf.append('-');
            }
            buf.append(t.toLowerCase(Locale.ENGLISH));
        }
        return buf.toString();
    }

    public ConfigModel(DomDocument document, ActiveDescriptor<? extends ConfigInjector> injector, Map<String, List<String>> description, ServiceLocator locator) {
        if (description == null) {
            throw new ConfigurationException("%s doesn't have any metadata", injector.getImplementation());
        }
        document.models.put(injector, this);
        this.injector = injector;
        this.classLoaderHolder = new SafeHk2Loader((HK2Loader)(injector.getLoader() == null ? new HK2LoaderImpl() : injector.getLoader()));
        this.locator = locator;
        String targetTypeName = null;
        String indexTypeName = null;
        String key = null;
        for (Map.Entry<String, List<String>> e : description.entrySet()) {
            String value;
            String name = e.getKey();
            String string = value = e.getValue().size() > 0 ? e.getValue().get(0) : null;
            if (name.startsWith("@")) {
                String attributeName = name.substring(1);
                String dv = ConfigModel.getMetadataFieldKeyedAs(e.getValue(), "default:");
                String dt = ConfigModel.getMetadataFieldKeyedAs(e.getValue(), "datatype:");
                AttributeLeaf leaf = null;
                leaf = dv == null ? (e.getValue().contains("reference") ? new ReferenceAttributeLeaf(attributeName, dt) : new AttributeLeaf(attributeName, dt)) : new AttributeLeafWithDefaultValue(attributeName, dt, dv);
                this.attributes.put(attributeName, leaf);
                continue;
            }
            if (name.startsWith("<")) {
                if (e.getValue().size() <= 0) continue;
                String elementName = name.substring(1, name.length() - 1);
                this.elements.put(elementName, this.parseValue(elementName, document, e.getValue()));
                continue;
            }
            if (name.equals("target")) {
                targetTypeName = value;
                continue;
            }
            if (name.equals("keyed-as")) {
                indexTypeName = value;
                continue;
            }
            if (!name.equals("key")) continue;
            key = value;
        }
        if (targetTypeName == null) {
            throw new ConfigurationException("%s doesn't have the mandatory '%s' metadata", injector.getImplementation(), "target");
        }
        if (key == null ^ indexTypeName == null) {
            throw new ConfigurationException("%s has inconsistent '%s=%s' and '%s=%s' metadata", injector.getImplementation(), "key", key, "target", indexTypeName);
        }
        this.targetTypeName = targetTypeName;
        this.keyedAs = indexTypeName;
        this.key = key;
        this.contracts = ConfigModel.getMetadataFromDescription(description, "target-contracts");
        this.symbolSpaces = new HashSet<String>(ConfigModel.getMetadataFromDescription(description, "symbolSpaces"));
        String tagName = null;
        for (String v : ConfigModel.getMetadataFromDescription(description, INDEX_KEY)) {
            if (!v.startsWith(ELEMENT_NAME_PREFIX)) continue;
            tagName = v.substring(ELEMENT_NAME_PREFIX.length());
        }
        this.tagName = tagName == null ? injector.getName() : tagName;
    }

    public Property findIgnoreCase(String xmlName) {
        Property a = this.attributes.get(xmlName);
        if (a != null) {
            return a;
        }
        a = this.elements.get(xmlName);
        if (a != null) {
            return a;
        }
        a = this._findIgnoreCase(xmlName, this.attributes);
        if (a != null) {
            return a;
        }
        return this._findIgnoreCase(xmlName, this.elements);
    }

    private Property _findIgnoreCase(String name, Map<String, ? extends Property> map) {
        for (Map.Entry<String, ? extends Property> i : map.entrySet()) {
            if (!i.getKey().equalsIgnoreCase(name)) continue;
            return i.getValue();
        }
        return null;
    }

    private Property parseValue(String elementName, DomDocument document, List<String> values) {
        Property prop;
        String value;
        String string = value = values.size() > 0 ? values.get(0) : null;
        if (value == null) {
            return null;
        }
        boolean collection = false;
        if (value.startsWith("collection:")) {
            collection = true;
            value = value.substring(11);
        }
        boolean reference = values.contains("reference");
        if (value.equals("leaf")) {
            prop = collection ? (reference ? new ReferenceCollectionLeaf(elementName) : new CollectionLeaf(elementName)) : (reference ? new ReferenceElementLeaf(elementName) : new SingleLeaf(elementName));
        } else {
            ConfigModel model = document.buildModel(value);
            prop = collection ? new CollectionNode(model, elementName) : new SingleNode(model, elementName);
        }
        for (String s : values) {
            if (!s.startsWith("@")) continue;
            String annotationType = s.substring(1);
            prop.annotations.add(annotationType);
        }
        return prop;
    }

    private static String getMetadataFieldKeyedAs(List<String> strings, String name) {
        if (strings == null || strings.size() == 0 || name == null) {
            return null;
        }
        String dv = null;
        for (String s : strings) {
            if (!s.startsWith(name)) continue;
            dv = s.substring(name.length());
            break;
        }
        return dv;
    }

    private static List<String> getMetadataFromDescription(Map<String, List<String>> map, String key) {
        return map.get(key) == null ? Collections.EMPTY_LIST : map.get(key);
    }

    public static abstract class Property {
        public final List<String> annotations = new ArrayList<String>();
        public final String xmlName;

        protected Property(String xmlName) {
            this.xmlName = xmlName;
        }

        public final String xmlName() {
            return this.xmlName;
        }

        public abstract boolean isLeaf();

        public abstract boolean isCollection();

        public abstract Object get(Dom var1, Type var2);

        public abstract void set(Dom var1, Object var2);

        public List<String> getAnnotations() {
            return this.annotations;
        }
    }

    private static class SafeHk2Loader
    implements HK2Loader {
        private final HK2Loader delegate;

        private SafeHk2Loader(HK2Loader delegate) {
            this.delegate = delegate;
        }

        public Class<?> loadClass(final String className) throws MultiException {
            return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

                @Override
                public Class<?> run() {
                    return delegate.loadClass(className);
                }
            });
        }
    }

    static final class ReferenceAttributeLeaf
    extends AttributeLeaf {
        ReferenceAttributeLeaf(String xmlName, String dataType) {
            super(xmlName, dataType);
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public Object get(Dom dom, Type returnType) {
            String id = dom.attribute(this.xmlName);
            if (id == null) {
                return null;
            }
            Class type = Types.erasure(returnType);
            Object candidate = dom.getHabitat().getService(type, id, new Annotation[0]);
            if (candidate != null) {
                return type.cast(candidate);
            }
            dom = dom.getSymbolSpaceRoot(id);
            return type.cast(dom.resolveReference(id, type.getName()).get());
        }

        @Override
        public void set(Dom dom, Object arg) {
            Dom target = (Dom)arg;
            dom.attribute(this.xmlName, arg == null ? null : target.getKey());
        }
    }

    static class AttributeLeaf
    extends Leaf {
        public final String dataType;

        AttributeLeaf(String xmlName, String dataType) {
            super(xmlName);
            this.dataType = dataType;
        }

        @Override
        public boolean isCollection() {
            return false;
        }

        public boolean isReference() {
            return false;
        }

        @Override
        public Object get(Dom dom, Type returnType) {
            String v = dom.attribute(this.xmlName);
            return this.convertLeafValue(dom, Types.erasure(returnType), v);
        }

        @Override
        public void set(Dom dom, Object arg) {
            dom.attribute(this.xmlName, arg == null ? null : arg.toString());
        }

        public String getDefaultValue() {
            return null;
        }
    }

    static final class AttributeLeafWithDefaultValue
    extends AttributeLeaf {
        public final String dv;

        AttributeLeafWithDefaultValue(String xmlName, String dataType, String dv) {
            super(xmlName, dataType);
            this.dv = dv;
        }

        @Override
        public Object get(Dom dom, Type rt) {
            Object value = super.get(dom, rt);
            if (value == null) {
                return this.dv;
            }
            return value;
        }

        @Override
        public String getDefaultValue() {
            return this.dv;
        }
    }

    final class ReferenceCollectionLeaf
    extends CollectionLeaf {
        ReferenceCollectionLeaf(String xmlName) {
            super(xmlName);
        }

        @Override
        protected Object convertLeafValue(Dom parent, Class<?> returnType, String v) {
            Object candidate = parent.getHabitat().getService(returnType, v, new Annotation[0]);
            if (candidate != null) {
                return returnType.cast(candidate);
            }
            Dom dom = (parent = parent.getSymbolSpaceRoot(v)).resolveReference(v, returnType.getName());
            if (dom != null) {
                return returnType.cast(dom.get());
            }
            throw new IllegalArgumentException("Cannot find an instance of " + String.valueOf(returnType) + " named " + v);
        }

        @Override
        String elementValue(Object element) {
            return Dom.unwrap((ConfigBeanProxy)element).getKey();
        }
    }

    static class CollectionLeaf
    extends Leaf {
        CollectionLeaf(String xmlName) {
            super(xmlName);
        }

        @Override
        public boolean isCollection() {
            return true;
        }

        String elementValue(Object element) {
            return element.toString();
        }

        @Override
        public Object get(final Dom dom, Type returnType) {
            final List<String> v = dom.leafElements(this.xmlName);
            if (!(returnType instanceof ParameterizedType)) {
                throw new IllegalArgumentException("List needs to be parameterized");
            }
            final Class itemType = Types.erasure(Types.getTypeArgument(returnType, 0));
            return new AbstractList<Object>(){

                @Override
                public Object get(int index) {
                    return this.convertLeafValue(dom, itemType, (String)v.get(index));
                }

                @Override
                public void add(int index, Object element) {
                    dom.addLeafElement(xmlName, this.elementValue(element));
                    v.add(index, element.toString());
                }

                @Override
                public Object remove(int index) {
                    dom.removeLeafElement(xmlName, (String)v.get(index));
                    return v.remove(index);
                }

                @Override
                public Object set(int index, Object element) {
                    dom.changeLeafElement(xmlName, (String)v.get(index), this.elementValue(element));
                    return v.set(index, element.toString());
                }

                @Override
                public int size() {
                    return v.size();
                }
            };
        }

        @Override
        public void set(Dom dom, Object arg) {
            if (!(arg instanceof List)) {
                throw new UnsupportedOperationException();
            }
            String[] strings = new String[((List)arg).size()];
            dom.setLeafElements(this.xmlName, ((List)arg).toArray(strings));
        }
    }

    static final class ReferenceElementLeaf
    extends Leaf {
        public ReferenceElementLeaf(String xmlName) {
            super(xmlName);
        }

        @Override
        public boolean isCollection() {
            return false;
        }

        @Override
        public Object get(Dom dom, Type returnType) {
            String id = dom.leafElement(this.xmlName);
            Class type = Types.erasure(returnType);
            Object candidate = dom.getHabitat().getService(type, id, new Annotation[0]);
            if (candidate != null) {
                return type.cast(candidate);
            }
            dom = dom.getSymbolSpaceRoot(id);
            return type.cast(dom.resolveReference(id, type.getName()).get());
        }

        @Override
        public void set(Dom dom, Object arg) {
            if (arg == null) {
                dom.removeLeafElement(this.xmlName, dom.leafElement(this.xmlName));
            } else {
                dom.setLeafElements(this.xmlName, ((Dom)arg).getKey());
            }
        }
    }

    static final class SingleLeaf
    extends Leaf {
        SingleLeaf(String xmlName) {
            super(xmlName);
        }

        @Override
        public boolean isCollection() {
            return false;
        }

        @Override
        public Object get(Dom dom, Type returnType) {
            String v = dom.leafElement(this.xmlName);
            return this.convertLeafValue(dom, Types.erasure(returnType), v);
        }

        @Override
        public void set(Dom dom, Object arg) {
            if (arg == null) {
                dom.removeLeafElement(this.xmlName, dom.leafElement(this.xmlName));
            } else {
                dom.setLeafElements(this.xmlName, arg.toString());
            }
        }
    }

    static final class CollectionNode
    extends Node {
        CollectionNode(ConfigModel model, String xmlName) {
            super(model, xmlName);
        }

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public Object get(final Dom dom, Type returnType) {
            List<Dom> v;
            if (!(returnType instanceof ParameterizedType)) {
                throw new IllegalArgumentException("List needs to be parameterized");
            }
            Class itemType = Types.erasure(Types.getTypeArgument(returnType, 0));
            List<Dom> list = v = "*".equals(this.xmlName) ? dom.domNodeByTypeElements(itemType) : dom.nodeElements(this.xmlName);
            if (itemType == Dom.class) {
                return v;
            }
            if (ConfigBeanProxy.class.isAssignableFrom(itemType)) {
                return new AbstractList<Object>(){

                    @Override
                    public Object get(int index) {
                        return ((Dom)v.get(index)).createProxy();
                    }

                    @Override
                    public void add(int index, Object element) {
                        Dom child = Dom.unwrap((ConfigBeanProxy)element);
                        dom.insertAfter(index == 0 ? null : (Dom)v.get(index - 1), xmlName, child);
                        v.add(index, child);
                    }

                    @Override
                    public Object remove(int index) {
                        Dom child = (Dom)v.get(index);
                        dom.removeChild(child);
                        v.remove(index);
                        return child.createProxy();
                    }

                    @Override
                    public Object set(int index, Object element) {
                        Dom child = Dom.unwrap((ConfigBeanProxy)element);
                        String name = "*".equals(xmlName) ? child.model.injector.getName() : xmlName;
                        dom.replaceChild((Dom)v.get(index), name, child);
                        return v.set(index, child).createProxy();
                    }

                    @Override
                    public int size() {
                        return v.size();
                    }
                };
            }
            return new AbstractList(){

                @Override
                public Object get(int index) {
                    return ((Dom)v.get(index)).get();
                }

                @Override
                public int size() {
                    return v.size();
                }
            };
        }

        @Override
        public void set(Dom dom, Object _arg) {
            if (!(_arg instanceof List)) {
                throw new IllegalArgumentException("Expecting a list but found " + String.valueOf(_arg));
            }
            List arg = (List)_arg;
            Dom[] values = new Dom[arg.size()];
            int i = 0;
            for (Object o : arg) {
                values[i++] = this.toDom(o);
            }
            dom.setNodeElements(this.xmlName, values);
        }
    }

    static final class SingleNode
    extends Node {
        SingleNode(ConfigModel model, String xmlName) {
            super(model, xmlName);
        }

        @Override
        public boolean isCollection() {
            return false;
        }

        @Override
        public Object get(Dom dom, Type returnType) {
            Dom v = dom.nodeElement(this.xmlName);
            if (v == null) {
                return null;
            }
            if (returnType == Dom.class) {
                return v;
            }
            Class rt = Types.erasure(returnType);
            if (ConfigBeanProxy.class.isAssignableFrom(rt)) {
                return v.createProxy();
            }
            throw new IllegalArgumentException("Invalid type " + String.valueOf(returnType) + " for " + this.xmlName);
        }

        @Override
        public void set(Dom dom, Object arg) {
            Dom child = this.toDom(arg);
            if (child == null) {
                dom.setNodeElements(this.xmlName, new Dom[0]);
            } else {
                dom.setNodeElements(this.xmlName, child);
            }
        }
    }

    static abstract class Leaf
    extends Property {
        private static final Set<String> BOOLEAN_TRUE = new HashSet<String>(Arrays.asList("true", "yes", "on", "1"));

        public Leaf(String xmlName) {
            super(xmlName);
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        protected Object convertLeafValue(Dom parent, Class<?> returnType, String v) {
            if (v == null) {
                return null;
            }
            if (returnType == String.class) {
                return v;
            }
            if (returnType == Long.class || returnType == Long.TYPE) {
                return Long.valueOf(v);
            }
            if (returnType == Integer.class || returnType == Integer.TYPE) {
                return Integer.valueOf(v);
            }
            if (returnType == Boolean.class || returnType == Boolean.TYPE) {
                return BOOLEAN_TRUE.contains(v);
            }
            throw new IllegalArgumentException("Don't know how to handle " + String.valueOf(returnType));
        }
    }

    public static abstract class Node
    extends Property {
        final ConfigModel model;

        public Node(ConfigModel model, String xmlName) {
            super(xmlName);
            this.model = model;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        public ConfigModel getModel() {
            return this.model;
        }

        protected final Dom toDom(Object arg) {
            if (arg == null) {
                return null;
            }
            if (arg instanceof Dom) {
                return (Dom)arg;
            }
            if (arg instanceof ConfigBeanProxy) {
                return Dom.unwrap((ConfigBeanProxy)arg);
            }
            throw new IllegalArgumentException("Unexpected type " + String.valueOf(arg.getClass()) + " for " + this.xmlName);
        }
    }
}

