/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import jakarta.inject.Singleton;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.api.admin.progress.JobInfo;
import org.glassfish.api.admin.progress.JobInfos;
import org.glassfish.api.admin.progress.JobPersistence;
import org.jvnet.hk2.annotations.Service;

@Service(name="job-persistence")
@Singleton
public class JobPersistenceService
implements JobPersistence {
    private static final JAXBContext JAXB_CTX;

    public synchronized JobInfos load(File file) {
        try {
            if (file.exists()) {
                Unmarshaller unmarshaller = JAXB_CTX.createUnmarshaller();
                return (JobInfos)unmarshaller.unmarshal(file);
            }
            return new JobInfos();
        }
        catch (JAXBException e) {
            throw new RuntimeException("Error loading completed jobs from " + String.valueOf(file), e);
        }
    }

    public synchronized JobInfos add(JobInfo job) {
        File jobsFile = job.getJobsFile();
        JobInfos completedjobs = this.load(jobsFile);
        List jobs = completedjobs.getJobInfoList();
        if (JobPersistenceService.contains(jobs, job)) {
            throw new IllegalArgumentException("Provided job is already contained in the file: " + String.valueOf(job));
        }
        jobs.add(job);
        return this.persist(jobs, jobsFile);
    }

    public synchronized JobInfos remove(JobInfo job) {
        File jobsFile = job.getJobsFile();
        JobInfos completedjobs = this.load(jobsFile);
        List oldList = completedjobs.getJobInfoList();
        ArrayList<JobInfo> newList = new ArrayList<JobInfo>(oldList.size());
        for (JobInfo jobInfo : oldList) {
            if (jobInfo.jobId.equals(job.jobId)) continue;
            newList.add(jobInfo);
        }
        return this.persist(newList, jobsFile);
    }

    private JobInfos persist(List<JobInfo> jobList, File jobsFile) {
        try {
            JobInfos jobs = new JobInfos();
            jobs.setJobInfoList(jobList);
            Marshaller jaxbMarshaller = JAXB_CTX.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.marshal((Object)jobs, jobsFile);
            return jobs;
        }
        catch (JAXBException e) {
            throw new RuntimeException("Error persisting job list.", e);
        }
    }

    private static boolean contains(List<JobInfo> jobs, JobInfo job) {
        for (JobInfo jobInfo : jobs) {
            if (!jobInfo.jobId.equals(job.jobId)) continue;
            return true;
        }
        return false;
    }

    static {
        try {
            JAXB_CTX = JAXBContext.newInstance((Class[])new Class[]{JobInfos.class});
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Unable to initializa JAXB for JobPersistenceService!", e);
        }
    }
}

