/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.v3.admin.AdminCommandJob;
import com.sun.enterprise.v3.admin.DefaultJobManagerFile;
import com.sun.enterprise.v3.admin.JobManagerService;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AuthorizationPreprocessor;
import org.glassfish.api.admin.progress.JobInfo;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class JobAuthorizationAttributeProcessor
implements AuthorizationPreprocessor {
    private static final String USER_ATTRIBUTE_NAME = "user";
    public static final String JOB_RESOURCE_NAME_PREFIX_NO_SLASH = "jobs/job";
    public static final String JOB_RESOURCE_NAME_PREFIX = "jobs/job/";
    public static final Pattern JOB_PATTERN = Pattern.compile("(?:jobs/job(?:/(\\d*))?)");
    @Inject
    private JobManagerService jobManager;
    @Inject
    private DefaultJobManagerFile defaultJobFile;

    public void describeAuthorization(Subject subject, String resourceName, String action, AdminCommand command, Map<String, Object> context, Map<String, String> subjectAttributes, Map<String, String> resourceAttributes, Map<String, String> actionAttributes) {
        JobInfo jobInfo;
        Matcher m = JOB_PATTERN.matcher(resourceName);
        if (!m.matches() || m.groupCount() == 0) {
            return;
        }
        String jobID = m.group(1);
        AdminCommandJob job = this.jobManager.get(jobID);
        String userID = job == null || job.getSubjectUsernames().isEmpty() ? ((jobInfo = this.jobManager.getCompletedJobForId(jobID, this.defaultJobFile.getFile())) == null ? null : jobInfo.user) : (String)job.getSubjectUsernames().get(0);
        if (userID != null) {
            resourceAttributes.put(USER_ATTRIBUTE_NAME, userID);
        }
    }
}

