/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.helper.ComplexDatabaseType;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.queries.PLSQLComplexTypeMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.PLSQLParameterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLargument;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLrecord;

public class PLSQLRecordMetadata
extends PLSQLComplexTypeMetadata {
    private List<PLSQLParameterMetadata> fields = new ArrayList<PLSQLParameterMetadata>();

    public PLSQLRecordMetadata() {
        super("<plsql-record>");
    }

    public PLSQLRecordMetadata(MetadataAnnotation record, MetadataAccessor accessor) {
        super(record, accessor);
        for (Object field : record.getAttributeArray("fields")) {
            this.fields.add(new PLSQLParameterMetadata((MetadataAnnotation)field, accessor));
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        PLSQLRecordMetadata parameter;
        if (objectToCompare instanceof PLSQLRecordMetadata && !this.valuesMatch(this.fields, (parameter = (PLSQLRecordMetadata)objectToCompare).getFields())) {
            return false;
        }
        return super.equals(objectToCompare);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.fields != null ? this.fields.hashCode() : 0);
        return result;
    }

    public List<PLSQLParameterMetadata> getFields() {
        return this.fields;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObjects(this.fields, accessibleObject);
    }

    public PLSQLrecord process() {
        PLSQLrecord record = new PLSQLrecord();
        super.process((ComplexDatabaseType)record);
        for (PLSQLParameterMetadata field : this.fields) {
            PLSQLargument argument = new PLSQLargument();
            argument.name = field.getName();
            argument.databaseType = this.getDatabaseTypeEnum(field.getDatabaseType());
            if (field.getLength() != null) {
                argument.length = field.getLength();
            }
            if (field.getPrecision() != null) {
                argument.precision = field.getPrecision();
            }
            if (field.getScale() != null) {
                argument.scale = field.getScale();
            }
            record.addField(argument);
        }
        return record;
    }

    public void setFields(List<PLSQLParameterMetadata> fields) {
        this.fields = fields;
    }

    @Override
    public boolean isPLSQLRecordMetadata() {
        return true;
    }
}

