/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.deploy.shared;

import com.sun.enterprise.deployment.deploy.shared.JarArchive;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.jvnet.hk2.annotations.Service;

@Service(name="jar")
@PerLookup
public class InputJarArchive
extends JarArchive
implements ReadableArchive {
    public static final Logger deplLogger = DeploymentContextImpl.deplLogger;
    private static StringManager localStrings = StringManager.getManager(InputJarArchive.class);
    @LogMessageInfo(message=" file open failure; file = {0}", level="WARNING")
    private static final String FILE_OPEN_FAILURE = "NCLS-DEPLOYMENT-00019";
    @LogMessageInfo(message="exception message:  {0} -- invalid zip file: {1}", level="WARNING")
    private static final String INVALID_ZIP_FILE = "NCLS-DEPLOYMENT-00020";
    protected volatile JarFile jarFile;
    protected volatile JarInputStream jarIS;
    private volatile URI uri;
    private InputJarArchive parentArchive;
    private final WeakHashMap<EntryEnumeration, Object> entryEnumerations = new WeakHashMap();

    public InputJarArchive(File file) throws IOException {
        this.open(file.toURI());
    }

    public InputJarArchive() {
    }

    public void open(URI uri) throws IOException {
        this.uri = uri;
        this.jarFile = InputJarArchive.getJarFile(uri);
    }

    public long getArchiveSize() throws NullPointerException, SecurityException {
        if (this.uri == null) {
            return -1L;
        }
        return new File(this.uri).length();
    }

    public Collection<String> getDirectories() throws IOException {
        return new CollectionWrappedEnumeration<String>(new CollectionWrappedEnumeration.EnumerationFactory<String>(){

            @Override
            public Enumeration<String> enumeration() {
                return InputJarArchive.this.entries(true);
            }
        });
    }

    public Enumeration<String> entries() {
        return this.entries(false);
    }

    @Override
    public JarEntry getJarEntry(String name) {
        if (this.jarFile == null) {
            return null;
        }
        return this.jarFile.getJarEntry(name);
    }

    public boolean exists() {
        return this.jarFile != null;
    }

    @Override
    public boolean exists(String name) throws IOException {
        if (this.jarFile == null) {
            return false;
        }
        return this.jarFile.getEntry(name) != null;
    }

    public InputStream getEntry(String entryName) throws IOException {
        JarEntry jarEntry;
        JarEntry archiveJarEntry;
        if (this.jarFile != null) {
            ZipEntry zipEntry = this.jarFile.getEntry(entryName);
            if (zipEntry == null) {
                return null;
            }
            return new BufferedInputStream(this.jarFile.getInputStream(zipEntry));
        }
        if (this.parentArchive == null || this.parentArchive.jarFile == null) {
            return null;
        }
        if (this.jarIS != null) {
            this.jarIS.close();
        }
        JarEntry jarEntry2 = archiveJarEntry = this.uri != null ? this.parentArchive.jarFile.getJarEntry(this.uri.getSchemeSpecificPart()) : null;
        if (archiveJarEntry == null) {
            return null;
        }
        this.jarIS = new JarInputStream(this.parentArchive.jarFile.getInputStream(archiveJarEntry));
        while ((jarEntry = this.jarIS.getNextJarEntry()) != null && !jarEntry.getName().equals(entryName)) {
        }
        if (jarEntry == null) {
            return null;
        }
        return new BufferedInputStream(this.jarIS);
    }

    public long getEntrySize(String name) {
        if (this.jarFile == null) {
            return 0L;
        }
        ZipEntry zipEntry = this.jarFile.getEntry(name);
        if (zipEntry == null) {
            return 0L;
        }
        return zipEntry.getSize();
    }

    public Manifest getManifest() throws IOException {
        InputStream is;
        Manifest manifest;
        if (this.jarFile != null) {
            return this.jarFile.getManifest();
        }
        if (this.parentArchive == null) {
            return null;
        }
        if (this.jarIS != null) {
            this.jarIS.close();
        }
        if (this.jarIS == null) {
            this.jarIS = new JarInputStream(this.parentArchive.jarFile.getInputStream(this.parentArchive.jarFile.getJarEntry(this.uri.getSchemeSpecificPart())));
        }
        if ((manifest = this.jarIS.getManifest()) == null && (is = this.getEntry("META-INF/MANIFEST.MF")) != null) {
            manifest = new Manifest();
            manifest.read(is);
            is.close();
        }
        return manifest;
    }

    public URI getURI() {
        return this.uri;
    }

    public boolean delete() {
        if (this.jarFile == null) {
            return false;
        }
        try {
            this.jarFile.close();
            this.jarFile = null;
        }
        catch (IOException ioe) {
            return false;
        }
        return FileUtils.deleteFile((File)new File(this.uri));
    }

    public boolean renameTo(String name) {
        if (this.jarFile == null) {
            return false;
        }
        try {
            this.jarFile.close();
            this.jarFile = null;
        }
        catch (IOException ioe) {
            return false;
        }
        return FileUtils.renameFile((File)new File(this.uri), (File)new File(name));
    }

    public ReadableArchive getSubArchive(String name) throws IOException {
        if (this.jarFile != null) {
            InputJarArchive ija = new InputJarArchive();
            JarEntry je = this.jarFile.getJarEntry(name);
            if (je != null) {
                JarInputStream jis = new JarInputStream(new BufferedInputStream(this.jarFile.getInputStream(je)));
                try {
                    ija.uri = new URI("jar", name, null);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                ija.jarIS = jis;
                ija.parentArchive = this;
                return ija;
            }
        }
        return null;
    }

    public synchronized void close() throws IOException {
        for (EntryEnumeration e : this.entryEnumerations.keySet()) {
            e.closeNoRemove();
        }
        this.entryEnumerations.clear();
        if (this.jarFile != null) {
            this.jarFile.close();
            this.jarFile = null;
        }
        if (this.jarIS != null) {
            this.jarIS.close();
            this.jarIS = null;
        }
    }

    public Enumeration entries(Enumeration embeddedArchives) {
        return this.entries();
    }

    public OutputStream addEntry(String name) throws IOException {
        throw new UnsupportedOperationException("Cannot write to an JAR archive open for reading");
    }

    public void create(URI uri) throws IOException {
        throw new UnsupportedOperationException("Cannot write to an JAR archive open for reading");
    }

    private synchronized EntryEnumeration recordEntryEnumeration(EntryEnumeration e) {
        this.entryEnumerations.put(e, null);
        return e;
    }

    private Enumeration<String> entries(boolean topLevelDirectoriesOnly) {
        try {
            return this.recordEntryEnumeration(this.createEntryEnumeration(topLevelDirectoriesOnly));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected static JarFile getJarFile(URI uri) throws IOException {
        JarFile jarFile = null;
        try {
            File file = new File(uri);
            if (file.exists()) {
                jarFile = new JarFile(file);
            }
        }
        catch (IOException e) {
            deplLogger.log(Level.WARNING, FILE_OPEN_FAILURE, new Object[]{uri});
            String additionalInfo = localStrings.getString("enterprise.deployment.invalid_zip_file", (Object)uri);
            deplLogger.log(Level.WARNING, INVALID_ZIP_FILE, new Object[]{e.getLocalizedMessage(), additionalInfo});
        }
        return jarFile;
    }

    private EntryEnumeration createEntryEnumeration(boolean topLevelDirectoriesOnly) throws FileNotFoundException, IOException {
        JarEntrySource source;
        JarEntrySource jarEntrySource = source = this.parentArchive == null ? new ArchiveJarEntrySource(this.uri) : new SubarchiveJarEntrySource(this.parentArchive.jarFile, this.uri);
        if (topLevelDirectoriesOnly) {
            return new TopLevelDirectoryEntryEnumeration(source);
        }
        return new NonDirectoryEntryEnumeration(source);
    }

    static class CollectionWrappedEnumeration<T>
    extends AbstractCollection<T> {
        private ArrayList<T> entries = null;
        private int nextSlot = 0;
        private final EnumerationFactory<T> factory;
        private Enumeration<T> e;

        CollectionWrappedEnumeration(EnumerationFactory<T> factory) {
            this.factory = factory;
            this.e = factory.enumeration();
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return entries != null ? nextSlot < entries.size() : e.hasMoreElements();
                }

                @Override
                public T next() {
                    Object result = null;
                    if (entries != null) {
                        if (nextSlot >= entries.size()) {
                            throw new NoSuchElementException();
                        }
                        result = entries.get(nextSlot++);
                    } else {
                        result = e.nextElement();
                        ++nextSlot;
                    }
                    return result;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            if (this.entries == null) {
                this.populateEntries();
            }
            return this.entries.size();
        }

        private void populateEntries() {
            this.entries = new ArrayList();
            Enumeration<T> newE = this.factory.enumeration();
            while (newE.hasMoreElements()) {
                this.entries.add(newE.nextElement());
            }
            this.e = null;
        }

        static interface EnumerationFactory<T> {
            public Enumeration<T> enumeration();
        }
    }

    private abstract class EntryEnumeration
    implements Enumeration<String> {
        private JarEntry nextMatchingEntry;
        private final JarEntrySource jarEntrySource;

        private EntryEnumeration(JarEntrySource jarEntrySource) {
            this.jarEntrySource = jarEntrySource;
        }

        protected void completeInit() {
            this.nextMatchingEntry = this.skipToNextMatchingEntry();
        }

        @Override
        public boolean hasMoreElements() {
            return this.nextMatchingEntry != null;
        }

        @Override
        public String nextElement() {
            if (this.nextMatchingEntry == null) {
                throw new NoSuchElementException();
            }
            String answer = this.nextMatchingEntry.getName();
            this.nextMatchingEntry = this.skipToNextMatchingEntry();
            return answer;
        }

        protected JarEntry getNextJarEntry() throws IOException {
            return this.jarEntrySource.getNextJarEntry();
        }

        protected abstract JarEntry skipToNextMatchingEntry();

        private void closeNoRemove() {
            try {
                this.jarEntrySource.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        void close() {
            this.closeNoRemove();
            InputJarArchive.this.entryEnumerations.remove(this);
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.close();
        }
    }

    private static class ArchiveJarEntrySource
    implements JarEntrySource {
        private final JarFile sourceJarFile;
        private final Enumeration<JarEntry> jarEntries;

        private ArchiveJarEntrySource(URI archiveURI) throws IOException {
            this.sourceJarFile = InputJarArchive.getJarFile(archiveURI);
            if (this.sourceJarFile == null) {
                throw new IOException(localStrings.getString("enterprise.deployment.invalid_zip_file", (Object)archiveURI));
            }
            this.jarEntries = this.sourceJarFile.entries();
        }

        @Override
        public JarEntry getNextJarEntry() {
            return this.jarEntries.hasMoreElements() ? this.jarEntries.nextElement() : null;
        }

        @Override
        public void close() throws IOException {
            this.sourceJarFile.close();
        }
    }

    private static class SubarchiveJarEntrySource
    implements JarEntrySource {
        private final JarInputStream jis;

        private SubarchiveJarEntrySource(JarFile jf, URI uri) throws IOException {
            JarEntry subarchiveJarEntry = jf.getJarEntry(uri.getSchemeSpecificPart());
            this.jis = new JarInputStream(jf.getInputStream(subarchiveJarEntry));
        }

        @Override
        public JarEntry getNextJarEntry() throws IOException {
            return this.jis.getNextJarEntry();
        }

        @Override
        public void close() throws IOException {
            this.jis.close();
        }
    }

    private class TopLevelDirectoryEntryEnumeration
    extends EntryEnumeration {
        private TopLevelDirectoryEntryEnumeration(JarEntrySource jarEntrySource) throws FileNotFoundException, IOException {
            super(jarEntrySource);
            this.completeInit();
        }

        @Override
        protected JarEntry skipToNextMatchingEntry() {
            try {
                JarEntry candidateNextEntry;
                while ((candidateNextEntry = this.getNextJarEntry()) != null) {
                    String candidateNextEntryName = candidateNextEntry.getName();
                    if (!candidateNextEntry.isDirectory() || candidateNextEntryName.indexOf(47) != candidateNextEntryName.lastIndexOf(47) || candidateNextEntryName.indexOf(47) != candidateNextEntryName.length() - 1) continue;
                    break;
                }
                return candidateNextEntry;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static interface JarEntrySource {
        public JarEntry getNextJarEntry() throws IOException;

        public void close() throws IOException;
    }

    private class NonDirectoryEntryEnumeration
    extends EntryEnumeration {
        private NonDirectoryEntryEnumeration(JarEntrySource jarEntrySource) throws IOException {
            super(jarEntrySource);
            this.completeInit();
        }

        @Override
        protected JarEntry skipToNextMatchingEntry() {
            try {
                JarEntry candidateNextEntry;
                while ((candidateNextEntry = this.getNextJarEntry()) != null) {
                    String candidateNextEntryName = candidateNextEntry.getName();
                    if (candidateNextEntry.isDirectory() || candidateNextEntryName.equals("META-INF/MANIFEST.MF")) continue;
                    break;
                }
                return candidateNextEntry;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

