/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.ForUpdateClause;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.LoadGroup;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;

public abstract class ObjectBuildingQuery
extends ReadQuery {
    protected Class<?> referenceClass;
    protected String referenceClassName;
    protected boolean shouldRefreshIdentityMapResult = false;
    protected boolean shouldRefreshRemoteIdentityMapResult;
    protected boolean shouldRegisterResultsInUnitOfWork = true;
    protected ForUpdateClause lockingClause;
    public static final short NO_LOCK = 0;
    public static final short LOCK = 1;
    public static final short LOCK_NOWAIT = 2;
    public static final short DEFAULT_LOCK_MODE = -1;
    protected long executionTime = 0L;
    protected boolean shouldUseExclusiveConnection = false;
    public static final String LOCK_RESULT_PROPERTY = "LOCK_RESULT";
    protected boolean wasDefaultLockMode = false;
    protected boolean shouldBuildNullForNullPk;
    protected Boolean requiresDeferredLocks = null;
    protected boolean isCacheCheckComplete = false;
    protected Map<Object, CacheKey> prefetchedCacheKeys;
    protected Boolean printInnerJoinInWhereClause;

    protected ObjectBuildingQuery() {
    }

    @Override
    public Object clone() {
        ObjectBuildingQuery cloneQuery = (ObjectBuildingQuery)super.clone();
        cloneQuery.isCacheCheckComplete = this.isCacheCheckComplete;
        return cloneQuery;
    }

    @Override
    protected void clonedQueryExecutionComplete(DatabaseQuery query, AbstractSession session) {
        super.clonedQueryExecutionComplete(query, session);
        this.isCacheCheckComplete = false;
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        Class referenceClass;
        block5: {
            super.convertClassNamesToClasses(classLoader);
            referenceClass = null;
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        referenceClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getReferenceClassName(), true, classLoader));
                        break block5;
                    }
                    catch (PrivilegedActionException exception) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.getReferenceClassName(), exception.getException());
                    }
                }
                referenceClass = PrivilegedAccessHelper.getClassForName(this.getReferenceClassName(), true, classLoader);
            }
            catch (ClassNotFoundException exc) {
                throw ValidationException.classNotFoundWhileConvertingClassNames(this.getReferenceClassName(), exc);
            }
        }
        this.setReferenceClass(referenceClass);
    }

    protected boolean wasDefaultLockMode() {
        return this.wasDefaultLockMode;
    }

    protected void setWasDefaultLockMode(boolean wasDefaultLockMode) {
        this.wasDefaultLockMode = wasDefaultLockMode;
    }

    public Object deepClone() {
        return this.clone();
    }

    @Override
    public void copyFromQuery(DatabaseQuery query) {
        super.copyFromQuery(query);
        if (query.isObjectBuildingQuery()) {
            ObjectBuildingQuery readQuery = (ObjectBuildingQuery)query;
            this.shouldBuildNullForNullPk = readQuery.shouldBuildNullForNullPk;
            this.shouldRefreshIdentityMapResult = readQuery.shouldRefreshIdentityMapResult;
            this.shouldRefreshRemoteIdentityMapResult = readQuery.shouldRefreshRemoteIdentityMapResult;
            this.shouldRegisterResultsInUnitOfWork = readQuery.shouldRegisterResultsInUnitOfWork;
            this.shouldUseExclusiveConnection = readQuery.shouldUseExclusiveConnection;
        }
    }

    @Override
    protected void prepareCustomQuery(DatabaseQuery customQuery) {
        ((ObjectBuildingQuery)customQuery).isCacheCheckComplete = this.isCacheCheckComplete;
    }

    @Override
    public void prepareFromQuery(DatabaseQuery query) {
        super.prepareFromQuery(query);
        if (query.isObjectBuildingQuery()) {
            ObjectBuildingQuery objectQuery = (ObjectBuildingQuery)query;
            this.referenceClass = objectQuery.referenceClass;
            this.referenceClassName = objectQuery.referenceClassName;
            this.lockingClause = objectQuery.lockingClause;
            this.wasDefaultLockMode = objectQuery.wasDefaultLockMode;
        }
    }

    public void dontRefreshIdentityMapResult() {
        this.setShouldRefreshIdentityMapResult(false);
    }

    public void dontRefreshRemoteIdentityMapResult() {
        this.setShouldRefreshRemoteIdentityMapResult(false);
    }

    public boolean hasExecutionFetchGroup() {
        return false;
    }

    public FetchGroup getExecutionFetchGroup() {
        return null;
    }

    public FetchGroup getExecutionFetchGroup(ClassDescriptor descriptor) {
        return null;
    }

    public LoadGroup getLoadGroup() {
        return null;
    }

    public short getLockMode() {
        if (this.lockingClause == null) {
            return -1;
        }
        return this.lockingClause.getLockMode();
    }

    public List getDataResults() {
        return null;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public Map<Object, CacheKey> getPrefetchedCacheKeys() {
        return this.prefetchedCacheKeys;
    }

    protected Object getQueryPrimaryKey() {
        return null;
    }

    @Override
    public Class<?> getReferenceClass() {
        return this.referenceClass;
    }

    @Override
    public String getReferenceClassName() {
        if (this.referenceClassName == null && this.referenceClass != null) {
            this.referenceClassName = this.referenceClass.getName();
        }
        return this.referenceClassName;
    }

    public boolean hasPartialAttributeExpressions() {
        return false;
    }

    public boolean isLockQuery() {
        return this.getLockMode() > 0;
    }

    @Override
    public boolean isObjectBuildingQuery() {
        return true;
    }

    public boolean isRegisteringResults() {
        return this.shouldRegisterResultsInUnitOfWork() && this.descriptor.shouldRegisterResultsInUnitOfWork() || this.isLockQuery();
    }

    public void refreshIdentityMapResult() {
        this.setShouldRefreshIdentityMapResult(true);
    }

    public void refreshRemoteIdentityMapResult() {
        this.setShouldRefreshRemoteIdentityMapResult(true);
    }

    public Object registerIndividualResult(Object result, Object primaryKey, UnitOfWorkImpl unitOfWork, JoinedAttributeManager joinManager, ClassDescriptor concreteDescriptor) {
        if (concreteDescriptor == null) {
            concreteDescriptor = unitOfWork.getDescriptor((Class)result.getClass());
        }
        if (unitOfWork.isClassReadOnly(result.getClass(), (ClassDescriptor)concreteDescriptor)) {
            this.recordCloneForPessimisticLocking(result, unitOfWork);
            return result;
        }
        Object clone = null;
        if (!this.isRegisteringResults()) {
            if (primaryKey == null) {
                primaryKey = ((ClassDescriptor)concreteDescriptor).getObjectBuilder().extractPrimaryKeyFromObject(result, this.getSession());
            }
            if ((clone = unitOfWork.getIdentityMapAccessorInstance().getIdentityMapManager().getFromIdentityMap(primaryKey, result.getClass(), (ClassDescriptor)concreteDescriptor)) == null) {
                clone = result;
            }
        } else {
            clone = unitOfWork.registerExistingObject(result, (ClassDescriptor)concreteDescriptor, this.getQueryPrimaryKey(), true);
        }
        this.postRegisterIndividualResult(clone, result, primaryKey, unitOfWork, joinManager, (ClassDescriptor)concreteDescriptor);
        return clone;
    }

    public void postRegisterIndividualResult(Object clone, Object original, Object primaryKey, UnitOfWorkImpl unitOfWork, JoinedAttributeManager joinManager, ClassDescriptor concreteDescriptor) {
        if (this.shouldRefreshIdentityMapResult()) {
            if (this.shouldCascadeAllParts()) {
                unitOfWork.mergeClone(original, 3, true);
            } else if (this.shouldCascadePrivateParts()) {
                unitOfWork.mergeClone(original, 2, true);
            } else if (this.shouldCascadeByMapping()) {
                unitOfWork.mergeClone(original, 4, true);
            } else if (!this.shouldCascadeParts()) {
                unitOfWork.mergeClone(original, 1, true);
            }
        }
        if (joinManager != null && joinManager.hasJoinedAttributeExpressions()) {
            this.triggerJoinExpressions(unitOfWork, joinManager, clone, concreteDescriptor);
        }
    }

    private void triggerJoinExpressions(UnitOfWorkImpl unitOfWork, JoinedAttributeManager joinManager, Object clone, ClassDescriptor concreteDescriptor) {
        List<Expression> joinExpressions = joinManager.getJoinedAttributeExpressions();
        int size = joinExpressions.size();
        if (size == 0 || clone == null) {
            return;
        }
        for (int index = 0; index < size; ++index) {
            QueryKeyExpression queryKeyExpression;
            Object attributeValue;
            QueryKeyExpression baseExpression = (QueryKeyExpression)joinManager.getJoinedAttributes().get(index);
            DatabaseMapping mapping = joinManager.getJoinedAttributeMappings().get(index);
            if (mapping == null || (attributeValue = joinManager.getValueFromObjectForExpression(unitOfWork, clone, baseExpression)) == null || baseExpression == (queryKeyExpression = (QueryKeyExpression)joinExpressions.get(index))) continue;
            ObjectLevelReadQuery nestedQuery = null;
            if (joinManager.getJoinedMappingQueryClones() == null) {
                if (joinManager.getJoinedMappingQueries_() != null) {
                    nestedQuery = joinManager.getJoinedMappingQueries_().get(mapping);
                }
            } else {
                nestedQuery = joinManager.getJoinedMappingQueryClones().get(mapping);
            }
            if (nestedQuery == null || nestedQuery.getJoinedAttributeManager() == null) continue;
            if (!mapping.isCollectionMapping()) {
                this.triggerJoinExpressions(unitOfWork, nestedQuery.getJoinedAttributeManager(), attributeValue, null);
                continue;
            }
            ContainerPolicy cp = mapping.getContainerPolicy();
            Object iterator = cp.iteratorFor(attributeValue);
            while (cp.hasNext(iterator)) {
                this.triggerJoinExpressions(unitOfWork, nestedQuery.getJoinedAttributeManager(), cp.next(iterator, unitOfWork), null);
            }
        }
    }

    public boolean requiresDeferredLocks() {
        return this.requiresDeferredLocks != null && this.requiresDeferredLocks != false;
    }

    public void setExecutionTime(long executionTime) {
        this.executionTime = executionTime;
    }

    public void setLockMode(short lockMode) {
        this.lockingClause = ForUpdateClause.newInstance(lockMode);
    }

    public void setPrefetchedCacheKeys(Map<Object, CacheKey> prefetchedCacheKeys) {
        this.prefetchedCacheKeys = prefetchedCacheKeys;
    }

    public void setReferenceClass(Class<?> aClass) {
        this.referenceClass = aClass;
        this.setIsPrepared(false);
    }

    public void setReferenceClassName(String aClass) {
        this.referenceClassName = aClass;
        this.setIsPrepared(false);
    }

    public void setRequiresDeferredLocks(boolean cascadeDeferredLocks) {
        this.requiresDeferredLocks = this.session != null && this.session.getProject().isQueryCacheForceDeferredLocks() ? Boolean.valueOf(true) : Boolean.valueOf(cascadeDeferredLocks);
    }

    public void setShouldRefreshIdentityMapResult(boolean shouldRefreshIdentityMapResult) {
        this.shouldRefreshIdentityMapResult = shouldRefreshIdentityMapResult;
        if (shouldRefreshIdentityMapResult) {
            this.setShouldRefreshRemoteIdentityMapResult(true);
        }
    }

    public void setShouldRefreshRemoteIdentityMapResult(boolean shouldRefreshIdentityMapResult) {
        this.shouldRefreshRemoteIdentityMapResult = shouldRefreshIdentityMapResult;
    }

    public void setShouldRegisterResultsInUnitOfWork(boolean shouldRegisterResultsInUnitOfWork) {
        this.shouldRegisterResultsInUnitOfWork = shouldRegisterResultsInUnitOfWork;
    }

    public void setShouldUseExclusiveConnection(boolean shouldUseExclusiveConnection) {
        this.shouldUseExclusiveConnection = shouldUseExclusiveConnection;
    }

    public boolean shouldRegisterResultsInUnitOfWork() {
        return this.shouldRegisterResultsInUnitOfWork;
    }

    public boolean shouldUseExclusiveConnection() {
        return this.shouldUseExclusiveConnection;
    }

    public boolean shouldReadAllMappings() {
        return true;
    }

    public boolean shouldReadMapping(DatabaseMapping mapping, FetchGroup fetchGroup) {
        return true;
    }

    public boolean shouldRefreshIdentityMapResult() {
        return this.shouldRefreshIdentityMapResult;
    }

    public boolean shouldRefreshRemoteIdentityMapResult() {
        return this.shouldRefreshRemoteIdentityMapResult;
    }

    public boolean isAttributeJoined(ClassDescriptor mappingDescriptor, String attributeName) {
        return false;
    }

    public boolean isCacheCheckComplete() {
        return this.isCacheCheckComplete;
    }

    public boolean isClonePessimisticLocked(Object clone, UnitOfWorkImpl uow) {
        return false;
    }

    public void recordCloneForPessimisticLocking(Object clone, UnitOfWorkImpl uow) {
        if (this.isLockQuery() && this.lockingClause.isReferenceClassLocked()) {
            uow.addPessimisticLockedClone(clone);
        }
    }

    public boolean isDefaultLock() {
        return this.lockingClause == null;
    }

    public boolean shouldBuildNullForNullPk() {
        return this.shouldBuildNullForNullPk;
    }

    public void setShouldBuildNullForNullPk(boolean shouldBuildNullForNullPk) {
        this.shouldBuildNullForNullPk = shouldBuildNullForNullPk;
    }

    public boolean usesResultSetAccessOptimization() {
        return false;
    }

    public boolean shouldUseSerializedObjectPolicy() {
        return false;
    }

    public Boolean printInnerJoinInWhereClause() {
        return this.printInnerJoinInWhereClause;
    }

    public void setPrintInnerJoinInWhereClause(boolean printInnerJoinInWhereClause) {
        if (this.printInnerJoinInWhereClause == null || this.printInnerJoinInWhereClause != printInnerJoinInWhereClause) {
            this.printInnerJoinInWhereClause = printInnerJoinInWhereClause;
            this.setIsPrepared(false);
        }
    }
}

