/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.httptunnel.tunnel;

import com.sun.messaging.jmq.httptunnel.api.share.HttpTunnelDefaults;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class HttpTunnelPacket
implements HttpTunnelDefaults {
    protected static final short VERSION = 100;
    protected static final int HEADER_SIZE = 24;
    protected short version = (short)100;
    protected short packetType = 0;
    protected int packetSize = 0;
    protected int connId = 0;
    protected int sequence = 0;
    protected short winsize = 0;
    protected short reserved = 0;
    protected int checksum = 0;
    protected byte[] headerBuffer = new byte[24];
    protected byte[] packetBuffer = null;
    protected boolean dirty = false;

    private void parseHeader(InputStream is) throws IOException {
        DataInputStream dis = new DataInputStream(is);
        this.version = dis.readShort();
        if (this.version > 100) {
            throw new IllegalStateException("Bad response format. Check the tunnel servlet URL.");
        }
        this.packetType = dis.readShort();
        this.packetSize = dis.readInt();
        this.connId = dis.readInt();
        this.sequence = dis.readInt();
        this.winsize = dis.readShort();
        this.reserved = dis.readShort();
        this.checksum = dis.readInt();
    }

    private void updateBuffers() throws IOException {
        if (!this.dirty) {
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeShort(this.version);
        dos.writeShort(this.packetType);
        dos.writeInt(this.packetSize);
        dos.writeInt(this.connId);
        dos.writeInt(this.sequence);
        dos.writeShort(this.winsize);
        dos.writeShort(this.reserved);
        dos.writeInt(this.checksum);
        dos.flush();
        bos.flush();
        this.headerBuffer = bos.toByteArray();
        this.dirty = false;
    }

    public void readPacket(InputStream is) throws IOException, EOFException {
        DataInputStream dis = new DataInputStream(is);
        dis.readFully(this.headerBuffer);
        this.parseHeader(new ByteArrayInputStream(this.headerBuffer));
        this.packetBuffer = new byte[this.packetSize - 24];
        dis.readFully(this.packetBuffer);
    }

    public void writePacket(OutputStream os) throws IOException {
        this.updateBuffers();
        os.write(this.headerBuffer, 0, 24);
        if (this.packetBuffer != null) {
            os.write(this.packetBuffer, 0, this.packetSize - 24);
        }
        os.flush();
    }

    public int getPacketType() {
        return this.packetType;
    }

    public byte[] getPacketBody() {
        return this.packetBuffer;
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    public int getPacketDataSize() {
        return this.packetSize - 24;
    }

    public int getConnId() {
        return this.connId;
    }

    public int getSequence() {
        return this.sequence;
    }

    public int getWinsize() {
        return this.winsize;
    }

    public int getChecksum() {
        return this.checksum;
    }

    public void setPacketType(int packetType) {
        this.packetType = (short)packetType;
        this.dirty = true;
    }

    public void setPacketBody(byte[] data) {
        this.packetBuffer = data;
        this.packetSize = 24;
        if (this.packetBuffer != null) {
            this.packetSize += this.packetBuffer.length;
        }
        this.dirty = true;
    }

    public void setConnId(int connId) {
        this.connId = connId;
        this.dirty = true;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
        this.dirty = true;
    }

    public void setWinsize(int winsize) {
        this.winsize = (short)winsize;
        this.dirty = true;
    }

    public void setChecksum(int checksum) {
        this.checksum = checksum;
        this.dirty = true;
    }

    public String toString() {
        String ret = " HttpTunnelPacket [ Version = " + this.version + ", packetType = " + this.getPacketTypeStr() + ", packetSize = " + this.packetSize + ", connId = " + this.connId + ", sequence = " + this.sequence + ", winsize = " + this.winsize + ", reserved = " + this.reserved + ", checksum = " + this.checksum + "]";
        if (this.packetBuffer != null) {
            ret = ret + " [ DATA = \"" + new String(this.packetBuffer) + "\"]";
        }
        return ret;
    }

    private String getPacketTypeStr() {
        switch (this.packetType) {
            case 9: {
                return "CONN_ABORT_PACKET";
            }
            case 5: {
                return "CONN_CLOSE_PACKET";
            }
            case 2: {
                return "CONN_INIT_ACK";
            }
            case 1: {
                return "CONN_INIT_PACKET";
            }
            case 10: {
                return "CONN_OPTION_PACKET";
            }
            case 3: {
                return "CONN_REJECTED";
            }
            case 7: {
                return "CONN_SHUTDOWN";
            }
            case 4: {
                return "DATA_PACKET";
            }
            case 6: {
                return "ACK";
            }
            case 8: {
                return "LINK_INIT_PACKET";
            }
            case 11: {
                return "LISTEN_STATE_PACKET";
            }
        }
        return String.valueOf(this.packetType);
    }
}

