/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.classfile;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.apache.derby.iapi.services.classfile.CONSTANT_Index_info;
import org.apache.derby.iapi.services.classfile.ClassHolder;
import org.apache.derby.iapi.services.classfile.ClassMember;
import org.apache.derby.iapi.services.classfile.ConstantPoolEntry;

class ClassEnumeration
implements Enumeration {
    ClassHolder cpt;
    Enumeration inner;
    CONSTANT_Index_info position;
    HashSet<String> foundClasses;
    Enumeration classList;

    ClassEnumeration(ClassHolder classHolder, Enumeration enumeration, Enumeration enumeration2, Enumeration enumeration3) {
        this.cpt = classHolder;
        this.inner = enumeration;
        this.foundClasses = new HashSet(30, 0.8f);
        this.findMethodReferences(enumeration2, this.foundClasses);
        this.findFieldReferences(enumeration3, this.foundClasses);
        this.findClassReferences(this.foundClasses);
        this.classList = Collections.enumeration(this.foundClasses);
    }

    @Override
    public boolean hasMoreElements() {
        return this.classList.hasMoreElements();
    }

    private void findClassReferences(HashSet<String> hashSet) {
        while (this.inner.hasMoreElements()) {
            ConstantPoolEntry constantPoolEntry = (ConstantPoolEntry)this.inner.nextElement();
            if (constantPoolEntry == null || constantPoolEntry.getTag() != 7) continue;
            CONSTANT_Index_info cONSTANT_Index_info = (CONSTANT_Index_info)constantPoolEntry;
            String string = this.cpt.className(cONSTANT_Index_info.getIndex());
            if (string.startsWith("[")) {
                this.distillClasses(string, hashSet);
                continue;
            }
            if (string.length() <= 1 || string.startsWith("java")) continue;
            hashSet.add(string);
        }
    }

    private void findMethodReferences(Enumeration enumeration, HashSet<String> hashSet) {
        while (enumeration.hasMoreElements()) {
            ClassMember classMember = (ClassMember)enumeration.nextElement();
            String string = classMember.getDescriptor();
            this.distillClasses(string, hashSet);
        }
    }

    private void findFieldReferences(Enumeration enumeration, HashSet<String> hashSet) {
        while (enumeration.hasMoreElements()) {
            ClassMember classMember = (ClassMember)enumeration.nextElement();
            String string = classMember.getDescriptor();
            this.distillClasses(string, hashSet);
        }
    }

    void distillClasses(String string, HashSet<String> hashSet) {
        if (string == null || string.length() < 1) {
            return;
        }
        if (string.charAt(0) != '(') {
            int n = string.indexOf(76);
            if (n == -1) {
                return;
            }
            String string2 = string.substring(n + 1).replace('/', '.');
            if (string2.endsWith(";")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (string2.startsWith("java")) {
                return;
            }
            hashSet.add(string2);
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "();[");
        while (stringTokenizer.hasMoreElements()) {
            String string3 = stringTokenizer.nextToken();
            int n = string3.indexOf(76);
            if (n == -1) continue;
            this.distillClasses(string3, hashSet);
        }
    }

    public Object nextElement() {
        return this.classList.nextElement();
    }
}

