/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.webui.jsf.component.Button;
import com.sun.webui.jsf.component.CalendarMonth;
import com.sun.webui.jsf.component.ComplexComponent;
import com.sun.webui.jsf.component.DateManager;
import com.sun.webui.jsf.component.DropDown;
import com.sun.webui.jsf.component.Label;
import com.sun.webui.jsf.component.TextField;
import com.sun.webui.jsf.component.Time;
import com.sun.webui.jsf.component.WebuiInput;
import com.sun.webui.jsf.converter.DateConverter;
import com.sun.webui.jsf.event.IntervalListener;
import com.sun.webui.jsf.event.SchedulerPreviewListener;
import com.sun.webui.jsf.model.ClockTime;
import com.sun.webui.jsf.model.Option;
import com.sun.webui.jsf.model.ScheduledEvent;
import com.sun.webui.jsf.model.scheduler.RepeatInterval;
import com.sun.webui.jsf.model.scheduler.RepeatIntervalConverter;
import com.sun.webui.jsf.model.scheduler.RepeatIntervalOption;
import com.sun.webui.jsf.model.scheduler.RepeatUnit;
import com.sun.webui.jsf.model.scheduler.RepeatUnitConverter;
import com.sun.webui.jsf.model.scheduler.RepeatUnitOption;
import com.sun.webui.jsf.util.ComponentUtilities;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.jsf.validator.DateInRangeValidator;
import com.sun.webui.theme.Theme;
import jakarta.el.ValueExpression;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import jakarta.faces.convert.IntegerConverter;
import jakarta.faces.validator.DoubleRangeValidator;
import jakarta.faces.validator.Validator;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;

public final class Scheduler
extends WebuiInput
implements ComplexComponent,
DateManager,
NamingContainer {
    public static final String DATE_PICKER_FACET = "datePicker";
    public static final String DATE_FACET = "date";
    public static final String DATE_LABEL_FACET = "dateLabel";
    public static final String START_DATE_TEXT_KEY = "Scheduler.startDate";
    public static final String START_TIME_FACET = "startTime";
    public static final String START_TIME_LABEL_FACET = "startTimeLabel";
    public static final String START_TIME_TEXT_KEY = "Scheduler.startTime";
    public static final String END_TIME_FACET = "endTime";
    public static final String END_TIME_LABEL_FACET = "endTimeLabel";
    public static final String END_TIME_TEXT_KEY = "Scheduler.endTime";
    public static final String REPEAT_LIMIT_UNIT_FACET = "repeatLimitUnit";
    public static final String REPEAT_UNIT_DESCRIPTION_TEXT_KEY = "Scheduler.repeatUnitDesc";
    public static final String REPEAT_LIMIT_FACET = "repeatLimit";
    public static final String REPEAT_LIMIT_LABEL_FACET = "repeatLimitLabel";
    public static final String REPEAT_LIMIT_TEXT_KEY = "Scheduler.repeatLimit";
    public static final String REPEAT_INTERVAL_FACET = "repeatInterval";
    public static final String REPEAT_INTERVAL_LABEL_FACET = "repeatIntervalLabel";
    public static final String REPEAT_INTERVAL_TEXT_KEY = "Scheduler.repeatInterval";
    public static final String REPEAT_INTERVAL_DESCRIPTION_TEXT_KEY = "Scheduler.repeatIntervalDesc";
    public static final String PREVIEW_BUTTON_FACET = "previewButton";
    public static final String PREVIEW_BUTTON_TEXT_KEY = "Scheduler.preview";
    public static final String START_HOUR_TITLE_TEXT_KEY = "Scheduler.startHourTitle";
    public static final String START_MINUTE_TITLE_TEXT_KEY = "Scheduler.startMinuteTitle";
    public static final String END_HOUR_TITLE_TEXT_KEY = "Scheduler.endHourTitle";
    public static final String END_MINUTE_TITLE_TEXT_KEY = "Scheduler.endMinuteTitle";
    private static final String END_BEFORE_START_TEXT_KEY = "Scheduler.endBeforeStart";
    private static final String INVALID_INPUT_TEXT_KEY = "Scheduler.invalidInput";
    private static final String INVALID_DATE_TEXT_KEY = "Scheduler.invalidDate";
    private static final String INVALID_START_TIME_TEXT_KEY = "Scheduler.invalidStartTime";
    private static final String INVALID_END_TIME_TEXT_KEY = "Scheduler.invalidEndTime";
    public static final String ICON_ID = "_icon";
    private static final String VALUE_SUBMITTED = "com.sun.webui.jsf.SchedulerSubmitted";
    private static final String FIRST_AVAILABLE_DATE = "com.sun.webui.jsf.FirstAvailable";
    private static final String LAST_AVAILABLE_DATE = "com.sun.webui.jsf.LastAvailable";
    private static final boolean DEBUG = false;
    private String dateFormatPattern = null;
    private String dateFormatPatternHelp = null;
    private String dateLabel = null;
    private boolean disabled = false;
    private boolean disabledSet = false;
    private boolean endTime = false;
    private boolean endTimeSet = false;
    private String endTimeLabel = null;
    private boolean limitRepeating = false;
    private boolean limitRepeatingSet = false;
    private Date maxDate = null;
    private Date minDate = null;
    private boolean previewButton = false;
    private boolean previewButtonSet = false;
    private boolean readOnly = false;
    private boolean readOnlySet = false;
    private Object repeatIntervalItems = null;
    private String repeatIntervalLabel = null;
    private String repeatLimitLabel = null;
    private Object repeatUnitItems = null;
    private boolean repeating = false;
    private boolean repeatingSet = false;
    private boolean required = false;
    private boolean requiredSet = false;
    private boolean requiredLegend = false;
    private boolean requiredLegendSet = false;
    private boolean startTime = false;
    private boolean startTimeSet = false;
    private String startTimeLabel = null;
    private String style = null;
    private String styleClass = null;
    private int tabIndex = Integer.MIN_VALUE;
    private boolean tabIndexSet = false;
    private TimeZone timeZone = null;
    private boolean visible = false;
    private boolean visibleSet = false;

    public Scheduler() {
        this.setRendererType("com.sun.webui.jsf.Scheduler");
    }

    public String getFamily() {
        return "com.sun.webui.jsf.Scheduler";
    }

    public void setValue(Object value) {
        super.setValue(value);
    }

    public Converter getConverter() {
        return super.getConverter();
    }

    public CalendarMonth getDatePicker() {
        CalendarMonth dp = (CalendarMonth)ComponentUtilities.getPrivateFacet((UIComponent)this, DATE_PICKER_FACET, true);
        if (dp == null) {
            dp = new CalendarMonth();
            dp.setPopup(false);
            dp.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, DATE_PICKER_FACET));
            ComponentUtilities.putPrivateFacet((UIComponent)this, DATE_PICKER_FACET, (UIComponent)dp);
        }
        dp.setJavaScriptObjectName(this.getJavaScriptObjectName(FacesContext.getCurrentInstance()));
        return dp;
    }

    public UIComponent getDateLabelComponent(Theme theme) {
        UIComponent comp;
        String label = this.getDateLabel();
        if (label == null) {
            label = theme.getMessage(START_DATE_TEXT_KEY);
        }
        String compId = (comp = this.getDateComponent()) != null ? comp.getClientId(this.getFacesContext()) : null;
        return this.getLabelFacet(DATE_LABEL_FACET, label, compId);
    }

    public UIComponent getDateComponent() {
        UIComponent fieldComponent = this.getFacet(DATE_FACET);
        if (fieldComponent != null) {
            return fieldComponent;
        }
        TextField field = (TextField)ComponentUtilities.getPrivateFacet((UIComponent)this, DATE_FACET, true);
        if (field == null) {
            field = new TextField();
            field.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, DATE_FACET));
            field.setConverter(new DateConverter());
            field.addValidator(new DateInRangeValidator());
            ComponentUtilities.putPrivateFacet((UIComponent)this, DATE_FACET, (UIComponent)field);
        }
        field.setDisabled(this.isDisabled());
        this.initFieldFacet(field, 12, this.isRequired());
        return field;
    }

    public UIComponent getStartTimeLabelComponent(Theme theme) {
        Time comp;
        String label = this.getStartTimeLabel();
        if (label == null) {
            label = theme.getMessage(START_TIME_TEXT_KEY);
        }
        String compId = (comp = this.getStartTimeComponent()) != null ? comp.getClientId(this.getFacesContext()) : null;
        return this.getLabelFacet(START_TIME_LABEL_FACET, label, compId);
    }

    public Time getStartTimeComponent() {
        return this.getTimeFacet(START_TIME_FACET, this.isRequired(), START_HOUR_TITLE_TEXT_KEY, START_MINUTE_TITLE_TEXT_KEY);
    }

    public UIComponent getEndTimeLabelComponent(Theme theme) {
        Time comp;
        String label = this.getEndTimeLabel();
        if (label == null) {
            label = theme.getMessage(END_TIME_TEXT_KEY);
        }
        String compId = (comp = this.getEndTimeComponent()) != null ? comp.getClientId(this.getFacesContext()) : null;
        return this.getLabelFacet(END_TIME_LABEL_FACET, label, compId);
    }

    public Time getEndTimeComponent() {
        return this.getTimeFacet(END_TIME_FACET, false, END_HOUR_TITLE_TEXT_KEY, END_MINUTE_TITLE_TEXT_KEY);
    }

    public UIComponent getRepeatIntervalLabelComponent() {
        DropDown comp;
        String label = this.getRepeatIntervalLabel();
        if (label == null) {
            FacesContext context = FacesContext.getCurrentInstance();
            label = ThemeUtilities.getTheme(context).getMessage(REPEAT_INTERVAL_TEXT_KEY);
        }
        String compId = (comp = this.getRepeatIntervalComponent()) != null ? comp.getClientId(this.getFacesContext()) : null;
        return this.getLabelFacet(REPEAT_INTERVAL_LABEL_FACET, label, compId);
    }

    public DropDown getRepeatIntervalComponent() {
        DropDown dropDown = (DropDown)ComponentUtilities.getPrivateFacet((UIComponent)this, REPEAT_INTERVAL_FACET, true);
        if (dropDown == null) {
            dropDown = new DropDown();
            dropDown.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, REPEAT_INTERVAL_FACET));
            dropDown.setSubmitForm(true);
            dropDown.setConverter(new RepeatIntervalConverter());
            dropDown.setImmediate(true);
            dropDown.addActionListener(new IntervalListener());
            ComponentUtilities.putPrivateFacet((UIComponent)this, REPEAT_INTERVAL_FACET, (UIComponent)dropDown);
        }
        dropDown.setItems(this.getRepeatIntervalItems());
        Theme theme = ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
        dropDown.setToolTip(theme.getMessage(REPEAT_INTERVAL_DESCRIPTION_TEXT_KEY));
        return dropDown;
    }

    public UIComponent getRepeatLimitLabelComponent() {
        UIComponent comp;
        String label = this.getRepeatLimitLabel();
        if (label == null) {
            FacesContext context = FacesContext.getCurrentInstance();
            label = ThemeUtilities.getTheme(context).getMessage(REPEAT_LIMIT_TEXT_KEY);
        }
        String compId = (comp = this.getRepeatingFieldComponent()) != null ? comp.getClientId(this.getFacesContext()) : null;
        return this.getLabelFacet(REPEAT_LIMIT_LABEL_FACET, label, compId);
    }

    public UIComponent getRepeatingFieldComponent() {
        UIComponent fieldComponent = this.getFacet(REPEAT_LIMIT_FACET);
        if (fieldComponent != null) {
            return fieldComponent;
        }
        TextField field = (TextField)ComponentUtilities.getPrivateFacet((UIComponent)this, REPEAT_LIMIT_FACET, true);
        if (field == null) {
            field = new TextField();
            field.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, REPEAT_LIMIT_FACET));
            IntegerConverter converter = new IntegerConverter();
            field.setConverter((Converter)converter);
            DoubleRangeValidator drv = new DoubleRangeValidator();
            drv.setMinimum(1.0);
            field.addValidator((Validator)drv);
            ComponentUtilities.putPrivateFacet((UIComponent)this, REPEAT_LIMIT_FACET, (UIComponent)field);
        }
        this.initFieldFacet(field, 3, false);
        return field;
    }

    public DropDown getRepeatUnitComponent() {
        DropDown dropDown = (DropDown)ComponentUtilities.getPrivateFacet((UIComponent)this, REPEAT_LIMIT_UNIT_FACET, true);
        if (dropDown == null) {
            dropDown = new DropDown();
            dropDown.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, REPEAT_LIMIT_UNIT_FACET));
            dropDown.setConverter(new RepeatUnitConverter());
            ComponentUtilities.putPrivateFacet((UIComponent)this, REPEAT_LIMIT_UNIT_FACET, (UIComponent)dropDown);
        }
        dropDown.setItems(this.getRepeatUnitItems());
        Theme theme = ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
        dropDown.setToolTip(theme.getMessage(REPEAT_UNIT_DESCRIPTION_TEXT_KEY));
        return dropDown;
    }

    public UIComponent getPreviewButtonComponent() {
        UIComponent buttonComponent = this.getFacet(PREVIEW_BUTTON_FACET);
        if (buttonComponent != null) {
            return buttonComponent;
        }
        Button button = (Button)ComponentUtilities.getPrivateFacet((UIComponent)this, PREVIEW_BUTTON_FACET, true);
        if (button == null) {
            button = new Button();
            button.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, PREVIEW_BUTTON_FACET));
            button.setMini(true);
            button.setPrimary(false);
            button.setImmediate(true);
            button.addActionListener(new SchedulerPreviewListener());
            ComponentUtilities.putPrivateFacet((UIComponent)this, PREVIEW_BUTTON_FACET, (UIComponent)button);
        }
        button.setText(ThemeUtilities.getTheme(FacesContext.getCurrentInstance()).getMessage(PREVIEW_BUTTON_TEXT_KEY));
        return button;
    }

    public void updateRepeatUnitMenu() {
        if (!this.isLimitRepeating()) {
            return;
        }
        DropDown repeatIntervalComp = (DropDown)this.getPrivateFacet(REPEAT_INTERVAL_FACET);
        Object value = repeatIntervalComp.getValue();
        if (value == null || !(value instanceof RepeatInterval)) {
            this.disableRepeatLimitComponents();
        } else {
            RepeatInterval ri = (RepeatInterval)value;
            if (ri.getRepresentation().equals("ONETIME")) {
                this.disableRepeatLimitComponents();
            } else {
                this.enableRepeatLimitComponents(ri);
            }
        }
    }

    @Override
    public String getPrimaryElementID(FacesContext context) {
        return this.getLabeledElementId(context);
    }

    @Override
    public String getLabeledElementId(FacesContext context) {
        UIComponent comp = this.getDateComponent();
        if (comp == null) {
            return null;
        }
        if (comp instanceof ComplexComponent) {
            return ((ComplexComponent)comp).getLabeledElementId(context);
        }
        return comp.getClientId(context);
    }

    @Override
    public String getFocusElementId(FacesContext context) {
        return this.getLabeledElementId(context);
    }

    public Object getRepeatIntervalItems() {
        Option[] optionsObject = this.doGetRepeatIntervalItems();
        if (optionsObject == null) {
            Option[] options = new Option[]{new RepeatIntervalOption(RepeatInterval.getInstance("ONETIME")), new RepeatIntervalOption(RepeatInterval.getInstance("HOURLY")), new RepeatIntervalOption(RepeatInterval.getInstance("DAILY")), new RepeatIntervalOption(RepeatInterval.getInstance("WEEKLY")), new RepeatIntervalOption(RepeatInterval.getInstance("MONTHLY"))};
            optionsObject = options;
            this.setRepeatIntervalItems(options);
        }
        return optionsObject;
    }

    public Object getRepeatUnitItems() {
        Option[] optionsObject = this.doGetRepeatUnitItems();
        if (optionsObject == null) {
            Option[] options = new Option[]{new RepeatUnitOption(RepeatUnit.getInstance("HOURS")), new RepeatUnitOption(RepeatUnit.getInstance("DAYS")), new RepeatUnitOption(RepeatUnit.getInstance("WEEKS")), new RepeatUnitOption(RepeatUnit.getInstance("MONTHS"))};
            optionsObject = options;
            this.setRepeatUnitItems(options);
        }
        return optionsObject;
    }

    @Override
    public DateFormat getDateFormat() {
        return this.getDatePicker().getDateFormat();
    }

    public String getJavaScriptObjectName(FacesContext context) {
        return JavaScriptUtilities.getDomNode(context, (UIComponent)this);
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.setValid(true);
        UIComponent facet = this.getPrivateFacet(DATE_PICKER_FACET);
        facet.processDecodes(context);
        this.getPreviewButtonComponent().processDecodes(context);
        this.getDateComponent().processDecodes(context);
        if (this.isStartTime()) {
            facet = this.getPrivateFacet(START_TIME_FACET);
            facet.processDecodes(context);
        }
        if (this.isEndTime()) {
            facet = this.getPrivateFacet(END_TIME_FACET);
            facet.processDecodes(context);
        }
        if (this.isRepeating()) {
            facet = this.getPrivateFacet(REPEAT_INTERVAL_FACET);
            facet.processDecodes(context);
            if (this.isLimitRepeating()) {
                facet = this.getPrivateFacet(REPEAT_LIMIT_FACET);
                facet.processDecodes(context);
                facet = this.getPrivateFacet(REPEAT_LIMIT_UNIT_FACET);
                facet.processDecodes(context);
            }
        }
        this.setSubmittedValue(VALUE_SUBMITTED);
        if (this.isImmediate()) {
            this.runValidation(context);
        }
    }

    public Object getConvertedValue(FacesContext context, Object submittedValue) throws ConverterException {
        if (context == null) {
            throw new NullPointerException();
        }
        Iterator kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (!(kid instanceof EditableValueHolder) || ((EditableValueHolder)kid).isValid()) continue;
            return null;
        }
        Object dateValue = ((EditableValueHolder)this.getDateComponent()).getValue();
        Object startTimeValue = null;
        Object endTimeValue = null;
        if (this.isStartTime()) {
            startTimeValue = this.getStartTimeComponent().getValue();
        }
        if (this.isEndTime()) {
            endTimeValue = this.getEndTimeComponent().getValue();
        }
        ScheduledEvent newValue = this.createScheduledEvent(dateValue, startTimeValue, endTimeValue, context);
        if (this.isRepeating()) {
            RepeatInterval freq;
            boolean valueRepeat = false;
            Object repeatFrequency = this.getRepeatIntervalComponent().getValue();
            if (repeatFrequency != null && repeatFrequency instanceof RepeatInterval && (freq = (RepeatInterval)repeatFrequency).getCalendarField() > -1) {
                valueRepeat = true;
            }
            if (valueRepeat) {
                newValue.setRepeatingEvent(true);
                try {
                    newValue.setRepeatInterval((RepeatInterval)repeatFrequency);
                    if (this.isLimitRepeating()) {
                        Object repeatUnit = this.getRepeatUnitComponent().getValue();
                        if (repeatUnit instanceof RepeatUnit) {
                            newValue.setDurationUnit((RepeatUnit)repeatUnit);
                        } else {
                            newValue.setDurationUnit(null);
                        }
                        Object repeatLimit = ((EditableValueHolder)this.getRepeatingFieldComponent()).getValue();
                        if (repeatLimit instanceof Integer) {
                            newValue.setDuration((Integer)repeatLimit);
                        }
                        newValue.setDuration(null);
                    }
                    newValue.setDurationUnit(null);
                    newValue.setDuration(null);
                }
                catch (Exception ce) {
                    throw new ConverterException();
                }
            } else {
                newValue.setRepeatingEvent(false);
                newValue.setDurationUnit(null);
                newValue.setDuration(null);
            }
        } else {
            newValue.setRepeatingEvent(false);
            newValue.setDurationUnit(null);
            newValue.setDuration(null);
        }
        this.getDatePicker().setValue(newValue);
        return newValue;
    }

    private UIComponent getLabelFacet(String facetName, String labelText, String labeledComponentId) {
        UIComponent labelFacet = this.getFacet(facetName);
        if (labelFacet != null) {
            return labelFacet;
        }
        Label label = (Label)ComponentUtilities.getPrivateFacet((UIComponent)this, facetName, true);
        if (label == null) {
            label = new Label();
            label.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, facetName));
            ComponentUtilities.putPrivateFacet((UIComponent)this, facetName, (UIComponent)label);
        }
        label.setText(labelText);
        label.setFor(labeledComponentId);
        label.setLabelLevel(2);
        return label;
    }

    private void initFieldFacet(TextField textField, int columns, boolean requiredFlag) {
        textField.setColumns(columns);
        textField.setTrim(true);
        textField.setRequired(requiredFlag);
        int tindex = this.getTabIndex();
        if (tindex > 0) {
            textField.setTabIndex(tindex);
        }
    }

    private Time getTimeFacet(String facetName, boolean requiredFlag, String hourKey, String minutesKey) {
        Time time = (Time)ComponentUtilities.getPrivateFacet((UIComponent)this, facetName, true);
        if (time == null) {
            time = new Time();
            time.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, facetName));
            ComponentUtilities.putPrivateFacet((UIComponent)this, facetName, (UIComponent)time);
        }
        time.setRequired(requiredFlag);
        time.setTimeZone(this.getTimeZone());
        time.setHourTooltipKey(hourKey);
        time.setMinutesTooltipKey(minutesKey);
        return time;
    }

    private void runValidation(FacesContext context) {
        try {
            this.validate(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        if (!this.isValid()) {
            context.renderResponse();
        }
    }

    private ScheduledEvent createScheduledEvent(Object dateObject, Object startTimeObject, Object endTimeObject, FacesContext context) {
        ScheduledEvent event = null;
        String messageKey = null;
        if (!(dateObject instanceof Date)) {
            messageKey = INVALID_DATE_TEXT_KEY;
        }
        if (!(startTimeObject instanceof ClockTime)) {
            messageKey = INVALID_START_TIME_TEXT_KEY;
        }
        if (endTimeObject != null && !(endTimeObject instanceof ClockTime)) {
            messageKey = INVALID_END_TIME_TEXT_KEY;
        }
        if (messageKey == null) {
            event = new ScheduledEvent();
            Date date = (Date)dateObject;
            ClockTime start = (ClockTime)startTimeObject;
            event.setStartTime(this.calculateDate(date, start));
            if (endTimeObject != null) {
                ClockTime end = (ClockTime)endTimeObject;
                event.setEndTime(this.calculateDate(date, end));
                if (event.getEndTime().before(event.getStartTime())) {
                    messageKey = END_BEFORE_START_TEXT_KEY;
                    this.getEndTimeComponent().setValid(false);
                }
            }
        }
        if (messageKey != null) {
            String message = ThemeUtilities.getTheme(context).getMessage(messageKey);
            throw new ConverterException(new FacesMessage(message));
        }
        return event;
    }

    private Date calculateDate(Date date, ClockTime time) {
        Calendar calendar = (Calendar)this.getDatePicker().getCalendar().clone();
        calendar.setTime(date);
        calendar.set(11, time.getHour());
        calendar.set(12, time.getMinute());
        return calendar.getTime();
    }

    private void disableRepeatLimitComponents() {
        DropDown dd = this.getRepeatUnitComponent();
        UIComponent comp = this.getRepeatingFieldComponent();
        dd.setDisabled(true);
        dd.setSubmittedValue(null);
        dd.setValue(null);
        comp.getAttributes().put("disabled", Boolean.TRUE);
        ((EditableValueHolder)comp).setValue(null);
        ((EditableValueHolder)comp).setSubmittedValue(null);
    }

    private void enableRepeatLimitComponents(RepeatInterval ri) {
        DropDown dd = this.getRepeatUnitComponent();
        UIComponent comp = this.getRepeatingFieldComponent();
        dd.setValue(ri.getDefaultRepeatUnit());
        dd.setSubmittedValue(null);
        dd.setDisabled(false);
        comp.getAttributes().put("disabled", Boolean.FALSE);
    }

    private static void log(String msg) {
        LogUtil.finest(Scheduler.class.getName() + "::" + msg);
    }

    private UIComponent getPrivateFacet(String facetName) {
        Object facet = ComponentUtilities.getPrivateFacet((UIComponent)this, facetName, false);
        if (facet != null) {
            return facet;
        }
        if (facetName.equals(DATE_PICKER_FACET)) {
            facet = this.getDatePicker();
        } else if (facetName.equals(START_TIME_FACET)) {
            facet = this.getStartTimeComponent();
        } else if (facetName.equals(END_TIME_FACET)) {
            facet = this.getEndTimeComponent();
        } else if (facetName.equals(REPEAT_LIMIT_UNIT_FACET)) {
            facet = this.getRepeatUnitComponent();
        } else if (facetName.equals(REPEAT_INTERVAL_FACET)) {
            facet = this.getRepeatIntervalComponent();
        }
        return facet;
    }

    public void encodeEnd(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        if (this.getSubmittedValue() != null) {
            this.updateDatePicker(context);
        } else {
            this.initializeValues();
        }
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            this.getRenderer(context).encodeEnd(context, (UIComponent)this);
        }
    }

    private void updateDatePicker(FacesContext context) {
        block4: {
            try {
                Object value = this.getConvertedValue(context, null);
                this.getDatePicker().setValue(value);
            }
            catch (ConverterException ex) {
                UIComponent comp = this.getDateComponent();
                Object value = ((EditableValueHolder)comp).getSubmittedValue();
                if (value == null) break block4;
                try {
                    Object dO = ConversionUtilities.convertValueToObject(comp, (String)value, context);
                    this.getDatePicker().setValue(dO);
                }
                catch (ConverterException converterException) {
                    // empty catch block
                }
            }
        }
    }

    private void initializeValues() {
        CalendarMonth dp = this.getDatePicker();
        Object value = this.getValue();
        if (value != null && value instanceof ScheduledEvent) {
            ScheduledEvent event = (ScheduledEvent)value;
            dp.setValue(event);
            dp.displayValue();
            ((EditableValueHolder)this.getDateComponent()).setValue((Object)event.getStartTime());
            if (this.isStartTime()) {
                this.getStartTimeComponent().setValue(this.getClockTime(dp, event.getStartTime()));
            }
            if (this.isEndTime()) {
                this.getEndTimeComponent().setValue(this.getClockTime(dp, event.getEndTime()));
            }
            if (this.isRepeating()) {
                RepeatInterval ri = event.getRepeatInterval();
                this.getRepeatIntervalComponent().setValue(ri);
                if (this.isLimitRepeating()) {
                    DropDown unitDropDown = this.getRepeatUnitComponent();
                    UIComponent comp = this.getRepeatingFieldComponent();
                    if (ri == null || ri.getRepresentation().equals("ONETIME")) {
                        unitDropDown.setDisabled(true);
                        unitDropDown.setValue(null);
                        ((EditableValueHolder)comp).setValue(null);
                        comp.getAttributes().put("disabled", Boolean.TRUE);
                    } else {
                        unitDropDown.setDisabled(false);
                        unitDropDown.setValue(event.getDurationUnit());
                        ((EditableValueHolder)comp).setValue((Object)event.getDuration());
                        comp.getAttributes().put("disabled", Boolean.FALSE);
                    }
                }
            }
        } else {
            dp.setValue(null);
            ((EditableValueHolder)this.getDateComponent()).setValue(null);
            if (this.isStartTime()) {
                this.getStartTimeComponent().setValue(null);
            }
            if (this.isEndTime()) {
                this.getEndTimeComponent().setValue(null);
            }
            if (this.isRepeating()) {
                this.getRepeatIntervalComponent().setValue("ONETIME");
                if (this.isLimitRepeating()) {
                    DropDown ru = this.getRepeatUnitComponent();
                    ru.setValue(null);
                    ru.setDisabled(true);
                    EditableValueHolder rf = (EditableValueHolder)this.getRepeatingFieldComponent();
                    rf.setValue(null);
                    ((UIComponent)rf).getAttributes().put("disabled", Boolean.TRUE);
                }
            }
        }
    }

    private ClockTime getClockTime(CalendarMonth datePicker, Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = datePicker.getCalendar();
        calendar.setTime(date);
        ClockTime clockTime = new ClockTime();
        clockTime.setHour(calendar.get(11));
        clockTime.setMinute(calendar.get(12));
        return clockTime;
    }

    @Override
    public Date getFirstAvailableDate() {
        Date min = this.getMinDate();
        if (min == null) {
            Calendar calendar = this.getDatePicker().getCalendar();
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            min = calendar.getTime();
        }
        return min;
    }

    @Override
    public Date getLastAvailableDate() {
        Date max = this.getMaxDate();
        if (max == null) {
            Date min = this.getFirstAvailableDate();
            Calendar calendar = this.getDatePicker().getCalendar();
            calendar.setTime(min);
            calendar.add(1, 4);
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            calendar.set(14, 999);
            max = calendar.getTime();
        }
        return max;
    }

    @Override
    public String getDateFormatPattern() {
        if (this.dateFormatPattern != null) {
            return this.dateFormatPattern;
        }
        ValueExpression vb = this.getValueExpression("dateFormatPattern");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setDateFormatPattern(String newDateFormatPattern) {
        this.dateFormatPattern = newDateFormatPattern;
    }

    public String getDateFormatPatternHelp() {
        if (this.dateFormatPatternHelp != null) {
            return this.dateFormatPatternHelp;
        }
        ValueExpression vb = this.getValueExpression("dateFormatPatternHelp");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setDateFormatPatternHelp(String newDateFormatPatternHelp) {
        this.dateFormatPatternHelp = newDateFormatPatternHelp;
    }

    public String getDateLabel() {
        if (this.dateLabel != null) {
            return this.dateLabel;
        }
        ValueExpression vb = this.getValueExpression(DATE_LABEL_FACET);
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setDateLabel(String newDateLabel) {
        this.dateLabel = newDateLabel;
    }

    public boolean isDisabled() {
        if (this.disabledSet) {
            return this.disabled;
        }
        ValueExpression vb = this.getValueExpression("disabled");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setDisabled(boolean newDisabled) {
        this.disabled = newDisabled;
        this.disabledSet = true;
    }

    public boolean isEndTime() {
        if (this.endTimeSet) {
            return this.endTime;
        }
        ValueExpression vb = this.getValueExpression(END_TIME_FACET);
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return true;
    }

    public void setEndTime(boolean newEndTime) {
        this.endTime = newEndTime;
        this.endTimeSet = true;
    }

    public String getEndTimeLabel() {
        if (this.endTimeLabel != null) {
            return this.endTimeLabel;
        }
        ValueExpression vb = this.getValueExpression(END_TIME_LABEL_FACET);
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setEndTimeLabel(String newEndTimeLabel) {
        this.endTimeLabel = newEndTimeLabel;
    }

    public boolean isLimitRepeating() {
        if (this.limitRepeatingSet) {
            return this.limitRepeating;
        }
        ValueExpression vb = this.getValueExpression("limitRepeating");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return true;
    }

    public void setLimitRepeating(boolean newLimitRepeating) {
        this.limitRepeating = newLimitRepeating;
        this.limitRepeatingSet = true;
    }

    public Date getMaxDate() {
        if (this.maxDate != null) {
            return this.maxDate;
        }
        ValueExpression vb = this.getValueExpression("maxDate");
        if (vb != null) {
            return (Date)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setMaxDate(Date newMaxDate) {
        this.maxDate = newMaxDate;
    }

    public Date getMinDate() {
        if (this.minDate != null) {
            return this.minDate;
        }
        ValueExpression vb = this.getValueExpression("minDate");
        if (vb != null) {
            return (Date)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setMinDate(Date newMinDate) {
        this.minDate = newMinDate;
    }

    public boolean isPreviewButton() {
        if (this.previewButtonSet) {
            return this.previewButton;
        }
        ValueExpression vb = this.getValueExpression(PREVIEW_BUTTON_FACET);
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return true;
    }

    public void setPreviewButton(boolean newPreviewButton) {
        this.previewButton = newPreviewButton;
        this.previewButtonSet = true;
    }

    public boolean isReadOnly() {
        if (this.readOnlySet) {
            return this.readOnly;
        }
        ValueExpression vb = this.getValueExpression("readOnly");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setReadOnly(boolean newReadOnly) {
        this.readOnly = newReadOnly;
        this.readOnlySet = true;
    }

    private Object doGetRepeatIntervalItems() {
        if (this.repeatIntervalItems != null) {
            return this.repeatIntervalItems;
        }
        ValueExpression vb = this.getValueExpression("repeatIntervalItems");
        if (vb != null) {
            return vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setRepeatIntervalItems(Object newRepeatIntervalItems) {
        this.repeatIntervalItems = newRepeatIntervalItems;
    }

    public String getRepeatIntervalLabel() {
        if (this.repeatIntervalLabel != null) {
            return this.repeatIntervalLabel;
        }
        ValueExpression vb = this.getValueExpression(REPEAT_INTERVAL_LABEL_FACET);
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setRepeatIntervalLabel(String newRepeatIntervalLabel) {
        this.repeatIntervalLabel = newRepeatIntervalLabel;
    }

    public String getRepeatLimitLabel() {
        if (this.repeatLimitLabel != null) {
            return this.repeatLimitLabel;
        }
        ValueExpression vb = this.getValueExpression(REPEAT_LIMIT_LABEL_FACET);
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setRepeatLimitLabel(String newRepeatLimitLabel) {
        this.repeatLimitLabel = newRepeatLimitLabel;
    }

    private Object doGetRepeatUnitItems() {
        if (this.repeatUnitItems != null) {
            return this.repeatUnitItems;
        }
        ValueExpression vb = this.getValueExpression("repeatUnitItems");
        if (vb != null) {
            return vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setRepeatUnitItems(Object newRepeatUnitItems) {
        this.repeatUnitItems = newRepeatUnitItems;
    }

    public boolean isRepeating() {
        if (this.repeatingSet) {
            return this.repeating;
        }
        ValueExpression vb = this.getValueExpression("repeating");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return true;
    }

    public void setRepeating(boolean newRepeating) {
        this.repeating = newRepeating;
        this.repeatingSet = true;
    }

    public boolean isRequired() {
        if (this.requiredSet) {
            return this.required;
        }
        ValueExpression vb = this.getValueExpression("required");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return true;
    }

    @Override
    public void setRequired(boolean newRequired) {
        this.required = newRequired;
        this.requiredSet = true;
    }

    public boolean isRequiredLegend() {
        if (this.requiredLegendSet) {
            return this.requiredLegend;
        }
        ValueExpression vb = this.getValueExpression("requiredLegend");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return true;
    }

    public void setRequiredLegend(boolean newRequiredLegend) {
        this.requiredLegend = newRequiredLegend;
        this.requiredLegendSet = true;
    }

    public boolean isStartTime() {
        if (this.startTimeSet) {
            return this.startTime;
        }
        ValueExpression vb = this.getValueExpression(START_TIME_FACET);
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return true;
    }

    public void setStartTime(boolean newStartTime) {
        this.startTime = newStartTime;
        this.startTimeSet = true;
    }

    public String getStartTimeLabel() {
        if (this.startTimeLabel != null) {
            return this.startTimeLabel;
        }
        ValueExpression vb = this.getValueExpression(START_TIME_LABEL_FACET);
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStartTimeLabel(String newStartTimeLabel) {
        this.startTimeLabel = newStartTimeLabel;
    }

    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueExpression vb = this.getValueExpression("style");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyle(String newStyle) {
        this.style = newStyle;
    }

    public String getStyleClass() {
        if (this.styleClass != null) {
            return this.styleClass;
        }
        ValueExpression vb = this.getValueExpression("styleClass");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyleClass(String newStyleClass) {
        this.styleClass = newStyleClass;
    }

    public int getTabIndex() {
        if (this.tabIndexSet) {
            return this.tabIndex;
        }
        ValueExpression vb = this.getValueExpression("tabIndex");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)result;
        }
        return Integer.MIN_VALUE;
    }

    public void setTabIndex(int newTabIndex) {
        this.tabIndex = newTabIndex;
        this.tabIndexSet = true;
    }

    @Override
    public TimeZone getTimeZone() {
        if (this.timeZone != null) {
            return this.timeZone;
        }
        ValueExpression vb = this.getValueExpression("timeZone");
        if (vb != null) {
            return (TimeZone)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setTimeZone(TimeZone newTimeZone) {
        this.timeZone = newTimeZone;
    }

    public boolean isVisible() {
        if (this.visibleSet) {
            return this.visible;
        }
        ValueExpression vb = this.getValueExpression("visible");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return true;
    }

    public void setVisible(boolean newVisible) {
        this.visible = newVisible;
        this.visibleSet = true;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.dateFormatPattern = (String)values[1];
        this.dateFormatPatternHelp = (String)values[2];
        this.dateLabel = (String)values[3];
        this.disabled = (Boolean)values[4];
        this.disabledSet = (Boolean)values[5];
        this.endTime = (Boolean)values[6];
        this.endTimeSet = (Boolean)values[7];
        this.endTimeLabel = (String)values[8];
        this.limitRepeating = (Boolean)values[9];
        this.limitRepeatingSet = (Boolean)values[10];
        this.maxDate = (Date)values[11];
        this.minDate = (Date)values[12];
        this.previewButton = (Boolean)values[13];
        this.previewButtonSet = (Boolean)values[14];
        this.readOnly = (Boolean)values[15];
        this.readOnlySet = (Boolean)values[16];
        this.repeatIntervalItems = values[17];
        this.repeatIntervalLabel = (String)values[18];
        this.repeatLimitLabel = (String)values[19];
        this.repeatUnitItems = values[20];
        this.repeating = (Boolean)values[21];
        this.repeatingSet = (Boolean)values[22];
        this.required = (Boolean)values[23];
        this.requiredSet = (Boolean)values[24];
        this.requiredLegend = (Boolean)values[25];
        this.requiredLegendSet = (Boolean)values[26];
        this.startTime = (Boolean)values[27];
        this.startTimeSet = (Boolean)values[28];
        this.startTimeLabel = (String)values[29];
        this.style = (String)values[30];
        this.styleClass = (String)values[31];
        this.tabIndex = (Integer)values[32];
        this.tabIndexSet = (Boolean)values[33];
        this.timeZone = (TimeZone)values[34];
        this.visible = (Boolean)values[35];
        this.visibleSet = (Boolean)values[36];
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] values = new Object[37];
        values[0] = super.saveState(context);
        values[1] = this.dateFormatPattern;
        values[2] = this.dateFormatPatternHelp;
        values[3] = this.dateLabel;
        values[4] = this.disabled ? Boolean.TRUE : Boolean.FALSE;
        values[5] = this.disabledSet ? Boolean.TRUE : Boolean.FALSE;
        values[6] = this.endTime ? Boolean.TRUE : Boolean.FALSE;
        values[7] = this.endTimeSet ? Boolean.TRUE : Boolean.FALSE;
        values[8] = this.endTimeLabel;
        values[9] = this.limitRepeating ? Boolean.TRUE : Boolean.FALSE;
        values[10] = this.limitRepeatingSet ? Boolean.TRUE : Boolean.FALSE;
        values[11] = this.maxDate;
        values[12] = this.minDate;
        values[13] = this.previewButton ? Boolean.TRUE : Boolean.FALSE;
        values[14] = this.previewButtonSet ? Boolean.TRUE : Boolean.FALSE;
        values[15] = this.readOnly ? Boolean.TRUE : Boolean.FALSE;
        values[16] = this.readOnlySet ? Boolean.TRUE : Boolean.FALSE;
        values[17] = this.repeatIntervalItems;
        values[18] = this.repeatIntervalLabel;
        values[19] = this.repeatLimitLabel;
        values[20] = this.repeatUnitItems;
        values[21] = this.repeating ? Boolean.TRUE : Boolean.FALSE;
        if (this.repeatingSet) {
            values[22] = Boolean.TRUE;
        } else {
            values[2] = Boolean.FALSE;
        }
        values[23] = this.required ? Boolean.TRUE : Boolean.FALSE;
        values[24] = this.requiredSet ? Boolean.TRUE : Boolean.FALSE;
        values[25] = this.requiredLegend ? Boolean.TRUE : Boolean.FALSE;
        values[26] = this.requiredLegendSet ? Boolean.TRUE : Boolean.FALSE;
        values[27] = this.startTime ? Boolean.TRUE : Boolean.FALSE;
        values[28] = this.startTimeSet ? Boolean.TRUE : Boolean.FALSE;
        values[29] = this.startTimeLabel;
        values[30] = this.style;
        values[31] = this.styleClass;
        values[32] = this.tabIndex;
        values[33] = this.tabIndexSet ? Boolean.TRUE : Boolean.FALSE;
        values[34] = this.timeZone;
        values[35] = this.visible ? Boolean.TRUE : Boolean.FALSE;
        values[36] = this.visibleSet ? Boolean.TRUE : Boolean.FALSE;
        return values;
    }
}

