/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.shoal.ha.cache.api;

import org.glassfish.shoal.ha.cache.api.DataStoreContext;
import org.glassfish.shoal.ha.cache.api.DataStoreException;
import org.glassfish.shoal.ha.cache.command.Command;
import org.glassfish.shoal.ha.cache.command.CommandManager;

public abstract class AbstractCommandInterceptor<K, V> {
    protected String storeName;
    protected DataStoreContext<K, V> dsc;
    private CommandManager<K, V> cm;
    private AbstractCommandInterceptor<K, V> next;
    private AbstractCommandInterceptor<K, V> prev;

    public void initialize(DataStoreContext<K, V> dsc) {
        this.dsc = dsc;
        this.cm = dsc.getCommandManager();
        this.storeName = dsc.getServiceName();
    }

    public final DataStoreContext<K, V> getDataStoreContext() {
        return this.dsc;
    }

    public CommandManager getCommandManager() {
        return this.cm;
    }

    public final void setNext(AbstractCommandInterceptor<K, V> next) {
        this.next = next;
    }

    public final void setPrev(AbstractCommandInterceptor<K, V> prev) {
        this.prev = prev;
    }

    public final AbstractCommandInterceptor<K, V> getNext() {
        return this.next;
    }

    public final AbstractCommandInterceptor<K, V> getPrev() {
        return this.prev;
    }

    public void onTransmit(Command<K, V> cmd, String initiator) throws DataStoreException {
        AbstractCommandInterceptor<K, V> n = this.getNext();
        if (n != null) {
            n.onTransmit(cmd, initiator);
        }
    }

    public void onReceive(Command<K, V> cmd, String initiator) throws DataStoreException {
        AbstractCommandInterceptor<K, V> p = this.getPrev();
        if (p != null) {
            p.onReceive(cmd, initiator);
        }
    }

    public void close() {
    }
}

