/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.connectors.admin.cli.ResourceAdapterConfigManager;
import org.glassfish.connectors.config.ResourceAdapterConfig;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.resourcebase.resources.api.ResourceStatus;
import org.glassfish.resources.api.ResourceAttributes;
import org.jvnet.hk2.annotations.Service;

@ExecuteOn(value={RuntimeType.ALL})
@Service(name="create-resource-adapter-config")
@PerLookup
@I18n(value="create.resource.adapter.config")
public class CreateResourceAdapterConfig
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateResourceAdapterConfig.class);
    @Param(name="raname", primary=true)
    private String raName;
    @Param(name="property", optional=true, separator=58)
    private Properties properties;
    @Param(name="target", optional=true, obsolete=true, defaultValue="server")
    private String target;
    @Param(name="threadpoolid", optional=true, alias="threadPoolIds")
    private String threadPoolIds;
    @Param(name="objecttype", defaultValue="user", optional=true)
    private String objectType;
    @Inject
    private Applications applications;
    @Inject
    private Domain domain;

    public void execute(AdminCommandContext context) {
        ResourceStatus rs;
        Resources appScopedResources;
        Resources msr;
        String resourceAdapterName;
        Module module;
        Application application;
        ActionReport report = context.getActionReport();
        ResourceAttributes attrList = new ResourceAttributes();
        attrList.set("resource-adapter-name", this.raName);
        attrList.set("thread-pool-ids", this.threadPoolIds);
        attrList.set("object-type", this.objectType);
        String appName = this.raName;
        if (!ConnectorsUtil.isStandAloneRA((String)this.raName) ? (application = this.applications.getApplication(appName = ConnectorsUtil.getApplicationNameOfEmbeddedRar((String)this.raName))) != null && (module = application.getModule(resourceAdapterName = ConnectorsUtil.getRarNameFromApplication((String)this.raName))) != null && (msr = module.getResources()) != null && this.hasDuplicate(msr, report) : (application = this.applications.getApplication(appName)) != null && (appScopedResources = application.getResources()) != null && this.hasDuplicate(appScopedResources, report)) {
            return;
        }
        ResourceAdapterConfigManager resAdapterConfigMgr = new ResourceAdapterConfigManager();
        try {
            rs = resAdapterConfigMgr.create(this.domain.getResources(), attrList, this.properties, this.target);
        }
        catch (Exception ex) {
            Logger.getLogger(CreateResourceAdapterConfig.class.getName()).log(Level.SEVERE, "Unable to create resource adapter config for " + this.raName, ex);
            String def = "Resource adapter config: {0} could not be created, reason: {1}";
            report.setMessage(localStrings.getLocalString("create.resource.adapter.config.fail", def, new Object[]{this.raName}) + " " + ex.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)ex);
            return;
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        if (rs.getStatus() == 1) {
            ec = ActionReport.ExitCode.FAILURE;
            if (rs.getMessage() != null) {
                report.setMessage(rs.getMessage());
            } else {
                report.setMessage(localStrings.getLocalString("create.resource.adapter.config.fail", "Resource adapter config {0} creation failed", new Object[]{this.raName, ""}));
            }
            if (rs.getException() != null) {
                report.setFailureCause(rs.getException());
            }
        }
        report.setActionExitCode(ec);
    }

    private boolean hasDuplicate(Resources resources, ActionReport report) {
        SimpleJndiName jndiName = new SimpleJndiName(this.raName);
        if (resources.getResourceByName(ResourceAdapterConfig.class, jndiName) != null) {
            String msg = localStrings.getLocalString("create.resource.adapter.config.duplicate", "Resource adapter config already exists for RAR", new Object[]{jndiName});
            report.setMessage(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return true;
        }
        return false;
    }
}

