/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.util;

import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.ManagedBeanDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.deploy.shared.Util;
import com.sun.enterprise.deployment.io.ConfigurationDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.ConfigurationDeploymentDescriptorFileFor;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.CarArchiveType;
import org.glassfish.api.deployment.archive.EarArchiveType;
import org.glassfish.api.deployment.archive.EjbArchiveType;
import org.glassfish.api.deployment.archive.RarArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.ScatteredWarArchiveType;
import org.glassfish.api.deployment.archive.WarArchiveType;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.common.ModuleDescriptor;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.internal.deployment.SnifferManager;
import org.glassfish.loader.util.ASClassLoaderUtil;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.logging.annotation.LogMessagesResourceBundle;
import org.glassfish.logging.annotation.LoggerInfo;
import org.xml.sax.SAXException;

public class DOLUtils {
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String SCHEMA_LOCATION_TAG = "xsi:schemaLocation";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DOLUtils.class);
    @LogMessagesResourceBundle
    private static final String SHARED_LOGMESSAGE_RESOURCE = "org.glassfish.deployment.LogMessages";
    @LoggerInfo(subsystem="DEPLOYMENT", description="Deployment logger for dol module", publish=true)
    private static final String DEPLOYMENT_LOGGER = "jakarta.enterprise.system.tools.deployment.dol";
    public static final Logger deplLogger = Logger.getLogger("jakarta.enterprise.system.tools.deployment.dol", "org.glassfish.deployment.LogMessages");
    private static final System.Logger LOGGER = System.getLogger("jakarta.enterprise.system.tools.deployment.dol", deplLogger.getResourceBundle());
    @LogMessageInfo(message="Ignore {0} in archive {1}, as WLS counterpart runtime xml {2} is present in the same archive.", level="WARNING")
    private static final String COUNTERPART_CONFIGDD_EXISTS = "AS-DEPLOYMENT-00001";
    @LogMessageInfo(message="Exception caught:  {0}.", level="WARNING")
    private static final String EXCEPTION_CAUGHT = "AS-DEPLOYMENT-00002";
    @LogMessageInfo(message="{0} module [{1}] contains characteristics of other module type: {2}.", level="WARNING")
    private static final String INCOMPATIBLE_TYPE = "AS-DEPLOYMENT-00003";
    @LogMessageInfo(message="Unsupported deployment descriptors element {0} value {1} for descriptor {2}.", level="WARNING")
    public static final String INVALID_DESC_MAPPING = "AS-DEPLOYMENT-00015";
    @LogMessageInfo(message="DOLUtils: Invalid Deployment Descriptors in {0} \nLine {1} Column {2} -- {3}.", level="SEVERE", cause="Failed to find the resource specified in the deployment descriptor. May be because of wrong specification in the descriptor", action="Ensure that the resource specified is present. Ensure that there is no typo in the resource specified in the descriptor")
    public static final String INVALILD_DESCRIPTOR_LONG = "AS-DEPLOYMENT-00118";
    @LogMessageInfo(message="Deployment Descriptor parsing failure: {0}", cause="Error while parsing the deployment descriptor. May be because of malformed descriptor or absence of all required descriptor elements.", action="Ensure that the descriptor is well formed and as per specification. Ensure that the SAX parser configuration is correct and the descriptor has right permissions.")
    public static final String INVALILD_DESCRIPTOR_SHORT = "AS-DEPLOYMENT-00120";
    @LogMessageInfo(message="DEP0003:The jndi-name is already used in the global tree failed for given jndi-name: {0}", level="SEVERE", cause="The JNDI name of the descriptor is already used in the global JNDI tree, probably by a resource defined on the server", action="Make sure that the JNDI name doesn't conflict with any global resource already defined on the server")
    public static final String JNDI_LOOKUP_FAILED = "enterprise.deployment.util.application.lookup";
    @LogMessageInfo(message="DEP0004:Deployment failed because a conflict occured for jndi-name: {0} for application: {1}", level="SEVERE", cause="Unknown", action="Unknown")
    public static final String INVALID_NAMESPACE = "enterprise.deployment.util.application.invalid.namespace";
    @LogMessageInfo(message="DEP0005:Deployment failed due to the invalid scope {0} defined for jndi-name: {1}", level="SEVERE", cause="Unknown", action="Unknown")
    public static final String INVALID_JNDI_SCOPE = "enterprise.deployment.util.application.invalid.jndiname.scope";
    @LogMessageInfo(message="DPL8006: get/add descriptor failure : {0} TO {1}", level="SEVERE", cause="Adding or getting a descriptor failed. May be because the node / information to be added is not valid; may be because of the descriptor was not registered", action="Ensure that the node to be added is valid. Ensure that the permissions are set as expected.")
    public static final String ADD_DESCRIPTOR_FAILURE = "enterprise.deployment.backend.addDescriptorFailure";
    private static final String GFDD_OVER_WLSDD = "gfdd.over.wlsdd";
    private static final String IGNORE_WLSDD = "ignore.wlsdd";
    private static final String ID_SEPARATOR = "_";

    private DOLUtils() {
    }

    public static Logger getDefaultLogger() {
        return deplLogger;
    }

    public static System.Logger getLogger() {
        return LOGGER;
    }

    public static boolean equals(Object a, Object b) {
        return a == null && b == null || a != null && a.equals(b);
    }

    public static List<URI> getLibraryJarURIs(BundleDescriptor bundleDesc, ReadableArchive archive) throws Exception {
        if (bundleDesc == null) {
            return Collections.emptyList();
        }
        ModuleDescriptor moduleDesc = bundleDesc.getModuleDescriptor();
        Application app = ((BundleDescriptor)moduleDesc.getDescriptor()).getApplication();
        return DOLUtils.getLibraryJarURIs(app, archive);
    }

    public static List<URI> getLibraryJarURIs(Application app, ReadableArchive archive) throws Exception {
        ArrayList<URI> libraryURIs = new ArrayList<URI>();
        ArrayList libraryURLs = new ArrayList(DeploymentUtils.getManifestLibraries((ReadableArchive)archive));
        ReadableArchive parentArchive = archive.getParentArchive();
        if (parentArchive == null) {
            return Collections.emptyList();
        }
        File appRoot = new File(parentArchive.getURI());
        libraryURLs.addAll(ASClassLoaderUtil.getAppLibDirLibrariesAsList((File)appRoot, (String)app.getLibraryDirectory(), null));
        for (URL url : libraryURLs) {
            libraryURIs.add(Util.toURI((URL)url));
        }
        return libraryURIs;
    }

    public static BundleDescriptor getCurrentBundleForContext(DeploymentContext context) {
        ExtendedDeploymentContext ctx = (ExtendedDeploymentContext)context;
        Application application = (Application)context.getModuleMetaData(Application.class);
        if (application == null) {
            return null;
        }
        if (ctx.getParentContext() == null) {
            if (application.isVirtual()) {
                return application.getStandaloneBundleDescriptor();
            }
            return application;
        }
        return application.getModuleByUri(ctx.getModuleUri());
    }

    public static boolean isRAConnectionFactory(ServiceLocator habitat, String type, Application thisApp) {
        if (DOLUtils.isRAConnectionFactory(type, thisApp)) {
            return true;
        }
        Applications applications = (Applications)habitat.getService(Applications.class, new Annotation[0]);
        if (applications != null) {
            List raApps = applications.getApplicationsWithSnifferType("connector", true);
            ApplicationRegistry appRegistry = (ApplicationRegistry)habitat.getService(ApplicationRegistry.class, new Annotation[0]);
            for (com.sun.enterprise.config.serverbeans.Application raApp : raApps) {
                ApplicationInfo appInfo = appRegistry.get(raApp.getName());
                if (appInfo == null || !DOLUtils.isRAConnectionFactory(type, (Application)appInfo.getMetaData(Application.class))) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isRAConnectionFactory(String type, Application app) {
        if (app == null) {
            return false;
        }
        for (ConnectorDescriptor cd : app.getBundleDescriptors(ConnectorDescriptor.class)) {
            if (cd.getConnectionDefinitionByCFType(type) == null) continue;
            return true;
        }
        return false;
    }

    public static ArchiveType earType() {
        return DOLUtils.getModuleType("ear");
    }

    public static ArchiveType ejbType() {
        return DOLUtils.getModuleType("ejb");
    }

    public static ArchiveType carType() {
        return DOLUtils.getModuleType("car");
    }

    public static ArchiveType warType() {
        return DOLUtils.getModuleType("war");
    }

    public static ArchiveType rarType() {
        return DOLUtils.getModuleType("rar");
    }

    public static ArchiveType scatteredWarType() {
        return DOLUtils.getModuleType("scattered-war");
    }

    public static ArchiveType getModuleType(String moduleType) {
        if (moduleType == null) {
            return null;
        }
        switch (moduleType) {
            case "war": {
                return WarArchiveType.WAR_ARCHIVE;
            }
            case "ejb": {
                return EjbArchiveType.EJB_ARCHIVE;
            }
            case "ear": {
                return EarArchiveType.EAR_ARCHIVE;
            }
            case "car": {
                return CarArchiveType.CAR_ARCHIVE;
            }
            case "rar": {
                return RarArchiveType.RAR_ARCHIVE;
            }
            case "scattered-war": {
                return ScatteredWarArchiveType.SCATTERED_WAR_ARCHIVE;
            }
        }
        ServiceLocator services = Globals.getStaticBaseServiceLocator();
        if (services != null) {
            return (ArchiveType)services.getService(ArchiveType.class, moduleType, new Annotation[0]);
        }
        throw new IllegalArgumentException("Unsupported type: " + moduleType);
    }

    public static boolean isGFDDOverWLSDD() {
        return Boolean.getBoolean(GFDD_OVER_WLSDD);
    }

    public static boolean isIgnoreWLSDD() {
        return Boolean.getBoolean(IGNORE_WLSDD);
    }

    private static List<ConfigurationDeploymentDescriptorFile> sortConfigurationDDFiles(List<ConfigurationDeploymentDescriptorFile> ddFiles, ArchiveType archiveType, ReadableArchive archive) {
        ConfigurationDeploymentDescriptorFile wlsConfDD = null;
        ConfigurationDeploymentDescriptorFile gfConfDD = null;
        ConfigurationDeploymentDescriptorFile sunConfDD = null;
        for (ConfigurationDeploymentDescriptorFile ddFile : ddFiles) {
            ddFile.setArchiveType(archiveType);
            String ddPath = ddFile.getDeploymentDescriptorPath();
            if (ddPath.indexOf("weblogic") != -1) {
                wlsConfDD = ddFile;
                continue;
            }
            if (ddPath.indexOf("glassfish-") != -1) {
                gfConfDD = ddFile;
                continue;
            }
            if (ddPath.indexOf("sun-") == -1) continue;
            sunConfDD = ddFile;
        }
        ArrayList<ConfigurationDeploymentDescriptorFile> sortedConfDDFiles = new ArrayList<ConfigurationDeploymentDescriptorFile>();
        File runtimeAltDDFile = (File)archive.getArchiveMetaData("runtimealtdd", File.class);
        if (runtimeAltDDFile != null && runtimeAltDDFile.exists() && runtimeAltDDFile.isFile()) {
            String runtimeAltDDPath = runtimeAltDDFile.getPath();
            DOLUtils.validateRuntimeAltDDPath(runtimeAltDDPath);
            if (runtimeAltDDPath.indexOf("glassfish-") != -1 && gfConfDD != null) {
                sortedConfDDFiles.add(gfConfDD);
                return sortedConfDDFiles;
            }
        }
        if (Boolean.getBoolean(GFDD_OVER_WLSDD)) {
            if (gfConfDD != null) {
                sortedConfDDFiles.add(gfConfDD);
            }
            if (wlsConfDD != null) {
                sortedConfDDFiles.add(wlsConfDD);
            }
        } else if (Boolean.getBoolean(IGNORE_WLSDD)) {
            if (gfConfDD != null) {
                sortedConfDDFiles.add(gfConfDD);
            }
        } else {
            if (wlsConfDD != null) {
                sortedConfDDFiles.add(wlsConfDD);
            }
            if (gfConfDD != null) {
                sortedConfDDFiles.add(gfConfDD);
            }
        }
        if (sunConfDD != null) {
            sortedConfDDFiles.add(sunConfDD);
        }
        return sortedConfDDFiles;
    }

    public static void validateRuntimeAltDDPath(String runtimeAltDDPath) {
        if (runtimeAltDDPath.indexOf("glassfish-") == -1) {
            String msg = localStrings.getLocalString("enterprise.deployment.util.unsupportedruntimealtdd", "Unsupported external runtime alternate deployment descriptor [{0}].", new Object[]{runtimeAltDDPath});
            throw new IllegalArgumentException(msg);
        }
    }

    public static List<ConfigurationDeploymentDescriptorFile> processConfigurationDDFiles(List<ConfigurationDeploymentDescriptorFile> ddFiles, ReadableArchive archive, ArchiveType archiveType) throws IOException {
        File runtimeAltDDFile = (File)archive.getArchiveMetaData("runtimealtdd", File.class);
        if (runtimeAltDDFile != null && runtimeAltDDFile.exists() && runtimeAltDDFile.isFile()) {
            return DOLUtils.sortConfigurationDDFiles(ddFiles, archiveType, archive);
        }
        ArrayList<ConfigurationDeploymentDescriptorFile> processedConfDDFiles = new ArrayList<ConfigurationDeploymentDescriptorFile>();
        for (ConfigurationDeploymentDescriptorFile ddFile : DOLUtils.sortConfigurationDDFiles(ddFiles, archiveType, archive)) {
            if (!archive.exists(ddFile.getDeploymentDescriptorPath())) continue;
            processedConfDDFiles.add(ddFile);
        }
        return processedConfDDFiles;
    }

    public static void readAlternativeRuntimeDescriptor(ReadableArchive appArchive, ReadableArchive embeddedArchive, Archivist archivist, BundleDescriptor descriptor, String altDDPath) throws IOException, SAXException {
        String altRuntimeDDPath = null;
        DeploymentDescriptorFile confDD = null;
        List<ConfigurationDeploymentDescriptorFile> archivistConfDDFiles = archivist.getConfigurationDDFiles();
        for (ConfigurationDeploymentDescriptorFile ddFile : DOLUtils.sortConfigurationDDFiles(archivistConfDDFiles, archivist.getModuleType(), embeddedArchive)) {
            String ddPath = ddFile.getDeploymentDescriptorPath();
            if (ddPath.indexOf("weblogic") != -1 && appArchive.exists("weblogic" + altDDPath)) {
                confDD = ddFile;
                altRuntimeDDPath = "weblogic" + altDDPath;
                continue;
            }
            if (ddPath.indexOf("glassfish-") != -1 && appArchive.exists("glassfish-" + altDDPath)) {
                confDD = ddFile;
                altRuntimeDDPath = "glassfish-" + altDDPath;
                continue;
            }
            if (ddPath.indexOf("sun-") == -1 || !appArchive.exists("sun-" + altDDPath)) continue;
            confDD = ddFile;
            altRuntimeDDPath = "sun-" + altDDPath;
        }
        if (confDD != null && altRuntimeDDPath != null) {
            InputStream is = appArchive.getEntry(altRuntimeDDPath);
            confDD.setXMLValidation(archivist.getRuntimeXMLValidation());
            confDD.setXMLValidationLevel(archivist.getRuntimeXMLValidationLevel());
            if (appArchive.getURI() != null) {
                confDD.setErrorReportingString(appArchive.getURI().getSchemeSpecificPart());
            }
            confDD.read(descriptor, is);
            is.close();
            archivist.postRuntimeDDsRead(descriptor, embeddedArchive);
        } else {
            archivist.readRuntimeDeploymentDescriptor(embeddedArchive, descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readRuntimeDeploymentDescriptor(List<ConfigurationDeploymentDescriptorFile> confDDFiles, ReadableArchive archive, RootDeploymentDescriptor descriptor, Archivist main, boolean warnIfMultipleDDs) throws IOException, SAXException {
        if (confDDFiles == null || confDDFiles.isEmpty()) {
            return;
        }
        ConfigurationDeploymentDescriptorFile confDD = confDDFiles.get(0);
        InputStream is = null;
        try {
            File runtimeAltDDFile = (File)archive.getArchiveMetaData("runtimealtdd", File.class);
            is = runtimeAltDDFile != null && runtimeAltDDFile.exists() && runtimeAltDDFile.isFile() ? new FileInputStream(runtimeAltDDFile) : archive.getEntry(confDD.getDeploymentDescriptorPath());
            if (is == null) {
                return;
            }
            for (int i = 1; i < confDDFiles.size(); ++i) {
                if (!warnIfMultipleDDs) continue;
                deplLogger.log(Level.WARNING, COUNTERPART_CONFIGDD_EXISTS, new Object[]{confDDFiles.get(i).getDeploymentDescriptorPath(), archive.getURI().getSchemeSpecificPart(), confDD.getDeploymentDescriptorPath()});
            }
            confDD.setErrorReportingString(archive.getURI().getSchemeSpecificPart());
            if (confDD.isValidating()) {
                confDD.setXMLValidation(main.getRuntimeXMLValidation());
                confDD.setXMLValidationLevel(main.getRuntimeXMLValidationLevel());
            } else {
                confDD.setXMLValidation(false);
            }
            confDD.read(descriptor, is);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void setExtensionArchivistForSubArchivist(ServiceLocator habitat, ReadableArchive archive, ModuleDescriptor md, Application app, Archivist subArchivist) {
        try {
            Collection<Sniffer> sniffers = DOLUtils.getSniffersForModule(habitat, archive, md, app);
            ArchivistFactory archivistFactory = (ArchivistFactory)habitat.getService(ArchivistFactory.class, new Annotation[0]);
            subArchivist.setExtensionArchivists(archivistFactory.getExtensionsArchivists(sniffers, subArchivist.getModuleType()));
        }
        catch (Exception e) {
            deplLogger.log(Level.WARNING, EXCEPTION_CAUGHT, new Object[]{e.getMessage(), e});
        }
    }

    private static Collection<Sniffer> getSniffersForModule(ServiceLocator habitat, ReadableArchive archive, ModuleDescriptor md, Application app) throws Exception {
        ArchiveHandler handler = (ArchiveHandler)habitat.getService(ArchiveHandler.class, md.getModuleType().toString(), new Annotation[0]);
        SnifferManager snifferManager = (SnifferManager)habitat.getService(SnifferManager.class, new Annotation[0]);
        List classPathURIs = handler.getClassPathURIs(archive);
        classPathURIs.addAll(DOLUtils.getLibraryJarURIs(app, archive));
        Types types = (Types)archive.getParentArchive().getExtraData(Types.class);
        DeployCommandParameters parameters = (DeployCommandParameters)archive.getParentArchive().getArchiveMetaData("commandparams", DeployCommandParameters.class);
        Properties appProps = (Properties)archive.getParentArchive().getArchiveMetaData("appprops", Properties.class);
        DeploymentContextImpl context = new DeploymentContextImpl(null, archive, (OpsParams)parameters, (ServerEnvironment)habitat.getService(ServerEnvironment.class, new Annotation[0]));
        if (appProps != null) {
            context.getAppProps().putAll((Map<?, ?>)appProps);
        }
        context.setArchiveHandler(handler);
        context.addTransientAppMetaData(Types.class.getName(), (Object)types);
        Collection sniffers = snifferManager.getSniffers((DeploymentContext)context, classPathURIs, types);
        context.postDeployClean(true);
        String type = DOLUtils.getTypeFromModuleType(md.getModuleType());
        Sniffer mainSniffer = null;
        for (Sniffer sniffer : sniffers) {
            if (!sniffer.getModuleType().equals(type)) continue;
            mainSniffer = sniffer;
        }
        if (mainSniffer == null) {
            mainSniffer = snifferManager.getSniffer(type);
            sniffers.add(mainSniffer);
        }
        String[] incompatibleTypes = mainSniffer.getIncompatibleSnifferTypes();
        List<String> allIncompatTypes = DOLUtils.addAdditionalIncompatTypes(mainSniffer, incompatibleTypes);
        ArrayList<Sniffer> sniffersToRemove = new ArrayList<Sniffer>();
        for (Sniffer sniffer : sniffers) {
            for (String incompatType : allIncompatTypes) {
                if (!sniffer.getModuleType().equals(incompatType)) continue;
                deplLogger.log(Level.WARNING, INCOMPATIBLE_TYPE, new Object[]{type, md.getArchiveUri(), incompatType});
                sniffersToRemove.add(sniffer);
            }
        }
        sniffers.removeAll(sniffersToRemove);
        Hashtable<String, Collection> sniffersTable = (Hashtable<String, Collection>)archive.getParentArchive().getExtraData(Hashtable.class);
        if (sniffersTable == null) {
            sniffersTable = new Hashtable<String, Collection>();
            archive.getParentArchive().setExtraData(Hashtable.class, sniffersTable);
        }
        sniffersTable.put(md.getArchiveUri(), sniffers);
        return sniffers;
    }

    private static String getTypeFromModuleType(ArchiveType moduleType) {
        if (moduleType.equals((Object)DOLUtils.warType())) {
            return "web";
        }
        if (moduleType.equals((Object)DOLUtils.ejbType())) {
            return "ejb";
        }
        if (moduleType.equals((Object)DOLUtils.carType())) {
            return "appclient";
        }
        if (moduleType.equals((Object)DOLUtils.rarType())) {
            return "connector";
        }
        return null;
    }

    private static List<String> addAdditionalIncompatTypes(Sniffer mainSniffer, String[] incompatTypes) {
        ArrayList<String> allIncompatTypes = new ArrayList<String>();
        for (String incompatType : incompatTypes) {
            allIncompatTypes.add(incompatType);
        }
        if (mainSniffer.getModuleType().equals("appclient")) {
            allIncompatTypes.add("ejb");
        } else if (mainSniffer.getModuleType().equals("ejb")) {
            allIncompatTypes.add("appclient");
        }
        return allIncompatTypes;
    }

    public static List<ConfigurationDeploymentDescriptorFile> getConfigurationDeploymentDescriptorFiles(ServiceLocator habitat, String containerType) {
        ArrayList<ConfigurationDeploymentDescriptorFile> confDDFiles = new ArrayList<ConfigurationDeploymentDescriptorFile>();
        for (ServiceHandle serviceHandle : habitat.getAllServiceHandles(ConfigurationDeploymentDescriptorFileFor.class, new Annotation[0])) {
            ActiveDescriptor descriptor = serviceHandle.getActiveDescriptor();
            String indexedType = (String)((List)descriptor.getMetadata().get("DescriptorFor")).get(0);
            if (!indexedType.equals(containerType)) continue;
            ConfigurationDeploymentDescriptorFile confDD = (ConfigurationDeploymentDescriptorFile)serviceHandle.getService();
            confDDFiles.add(confDD);
        }
        return confDDFiles;
    }

    public static boolean setElementValue(XMLElement element, String value, Object o) {
        LOGGER.log(System.Logger.Level.DEBUG, "setElementValue(element={0}, value={1}, o={2})", element, value, o);
        if (SCHEMA_LOCATION_TAG.equals(element.getCompleteName())) {
            StringTokenizer st = new StringTokenizer(value);
            StringBuilder sb = new StringBuilder();
            while (st.hasMoreElements()) {
                String schema;
                String namespace = (String)st.nextElement();
                if (st.hasMoreElements()) {
                    schema = (String)st.nextElement();
                } else {
                    schema = namespace;
                    namespace = "https://jakarta.ee/xml/ns/jakartaee";
                }
                if (namespace.equals("http://java.sun.com/xml/ns/j2ee") || namespace.equals("http://xmlns.jcp.org/xml/ns/javaee") || namespace.equals("https://jakarta.ee/xml/ns/jakartaee") || namespace.equals(W3C_XML_SCHEMA)) continue;
                sb.append(namespace);
                sb.append(' ');
                sb.append(schema);
            }
            String clientSchemaLocation = sb.toString();
            if (!clientSchemaLocation.isEmpty() && o instanceof RootDeploymentDescriptor) {
                ((RootDeploymentDescriptor)o).setSchemaLocation(clientSchemaLocation);
            }
            return true;
        }
        if (element.getQName().equals("metadata-complete")) {
            if (o instanceof BundleDescriptor) {
                ((BundleDescriptor)o).setFullAttribute(value);
            }
            return true;
        }
        return false;
    }

    public static List<String> getProprietarySchemaNamespaces() {
        ArrayList<String> ns = new ArrayList<String>();
        ns.add("http://www.bea.com/ns/weblogic/");
        ns.add("http://xmlns.oracle.com/weblogic/");
        return ns;
    }

    public static List<String> getProprietaryDTDStart() {
        ArrayList<String> ns = new ArrayList<String>();
        ns.add("http://www.beasys.com/servers");
        return ns;
    }

    public static Application getApplicationFromEnv(JndiNameEnvironment env) {
        if (env instanceof EjbDescriptor) {
            EjbDescriptor ejbEnv = (EjbDescriptor)env;
            return ejbEnv.getApplication();
        }
        if (env instanceof EjbBundleDescriptor) {
            EjbBundleDescriptor ejbBundle = (EjbBundleDescriptor)env;
            return ejbBundle.getApplication();
        }
        if (env instanceof WebBundleDescriptor) {
            WebBundleDescriptor webEnv = (WebBundleDescriptor)env;
            return webEnv.getApplication();
        }
        if (env instanceof ApplicationClientDescriptor) {
            ApplicationClientDescriptor appEnv = (ApplicationClientDescriptor)env;
            return appEnv.getApplication();
        }
        if (env instanceof ManagedBeanDescriptor) {
            ManagedBeanDescriptor mb = (ManagedBeanDescriptor)env;
            return mb.getBundle().getApplication();
        }
        if (env instanceof Application) {
            return (Application)env;
        }
        throw new IllegalArgumentException("IllegalJndiNameEnvironment : env");
    }

    public static String getApplicationName(JndiNameEnvironment env) {
        Application app = DOLUtils.getApplicationFromEnv(env);
        if (app != null) {
            return app.getAppName();
        }
        throw new IllegalArgumentException("IllegalJndiNameEnvironment : env");
    }

    public static String getModuleName(JndiNameEnvironment env) {
        if (env instanceof EjbDescriptor) {
            EjbDescriptor ejbEnv = (EjbDescriptor)env;
            EjbBundleDescriptor ejbBundle = ejbEnv.getEjbBundleDescriptor();
            return ejbBundle.getModuleDescriptor().getModuleName();
        }
        if (env instanceof EjbBundleDescriptor) {
            EjbBundleDescriptor ejbBundle = (EjbBundleDescriptor)env;
            return ejbBundle.getModuleDescriptor().getModuleName();
        }
        if (env instanceof WebBundleDescriptor) {
            WebBundleDescriptor webEnv = (WebBundleDescriptor)env;
            return webEnv.getModuleName();
        }
        if (env instanceof ApplicationClientDescriptor) {
            ApplicationClientDescriptor appEnv = (ApplicationClientDescriptor)env;
            return appEnv.getModuleName();
        }
        if (env instanceof ManagedBeanDescriptor) {
            ManagedBeanDescriptor mb = (ManagedBeanDescriptor)env;
            return mb.getBundle().getModuleName();
        }
        throw new IllegalArgumentException("Unsupported: " + String.valueOf(env));
    }

    public static boolean getTreatComponentAsModule(JndiNameEnvironment env) {
        EjbDescriptor ejbDesc;
        EjbBundleDescriptor ejbBundle;
        if (env instanceof WebBundleDescriptor) {
            return true;
        }
        return env instanceof EjbDescriptor && (ejbBundle = (ejbDesc = (EjbDescriptor)env).getEjbBundleDescriptor()).getModuleDescriptor().getDescriptor() instanceof WebBundleDescriptor;
    }

    public static String getComponentEnvId(JndiNameEnvironment env) {
        LOGGER.log(System.Logger.Level.DEBUG, "getComponentEnvId(env.class={0})", env.getClass().getName());
        if (env instanceof EjbDescriptor) {
            EjbDescriptor ejbEnv = (EjbDescriptor)env;
            String flattedJndiName = ejbEnv.getJndiName().toString().replace('/', '.');
            EjbBundleDescriptor ejbBundle = ejbEnv.getEjbBundleDescriptor();
            RootDeploymentDescriptor d = ejbBundle.getModuleDescriptor().getDescriptor();
            if (d instanceof WebBundleDescriptor) {
                WebBundleDescriptor webEnv = (WebBundleDescriptor)d;
                return webEnv.getApplication().getName() + ID_SEPARATOR + webEnv.getContextRoot();
            }
            return ejbEnv.getApplication().getName() + ID_SEPARATOR + ejbBundle.getModuleDescriptor().getArchiveUri() + ID_SEPARATOR + ejbEnv.getName() + ID_SEPARATOR + flattedJndiName + ejbEnv.getUniqueId();
        }
        if (env instanceof WebBundleDescriptor) {
            WebBundleDescriptor webEnv = (WebBundleDescriptor)env;
            return webEnv.getApplication().getName() + ID_SEPARATOR + webEnv.getContextRoot();
        }
        if (env instanceof ApplicationClientDescriptor) {
            ApplicationClientDescriptor appEnv = (ApplicationClientDescriptor)env;
            return "client_" + appEnv.getName() + ID_SEPARATOR + appEnv.getMainClassName();
        }
        if (env instanceof ManagedBeanDescriptor) {
            SimpleJndiName jndiName = ((ManagedBeanDescriptor)env).getGlobalJndiName();
            return jndiName == null ? null : jndiName.toString();
        }
        if (env instanceof EjbBundleDescriptor) {
            EjbBundleDescriptor ejbBundle = (EjbBundleDescriptor)env;
            return "__ejbBundle___" + ejbBundle.getApplication().getName() + ID_SEPARATOR + ejbBundle.getModuleName();
        }
        return null;
    }
}

