/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.util;

import com.sun.enterprise.deployment.ResourceDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.glassfish.api.naming.SimpleJndiName;

class CommonResourceValidator {
    private final ResourceDescriptor descriptor;
    private final SimpleJndiName jndiName;
    private final List<DuplicitDescriptor> descriptors;

    CommonResourceValidator(ResourceDescriptor descriptor, SimpleJndiName jndiName, String scope) {
        this.descriptor = descriptor;
        this.jndiName = Objects.requireNonNull(jndiName, "jndiName");
        this.descriptors = new ArrayList<DuplicitDescriptor>();
        this.descriptors.add(new DuplicitDescriptor(descriptor, scope));
    }

    ResourceDescriptor getDescriptor() {
        return this.descriptor;
    }

    SimpleJndiName getJndiName() {
        return this.jndiName;
    }

    List<DuplicitDescriptor> getDescriptors() {
        return this.descriptors;
    }

    void addDuplicity(ResourceDescriptor duplicit, String scope) {
        this.descriptors.add(new DuplicitDescriptor(duplicit, scope));
    }

    static class DuplicitDescriptor {
        public final ResourceDescriptor descriptor;
        public final String scope;

        private DuplicitDescriptor(ResourceDescriptor descriptor, String scope) {
            this.descriptor = descriptor;
            this.scope = scope;
        }

        public String toString() {
            return this.scope;
        }
    }
}

