/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.deployment.deploy.shared.MultiReadableArchive;
import com.sun.enterprise.module.bootstrap.BootException;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.appclient.client.acc.ACCClassLoader;
import org.glassfish.appclient.client.acc.ACCModulesManager;
import org.glassfish.appclient.client.acc.HTTPInputArchive;
import org.glassfish.appclient.client.acc.JWSFacadeLaunchable;
import org.glassfish.appclient.client.acc.Launchable;
import org.glassfish.appclient.client.acc.UserError;
import org.glassfish.appclient.common.ACCAppClientArchivist;
import org.glassfish.deployment.common.ModuleDescriptor;
import org.glassfish.hk2.api.ServiceLocator;
import org.xml.sax.SAXException;

public class FacadeLaunchable
implements Launchable {
    public static final Attributes.Name GLASSFISH_APPCLIENT_GROUP = new Attributes.Name("GlassFish-AppClient-Group");
    public static final Attributes.Name GLASSFISH_APPCLIENT_MAIN_CLASS = new Attributes.Name("Glassfish-AppClient-Main-Class");
    public static final Attributes.Name GLASSFISH_APPCLIENT = new Attributes.Name("GlassFish-AppClient");
    public static final Attributes.Name GLASSFISH_APP_NAME = new Attributes.Name("GlassFish-App-Name");
    private static final ArchiveFactory archiveFactory = ACCModulesManager.getService(ArchiveFactory.class);
    private static final Logger logger = LogDomains.getLogger(FacadeLaunchable.class, (String)"jakarta.enterprise.system.container.appclient");
    private static final boolean isJWSLaunch = Boolean.getBoolean("appclient.is.jws");
    private final String mainClassNameToLaunch;
    private final URI[] classPathURIs;
    private final ReadableArchive facadeClientRA;
    private final MultiReadableArchive combinedRA;
    private static AppClientArchivist facadeArchivist;
    private ApplicationClientDescriptor acDesc;
    private ClassLoader classLoader;
    private final ServiceLocator habitat;
    private final String anchorDir;

    FacadeLaunchable(ServiceLocator habitat, Attributes mainAttrs, ReadableArchive facadeRA, String anchorDir) throws IOException {
        this(habitat, facadeRA, mainAttrs, FacadeLaunchable.openOriginalArchive(facadeRA, mainAttrs.getValue(GLASSFISH_APPCLIENT)), mainAttrs.getValue(GLASSFISH_APPCLIENT_MAIN_CLASS), anchorDir);
    }

    private static ReadableArchive openOriginalArchive(ReadableArchive facadeArchive, String relativeURIToOriginalJar) throws IOException {
        URI uriToOriginal = facadeArchive.getURI().resolve(relativeURIToOriginalJar);
        return archiveFactory.openArchive(uriToOriginal);
    }

    FacadeLaunchable(ServiceLocator habitat, ReadableArchive facadeClientRA, Attributes mainAttrs, ReadableArchive clientRA, String mainClassNameToLaunch, String anchorDir) throws IOException {
        this.facadeClientRA = facadeClientRA;
        this.combinedRA = FacadeLaunchable.openCombinedReadableArchive(habitat, facadeClientRA, clientRA);
        this.mainClassNameToLaunch = mainClassNameToLaunch;
        this.classPathURIs = this.toURIs(mainAttrs.getValue(Attributes.Name.CLASS_PATH));
        this.habitat = habitat;
        this.anchorDir = anchorDir;
    }

    @Override
    public URI getURI() {
        return this.facadeClientRA.getURI();
    }

    @Override
    public String getAnchorDir() {
        return this.anchorDir;
    }

    private static MultiReadableArchive openCombinedReadableArchive(ServiceLocator habitat, ReadableArchive facadeRA, ReadableArchive clientRA) throws IOException {
        MultiReadableArchive combinedRA = (MultiReadableArchive)habitat.getService(MultiReadableArchive.class, new Annotation[0]);
        combinedRA.open(new URI[]{facadeRA.getURI(), clientRA.getURI()});
        return combinedRA;
    }

    protected URI[] toURIs(String uriList) {
        String[] uris = uriList.split(" ");
        URI[] result = new URI[uris.length];
        for (int i = 0; i < uris.length; ++i) {
            result[i] = URI.create(uris[i]);
        }
        return result;
    }

    protected AppClientArchivist getArchivist() {
        return FacadeLaunchable.getArchivist(this.habitat);
    }

    protected static synchronized AppClientArchivist getArchivist(ServiceLocator habitat) {
        if (facadeArchivist == null) {
            facadeArchivist = (AppClientArchivist)habitat.getService(ACCAppClientArchivist.class, new Annotation[0]);
        }
        return facadeArchivist;
    }

    @Override
    public void validateDescriptor() {
        this.getArchivist().validate(this.classLoader);
    }

    static FacadeLaunchable newFacade(ServiceLocator habitat, ReadableArchive facadeRA, String callerSuppliedMainClassName, String callerSuppliedAppName) throws IOException, BootException, URISyntaxException, XMLStreamException, SAXException, UserError {
        Manifest mf = facadeRA.getManifest();
        if (mf == null) {
            throw new UserError(MessageFormat.format(logger.getResourceBundle().getString("appclient.noMFInFacade"), facadeRA instanceof FileArchive ? 1 : 0, new File(facadeRA.getURI().getPath()).getAbsolutePath()));
        }
        Attributes mainAttrs = mf.getMainAttributes();
        if (mainAttrs.containsKey(GLASSFISH_APPCLIENT)) {
            if (facadeRA instanceof HTTPInputArchive) {
                return new JWSFacadeLaunchable(habitat, mainAttrs, facadeRA);
            }
            return new FacadeLaunchable(habitat, mainAttrs, facadeRA, FacadeLaunchable.dirContainingStandAloneFacade(facadeRA));
        }
        String facadeGroupURIs = mainAttrs.getValue(GLASSFISH_APPCLIENT_GROUP);
        if (facadeGroupURIs == null) {
            return null;
        }
        return FacadeLaunchable.selectFacadeFromGroup(habitat, facadeRA.getURI(), archiveFactory, facadeGroupURIs, callerSuppliedMainClassName, callerSuppliedAppName, FacadeLaunchable.dirContainingClientFacadeInGroup(facadeRA));
    }

    private static String dirContainingStandAloneFacade(ReadableArchive facadeRA) throws URISyntaxException {
        URI fileURI = new URI("file", facadeRA.getURI().getRawSchemeSpecificPart(), null);
        return new File(fileURI).getParent();
    }

    private static String dirContainingClientFacadeInGroup(ReadableArchive groupFacadeRA) throws URISyntaxException {
        String ssp = groupFacadeRA.getURI().getRawSchemeSpecificPart();
        URI fileURI = new URI("file", ssp.substring(0, ssp.length() - ".jar".length()) + "/", null);
        return new File(fileURI).getAbsolutePath();
    }

    @Override
    public Class getMainClass() throws ClassNotFoundException {
        return Class.forName(this.mainClassNameToLaunch, true, Thread.currentThread().getContextClassLoader());
    }

    @Override
    public ApplicationClientDescriptor getDescriptor(URLClassLoader loader) throws IOException, SAXException {
        if (this.acDesc == null) {
            AppClientArchivist archivist = this.getArchivist();
            archivist.setAnnotationProcessingRequested(!isJWSLaunch);
            ACCClassLoader tempLoader = new ACCClassLoader(loader.getURLs(), loader.getParent());
            archivist.setClassLoader((ClassLoader)((Object)tempLoader));
            this.acDesc = archivist.open((ReadableArchive)this.combinedRA, this.mainClassNameToLaunch);
            archivist.setDescriptor((BundleDescriptor)this.acDesc);
            Application.createVirtualApplication(null, (ModuleDescriptor)this.acDesc.getModuleDescriptor());
            Manifest facadeMF = this.combinedRA.getManifest();
            Attributes mainAttrs = facadeMF.getMainAttributes();
            String appName = mainAttrs.getValue(GLASSFISH_APP_NAME);
            this.acDesc.getApplication().setAppName(appName);
            this.classLoader = loader;
        }
        return this.acDesc;
    }

    public URI[] getClassPathURIs() {
        return this.classPathURIs;
    }

    private static FacadeLaunchable selectFacadeFromGroup(ServiceLocator habitat, URI groupFacadeURI, ArchiveFactory af, String groupURIs, String callerSpecifiedMainClassName, String callerSpecifiedAppClientName, String anchorDir) throws IOException, SAXException, UserError {
        String msg;
        String[] archiveURIs = groupURIs.split(" ");
        if (archiveURIs.length == 0) {
            String msg2 = MessageFormat.format(logger.getResourceBundle().getString("appclient.noClientsInGroup"), groupFacadeURI);
            throw new UserError(msg2);
        }
        ArrayList<String> knownClientNames = new ArrayList<String>();
        ArrayList<String> knownMainClasses = new ArrayList<String>();
        for (String uriText : archiveURIs) {
            URI clientFacadeURI = groupFacadeURI.resolve(uriText);
            ReadableArchive clientFacadeRA = af.openArchive(clientFacadeURI);
            Manifest facadeMF = clientFacadeRA.getManifest();
            if (facadeMF == null) {
                throw new UserError(MessageFormat.format(logger.getResourceBundle().getString("appclient.noMFInFacade"), clientFacadeRA instanceof FileArchive ? 1 : 0, new File(clientFacadeRA.getURI().getPath()).getAbsolutePath()));
            }
            Attributes facadeMainAttrs = facadeMF.getMainAttributes();
            if (facadeMainAttrs == null) {
                throw new UserError(MessageFormat.format(logger.getResourceBundle().getString("appclient.MFMissingEntry"), new File(clientFacadeRA.getURI().getPath()).getAbsolutePath(), GLASSFISH_APPCLIENT));
            }
            String gfAppClient = facadeMainAttrs.getValue(GLASSFISH_APPCLIENT);
            if (gfAppClient == null || gfAppClient.length() == 0) {
                throw new UserError(MessageFormat.format(logger.getResourceBundle().getString("appclient.MFMissingEntry"), new File(clientFacadeRA.getURI().getPath()).getAbsolutePath(), GLASSFISH_APPCLIENT));
            }
            URI clientURI = clientFacadeURI.resolve(gfAppClient);
            ReadableArchive clientRA = af.openArchive(clientURI);
            if (!clientRA.exists()) {
                throw new UserError(MessageFormat.format(logger.getResourceBundle().getString("appclient.missingClient"), new File(clientRA.getURI().getSchemeSpecificPart()).getAbsolutePath()));
            }
            AppClientArchivist facadeClientArchivist = FacadeLaunchable.getArchivist(habitat);
            MultiReadableArchive combinedRA = FacadeLaunchable.openCombinedReadableArchive(habitat, clientFacadeRA, clientRA);
            ApplicationClientDescriptor facadeClientDescriptor = (ApplicationClientDescriptor)facadeClientArchivist.open((ReadableArchive)combinedRA);
            String moduleID = Launchable.LaunchableUtil.moduleID(groupFacadeURI, clientURI, facadeClientDescriptor);
            Manifest clientMF = clientRA.getManifest();
            if (clientMF == null) {
                throw new UserError(MessageFormat.format(logger.getResourceBundle().getString("appclient.noMFInFacade"), clientRA instanceof FileArchive ? 1 : 0, new File(clientRA.getURI().getSchemeSpecificPart()).getAbsolutePath()));
            }
            Attributes mainAttrs = clientMF.getMainAttributes();
            if (mainAttrs == null) {
                throw new UserError(MessageFormat.format(logger.getResourceBundle().getString("appclient.MFMissingEntry"), new File(clientFacadeRA.getURI().getPath()).getAbsolutePath(), Attributes.Name.MAIN_CLASS.toString()));
            }
            String clientMainClassName = mainAttrs.getValue(Attributes.Name.MAIN_CLASS);
            if (clientMainClassName == null || clientMainClassName.length() == 0) {
                throw new UserError(MessageFormat.format(logger.getResourceBundle().getString("appclient.MFMissingEntry"), new File(clientFacadeRA.getURI().getPath()).getAbsolutePath(), Attributes.Name.MAIN_CLASS.toString()));
            }
            knownMainClasses.add(clientMainClassName);
            knownClientNames.add(moduleID);
            FacadeLaunchable facade = null;
            if (Launchable.LaunchableUtil.matchesAnyClass(clientRA, callerSpecifiedMainClassName)) {
                facade = new FacadeLaunchable(habitat, clientFacadeRA, facadeMainAttrs, clientRA, callerSpecifiedMainClassName, anchorDir);
                if (!clientMainClassName.equals(callerSpecifiedMainClassName)) {
                    logger.log(Level.INFO, MessageFormat.format(logger.getResourceBundle().getString("appclient.foundMainClassDiffFromManifest"), groupFacadeURI, moduleID, callerSpecifiedMainClassName, clientMainClassName));
                }
            } else if (Launchable.LaunchableUtil.matchesName(moduleID, groupFacadeURI, facadeClientDescriptor, callerSpecifiedAppClientName)) {
                facade = new FacadeLaunchable(habitat, clientFacadeRA, facadeMainAttrs, clientRA, clientMainClassName, anchorDir);
            } else if (archiveURIs.length == 1) {
                facade = new FacadeLaunchable(habitat, clientFacadeRA, facadeMainAttrs, clientRA, callerSpecifiedMainClassName != null ? callerSpecifiedMainClassName : facadeMainAttrs.getValue(GLASSFISH_APPCLIENT_MAIN_CLASS), anchorDir);
                if (callerSpecifiedMainClassName != null && !clientMainClassName.equals(callerSpecifiedMainClassName) || callerSpecifiedAppClientName != null && !Launchable.LaunchableUtil.matchesName(moduleID, groupFacadeURI, facadeClientDescriptor, callerSpecifiedAppClientName)) {
                    logger.log(Level.WARNING, MessageFormat.format(logger.getResourceBundle().getString("appclient.singleNestedClientNoMatch"), groupFacadeURI, ((Object)knownClientNames).toString(), ((Object)knownMainClasses).toString(), callerSpecifiedMainClassName, callerSpecifiedAppClientName));
                }
            }
            if (facade == null) continue;
            return facade;
        }
        if (callerSpecifiedAppClientName == null && callerSpecifiedMainClassName == null) {
            String format = logger.getResourceBundle().getString("appclient.multClientsNoChoice");
            msg = MessageFormat.format(format, ((Object)knownMainClasses).toString(), ((Object)knownClientNames).toString());
        } else {
            String format = logger.getResourceBundle().getString("appclient.noMatchingClientInGroup");
            msg = MessageFormat.format(format, groupFacadeURI, callerSpecifiedMainClassName, callerSpecifiedAppClientName, ((Object)knownMainClasses).toString(), ((Object)knownClientNames).toString());
        }
        throw new UserError(msg);
    }
}

