/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.ClassPrint;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstClass;
import com.sun.jdo.api.persistence.enhancer.classfile.Insn;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnError;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnReadEnv;
import java.io.PrintStream;

public class InsnMultiDimArrayNew
extends Insn {
    private ConstClass classOp;
    private int nDimsOp;

    public boolean isSimpleLoad() {
        return false;
    }

    @Override
    public int nStackArgs() {
        return this.nDimsOp;
    }

    @Override
    public int nStackResults() {
        return 1;
    }

    @Override
    public String argTypes() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.nDimsOp; ++i) {
            buf.append("I");
        }
        return buf.toString();
    }

    @Override
    public String resultTypes() {
        return "A";
    }

    @Override
    public boolean branches() {
        return false;
    }

    public ConstClass arrayClass() {
        return this.classOp;
    }

    public void setArrayClass(ConstClass classOp) {
        this.classOp = classOp;
    }

    public int nDims() {
        return this.nDimsOp;
    }

    public InsnMultiDimArrayNew(ConstClass classOp, int nDimsOp) {
        this(classOp, nDimsOp, -1);
    }

    InsnMultiDimArrayNew(ConstClass classOp, int nDimsOp, int offset) {
        super(197, offset);
        this.classOp = classOp;
        this.nDimsOp = nDimsOp;
        if (classOp == null || nDimsOp < 1) {
            throw new InsnError("attempt to create an opc_multianewarray with invalid operands");
        }
    }

    @Override
    void print(PrintStream out, int indent) {
        ClassPrint.spaces(out, indent);
        out.println(this.offset() + "  opc_multianewarray  pool(" + this.classOp.getIndex() + ")," + this.nDimsOp);
    }

    @Override
    int store(byte[] buf, int index) {
        buf[index++] = (byte)this.opcode();
        index = InsnMultiDimArrayNew.storeShort(buf, index, (short)this.classOp.getIndex());
        buf[index++] = (byte)this.nDimsOp;
        return index;
    }

    @Override
    int size() {
        return 4;
    }

    static InsnMultiDimArrayNew read(InsnReadEnv insnEnv, int myPC) {
        ConstClass classOp = (ConstClass)insnEnv.pool().constantAt(insnEnv.getUShort());
        int nDims = insnEnv.getUByte();
        return new InsnMultiDimArrayNew(classOp, nDims, myPC);
    }
}

