/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.stomp;

import com.sun.messaging.bridge.api.StompDestination;
import com.sun.messaging.bridge.api.StompFrameMessage;
import com.sun.messaging.bridge.api.StompOutputHandler;
import com.sun.messaging.bridge.api.StompProtocolException;
import com.sun.messaging.bridge.api.StompSubscriber;
import com.sun.messaging.bridge.service.stomp.StompConnectionImpl;
import com.sun.messaging.bridge.service.stomp.StompDestinationImpl;
import com.sun.messaging.bridge.service.stomp.StompSenderSession;
import com.sun.messaging.bridge.service.stomp.StompSubscriberSession;
import com.sun.messaging.bridge.service.stomp.TransactedSubscriber;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class StompTransactedSession
extends StompSenderSession
implements Runnable {
    private String _lastRolledbackTID = null;
    private StompOutputHandler _out = null;
    private Map<String, TransactedSubscriber> _subscribers = Collections.synchronizedMap(new HashMap());
    private List<SubscribedMessage> _msgqueue = Collections.synchronizedList(new ArrayList());
    private List<SubscribedMessage> _unackqueue = Collections.synchronizedList(new ArrayList());
    private List<TransactedAck> _ackedqueue = Collections.synchronizedList(new ArrayList());
    private Object _lock = new Object();
    private String _tid = null;
    private boolean _locked = false;
    private boolean _stopped = false;
    private Thread _subthread = null;

    public StompTransactedSession(StompConnectionImpl sc) throws Exception {
        super(sc);
        this.logger.log(Level.INFO, this.sbr.getString("BSS1020", this.toString()));
    }

    @Override
    protected Session createSession() throws JMSException {
        return this.connection.createSession(true, 0);
    }

    public String toString() {
        return "[" + String.valueOf(this.connection) + ", " + String.valueOf(this.session) + ", " + this._tid + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StompSubscriber createSubscriber(String subid, StompDestination d, String selector, String duraname, boolean nolocal, StompOutputHandler out) throws Exception {
        Object queue;
        this._out = out;
        Destination dest = ((StompDestinationImpl)d).getJMSDestination();
        this.checkSession();
        MessageConsumer sub = null;
        if (this._subscribers.get(subid) != null) {
            throw new JMSException(this.sbr.getKString("BSS4029", subid, this.toString()));
        }
        String destname = null;
        if (dest instanceof Queue) {
            queue = (Queue)dest;
            sub = this.session.createConsumer(dest, selector);
            destname = queue.getQueueName();
        } else if (duraname != null) {
            sub = this.session.createDurableSubscriber((Topic)dest, duraname, selector, nolocal);
            destname = ((Topic)dest).getTopicName();
        } else {
            sub = this.session.createConsumer(dest, selector, nolocal);
            destname = ((Topic)dest).getTopicName();
        }
        queue = this._lock;
        synchronized (queue) {
            if (this._subthread == null) {
                this._subthread = new Thread(this);
                this._subthread.setName("TransactedSession[" + String.valueOf(this) + "]");
                this._subthread.setDaemon(true);
                this._subthread.start();
            }
        }
        TransactedSubscriber txsub = new TransactedSubscriber(subid, sub, dest instanceof Queue ? null : duraname, this);
        this._subscribers.put(subid, txsub);
        Object[] param = new String[]{subid, destname, this.toString()};
        this.logger.log(Level.INFO, this.sbr.getString("BSS1021", param));
        return txsub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String closeSubscriber(String subid, String duraname) throws Exception {
        if (duraname == null) {
            TransactedSubscriber sub = this._subscribers.get(subid);
            if (sub == null) {
                return null;
            }
            this.preCloseSubscriber(subid);
            sub.close();
            this._subscribers.remove(subid);
            return subid;
        }
        TransactedSubscriber sub = null;
        String dn = null;
        Map<String, TransactedSubscriber> map = this._subscribers;
        synchronized (map) {
            for (String id : this._subscribers.keySet()) {
                sub = this._subscribers.get(id);
                dn = sub.getDuraName();
                if (dn == null || !dn.equals(duraname)) continue;
                this.preCloseSubscriber(id);
                sub.close();
                this._subscribers.remove(id);
                this.session.unsubscribe(duraname);
                return id;
            }
        }
        this.session.unsubscribe(duraname);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preCloseSubscriber(String subid) throws Exception {
        this.connection.stop();
        try {
            TransactedAck ta = null;
            List<TransactedAck> list = this._ackedqueue;
            synchronized (list) {
                Iterator<TransactedAck> itr = this._ackedqueue.iterator();
                while (itr.hasNext()) {
                    ta = itr.next();
                    if (!ta.subid.equals(subid)) continue;
                    try {
                        this.acknowledge(ta.msg);
                    }
                    catch (Exception e) {
                        Object[] eparam = new String[]{ta.msg.getJMSMessageID(), this._tid, subid, e.getMessage()};
                        this.logger.log(Level.WARNING, this.sbr.getKString("BSS2010", eparam), e);
                    }
                    itr.remove();
                }
            }
        }
        finally {
            this.connection.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStompTransactionId() {
        Object object = this._lock;
        synchronized (object) {
            return this._tid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStompTransactionId(String tid) throws Exception {
        StompTransactedSession stompTransactedSession = this;
        synchronized (stompTransactedSession) {
            if (!this._ackedqueue.isEmpty()) {
                this.logger.log(Level.WARNING, "acked-queue is not empty on setting transaction ID " + tid + (String)(this._lastRolledbackTID == null ? "" : ", last rolledback transaction ID was " + this._lastRolledbackTID));
            }
            this._ackedqueue.clear();
            if (tid != null) {
                this._lastRolledbackTID = null;
            }
            Object object = this._lock;
            synchronized (object) {
                this._tid = tid;
                this._lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit() throws Exception {
        this.logger.log(Level.FINE, "Committing transaction " + this._tid + " on JMS session " + String.valueOf(this.session));
        boolean stopped = false;
        try {
            if (!this._ackedqueue.isEmpty()) {
                stopped = true;
                this.connection.stop();
                List<TransactedAck> list = this._ackedqueue;
                synchronized (list) {
                    TransactedAck ta = null;
                    Iterator<TransactedAck> itr = this._ackedqueue.iterator();
                    while (itr.hasNext()) {
                        ta = itr.next();
                        if (!ta.tid.equals(this._tid)) {
                            throw new JMSException("Transaction ack [" + String.valueOf(ta) + "] tid not match current transaction id " + this._tid);
                        }
                        this.logger.log(Level.FINE, "Ack message " + ta.msgid + " for committing transaction " + this._tid);
                        this.acknowledge(ta.msg);
                        itr.remove();
                    }
                }
            }
            this.session.commit();
        }
        catch (Exception e) {
            String emsg = this.sbr.getKString("BSS3007", this._tid, e.getMessage());
            this.logger.log(Level.SEVERE, emsg);
            try {
                this.rollback();
            }
            finally {
                JMSException je = new JMSException(emsg);
                je.initCause((Throwable)e);
                throw je;
            }
        }
        finally {
            this.setStompTransactionId(null);
            this._ackedqueue.clear();
            if (stopped) {
                this.connection.start();
            }
        }
    }

    public synchronized String getLastRolledbackStompTransactionId() {
        return this._lastRolledbackTID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollback() throws Exception {
        try {
            SubscribedMessage sm;
            Object[] eparam;
            Iterator<Object> itr;
            this.connection.stop();
            this.stop(true);
            List<Object> list = this._ackedqueue;
            synchronized (list) {
                TransactedAck ta = null;
                itr = this._ackedqueue.iterator();
                while (itr.hasNext()) {
                    ta = itr.next();
                    if (!ta.tid.equals(this._tid)) {
                        throw new JMSException("Transaction ack [" + String.valueOf(ta) + "] tid not match current transaction id " + this._tid);
                    }
                    if (this._subscribers.get(ta.subid) != null) {
                        try {
                            this.acknowledge(ta.msg);
                        }
                        catch (Exception e) {
                            eparam = new String[]{ta.msg.getJMSMessageID(), this.getStompTransactionId(), e.getMessage()};
                            this.logger.log(Level.WARNING, this.sbr.getKString("BSS2011", eparam), e);
                        }
                    }
                    itr.remove();
                }
            }
            list = this._unackqueue;
            synchronized (list) {
                sm = null;
                itr = this._unackqueue.iterator();
                while (itr.hasNext()) {
                    sm = (SubscribedMessage)itr.next();
                    if (this._subscribers.get(sm.subid) != null) {
                        try {
                            this.acknowledge(sm.msg);
                        }
                        catch (Exception e) {
                            eparam = new String[]{sm.msg.getJMSMessageID(), this.getStompTransactionId(), e.getMessage()};
                            this.logger.log(Level.WARNING, this.sbr.getKString("BSS2012", eparam), e);
                        }
                    }
                    itr.remove();
                }
            }
            list = this._msgqueue;
            synchronized (list) {
                sm = null;
                itr = this._msgqueue.iterator();
                while (itr.hasNext()) {
                    sm = (SubscribedMessage)itr.next();
                    if (this._subscribers.get(sm.subid) != null) {
                        try {
                            this.acknowledge(sm.msg);
                        }
                        catch (Exception e) {
                            eparam = new String[]{sm.msg.getJMSMessageID(), this.getStompTransactionId(), e.getMessage()};
                            this.logger.log(Level.WARNING, this.sbr.getKString("BSS2013", eparam), e);
                        }
                    }
                    itr.remove();
                }
            }
            this.session.rollback();
        }
        finally {
            this._lastRolledbackTID = this._tid;
            this.setStompTransactionId(null);
            this._ackedqueue.clear();
            this.stop(false);
            this.connection.start();
        }
    }

    public void ack(String subid, String msgid) throws Exception {
        this.ack(subid, msgid, false);
    }

    public synchronized void ack10(String subid, String msgid) throws Exception {
        this.ack(subid, msgid, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void ack(String subid, String msgid, boolean prefix) throws Exception {
        Object object;
        this.checkSession();
        if (this.getStompTransactionId() == null) {
            throw new StompProtocolException(this.sbr.getKString("BSS4030", msgid, subid));
        }
        TransactedSubscriber sub = this._subscribers.get(subid);
        if (sub == null) {
            if (prefix) {
                object = this._subscribers;
                synchronized (object) {
                    for (String id : this._subscribers.keySet()) {
                        if (!id.startsWith(subid)) continue;
                        subid = id;
                        sub = this._subscribers.get(id);
                        break;
                    }
                }
            }
            if (sub == null) {
                Object[] eparam;
                if (!prefix) {
                    eparam = new String[]{subid, msgid, this._tid};
                    throw new JMSException(this.sbr.getKString("BSS4031", eparam));
                }
                eparam = new String[]{msgid, this._tid, "subscription"};
                throw new JMSException(this.sbr.getKString("BSS4032", eparam));
            }
        }
        object = this._unackqueue;
        synchronized (object) {
            SubscribedMessage sm = new SubscribedMessage(subid, msgid);
            int index = this._unackqueue.indexOf(sm);
            if (index == -1) {
                if (!this._ackedqueue.contains(new TransactedAck(this._tid, subid, sm.msgid))) {
                    Object[] eparam = new String[]{msgid, subid, this._tid};
                    throw new StompProtocolException(this.sbr.getKString("BSS4033", eparam));
                }
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "Message " + msgid + " for subcriber " + subid + " has already acked in transaction " + this._tid);
                }
                return;
            }
            ArrayList<SubscribedMessage> acks = new ArrayList<SubscribedMessage>();
            for (int i = 0; i <= index; ++i) {
                sm = this._unackqueue.get(i);
                if (!sm.subid.equals(subid)) continue;
                this._ackedqueue.add(new TransactedAck(this._tid, subid, sm.msg));
                acks.add(sm);
            }
            Iterator itr = acks.iterator();
            while (itr.hasNext()) {
                this._unackqueue.remove(itr.next());
            }
        }
    }

    private void acknowledge(Message msg) throws Exception {
        MessageImpl m = (MessageImpl)msg;
        SessionImpl ss = (SessionImpl)this.session;
        ss._appTransactedAck(m);
    }

    protected SubscribedMessage dequeue() {
        SubscribedMessage sm = this._msgqueue.remove(0);
        return sm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enqueue(String subid, Message msg) throws Exception {
        this._msgqueue.add(new SubscribedMessage(subid, msg));
        Object object = this._lock;
        synchronized (object) {
            this._lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop(boolean b) throws Exception {
        Object object = this._lock;
        synchronized (object) {
            this._locked = b;
            this._lock.notifyAll();
            if (b) {
                try {
                    while (this._subthread != null && !this.closed && !this._stopped) {
                        this.logger.log(Level.INFO, this.sbr.getString("BSS1022", "[" + String.valueOf(Thread.currentThread()) + "]", this._subthread.toString()));
                        this._lock.wait(60000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.closed) {
                    throw new JMSException(this.sbr.getKString("BSS4034", this.toString()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws Exception {
        String id = null;
        TransactedSubscriber sub = null;
        Iterator<String> itr = this._subscribers.keySet().iterator();
        while (itr.hasNext()) {
            id = itr.next();
            sub = this._subscribers.get(id);
            this.preCloseSubscriber(id);
            sub.close();
            itr.remove();
        }
        try {
            this.rollback();
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, this.sbr.getKString("BSS2014", this.toString(), e.getMessage()), e);
        }
        Object object = this._lock;
        synchronized (object) {
            this.closed = true;
            this._lock.notifyAll();
        }
        this.session.close();
        this._msgqueue.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        while (true) {
            object = this._lock;
            synchronized (object) {
                while (this._locked || this._msgqueue.isEmpty() || this.getStompTransactionId() == null) {
                    if (this.closed) {
                        this.logger.log(Level.INFO, this.sbr.getString("BSS1023", this.toString()));
                        return;
                    }
                    this._stopped = true;
                    this._lock.notifyAll();
                    try {
                        this._lock.wait();
                    }
                    catch (Exception exception) {}
                }
                this._stopped = false;
                SubscribedMessage sm = null;
                try {
                    sm = this.dequeue();
                    if (sm == null) {
                        continue;
                    }
                    if (this._subscribers.get(sm.subid) == null) {
                        this.logger.log(Level.FINE, "Skip delivering message " + sm.msg.getJMSMessageID() + " for transaction " + this._tid + " for its subscriber " + sm.subid + " has been closed");
                        continue;
                    }
                    this.logger.log(Level.FINE, "Delivering message " + sm.msg.getJMSMessageID() + " to STOMP client for subscriber " + sm.subid);
                    this._unackqueue.add(sm);
                    this._out.sendToClient(StompSubscriberSession.toStompFrameMessage(sm.msg, sm.subid, this.session, this.stompconn.getProtocolHandler()));
                }
                catch (Throwable t) {
                    block23: {
                        Object[] eparam = new String[]{sm == null ? "null" : sm.msgid, sm == null ? "null" : sm.subid, t.getMessage()};
                        if (t instanceof ClosedChannelException) {
                            this.logger.log(Level.WARNING, this.sbr.getKString("BSS2015", eparam));
                            break;
                        }
                        this.logger.log(Level.WARNING, this.sbr.getKString("BSS2015", eparam), t);
                        StompFrameMessage err = null;
                        try {
                            err = this.stompconn.getProtocolHandler().toStompErrorMessage("getTransactionID().run", t, true);
                        }
                        catch (Throwable tt) {
                            this.logger.log(Level.WARNING, this.sbr.getKString("BSS3004", t.getMessage()), tt);
                            break;
                        }
                        try {
                            this._out.sendToClient(err);
                        }
                        catch (Throwable ee) {
                            if (ee instanceof ClosedChannelException) {
                                this.logger.log(Level.WARNING, this.sbr.getKString("BSS3001", t.getMessage(), ee.getMessage()));
                                break block23;
                            }
                            this.logger.log(Level.WARNING, this.sbr.getKString("BSS3001", t.getMessage(), ee.getMessage()), ee);
                        }
                    }
                    break;
                }
            }
        }
        object = this._lock;
        synchronized (object) {
            this._stopped = true;
            this._lock.notifyAll();
        }
        try {
            this.close();
        }
        catch (Exception e) {
            this.logger.log(Level.FINE, "Close transacted session " + String.valueOf(this) + " failed: " + e.getMessage(), e);
        }
        this.logger.log(Level.INFO, this.sbr.getString("BSS1023", this.toString()));
    }

    static class TransactedAck {
        String tid = null;
        String subid = null;
        String msgid = null;
        Message msg = null;

        TransactedAck(String tid, String subid, String msgid) {
            this.tid = tid;
            this.subid = subid;
            this.msgid = msgid;
        }

        TransactedAck(String tid, String subid, Message msg) throws JMSException {
            this.tid = tid;
            this.subid = subid;
            this.msgid = msg.getJMSMessageID();
            this.msg = msg;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof TransactedAck)) {
                return false;
            }
            TransactedAck that = (TransactedAck)obj;
            return that.subid.equals(this.subid) && that.msgid.equals(this.msgid) && that.tid.equals(this.tid);
        }

        public int hashCode() {
            return this.tid.hashCode() + this.subid.hashCode() + this.msgid.hashCode();
        }

        public String toString() {
            return "tid=" + this.tid + ", subid=" + this.subid + ", msgid=" + this.msgid;
        }
    }

    static class SubscribedMessage {
        String subid = null;
        String msgid = null;
        Message msg = null;

        SubscribedMessage(String subid, String msgid) {
            this.subid = subid;
            this.msgid = msgid;
        }

        SubscribedMessage(String subid, Message msg) throws Exception {
            this.subid = subid;
            this.msg = msg;
            this.msgid = msg.getJMSMessageID();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof SubscribedMessage)) {
                return false;
            }
            SubscribedMessage that = (SubscribedMessage)obj;
            return that.subid.equals(this.subid) && that.msgid.equals(this.msgid);
        }

        public int hashCode() {
            return this.subid.hashCode() + this.msgid.hashCode();
        }
    }
}

