/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.web.WebApplication;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModuleConfig;
import jakarta.inject.Inject;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.container.Container;
import org.glassfish.api.container.RequestDispatcher;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.deployment.common.ApplicationConfigInfo;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.internal.deployment.GenericHandler;
import org.glassfish.javaee.core.deployment.JavaEEDeployer;
import org.glassfish.loader.util.ASClassLoaderUtil;
import org.glassfish.web.LogFacade;
import org.glassfish.web.deployment.descriptor.WebBundleDescriptorImpl;
import org.glassfish.web.jsp.JSPCompiler;
import org.jvnet.hk2.annotations.Service;

@Service
public class WebDeployer
extends JavaEEDeployer<WebContainer, WebApplication> {
    private static final Logger logger = LogFacade.getLogger();
    private static final ResourceBundle rb = logger.getResourceBundle();
    @Inject
    ServerContext sc;
    @Inject
    Domain domain;
    @Inject
    RequestDispatcher dispatcher;

    public MetaData getMetaData() {
        return new MetaData(false, new Class[]{WebBundleDescriptorImpl.class}, new Class[]{Application.class});
    }

    public <V> V loadMetaData(Class<V> type, DeploymentContext dc) {
        WebBundleDescriptorImpl wbd = (WebBundleDescriptorImpl)((Object)dc.getModuleMetaData(WebBundleDescriptorImpl.class));
        if (wbd.isStandalone()) {
            DeployCommandParameters params = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
            Object contextRoot = params.contextroot;
            if (contextRoot == null && "".equals(contextRoot = wbd.getContextRoot())) {
                contextRoot = null;
            }
            if (contextRoot == null) {
                contextRoot = params.previousContextRoot;
            }
            if (contextRoot == null) {
                contextRoot = ((GenericHandler)dc.getArchiveHandler()).getDefaultApplicationNameFromArchiveName(dc.getOriginalSource());
            }
            if (!((String)contextRoot).startsWith("/")) {
                contextRoot = "/" + (String)contextRoot;
            }
            wbd.setContextRoot((String)contextRoot);
            wbd.setName(params.name());
            dc.getAppProps().setProperty("context-root", (String)contextRoot);
        }
        return null;
    }

    private WebModuleConfig loadWebModuleConfig(DeploymentContext dc) {
        WebModuleConfig wmInfo = new WebModuleConfig();
        try {
            DeployCommandParameters params = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
            wmInfo.setDescriptor((WebBundleDescriptorImpl)((Object)dc.getModuleMetaData(WebBundleDescriptorImpl.class)));
            wmInfo.setVirtualServers(params.virtualservers);
            wmInfo.setLocation(dc.getSourceDir());
            wmInfo.setObjectType(dc.getAppProps().getProperty("object-type"));
        }
        catch (Exception ex) {
            String msg = rb.getString("AS-WEB-GLUE-00220");
            msg = MessageFormat.format(msg, wmInfo.getName());
            logger.log(Level.WARNING, msg, ex);
        }
        return wmInfo;
    }

    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
        DeployCommandParameters params = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
        if (params.precompilejsp.booleanValue()) {
            this.runJSPC(dc);
        }
    }

    public WebApplication load(WebContainer container, DeploymentContext dc) {
        super.load((Container)container, dc);
        WebBundleDescriptorImpl wbd = (WebBundleDescriptorImpl)((Object)dc.getModuleMetaData(WebBundleDescriptorImpl.class));
        if (wbd != null) {
            wbd.setClassLoader(dc.getClassLoader());
        }
        WebModuleConfig wmInfo = this.loadWebModuleConfig(dc);
        WebApplication webApp = new WebApplication(container, wmInfo, new ApplicationConfigInfo(dc.getAppProps()));
        return webApp;
    }

    public void unload(WebApplication webApplication, DeploymentContext dc) {
    }

    void runJSPC(DeploymentContext dc) throws DeploymentException {
        WebBundleDescriptorImpl wbd = (WebBundleDescriptorImpl)((Object)dc.getModuleMetaData(WebBundleDescriptorImpl.class));
        try {
            File outDir = dc.getScratchDir("jsp");
            File inDir = dc.getSourceDir();
            StringBuilder classpath = new StringBuilder(super.getCommonClassPath());
            classpath.append(File.pathSeparatorChar);
            DeployCommandParameters dcParams = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
            classpath.append(ASClassLoaderUtil.getModuleClassPath((ServiceLocator)this.sc.getDefaultServices(), (String)wbd.getApplication().getName(), (String)dcParams.libraries));
            classpath.append(File.pathSeparatorChar);
            classpath.append(super.getModuleClassPath(dc));
            JSPCompiler.compile(inDir, outDir, (WebBundleDescriptor)wbd, classpath.toString(), this.sc);
        }
        catch (DeploymentException de) {
            String msg = rb.getString("AS-WEB-GLUE-00221");
            msg = MessageFormat.format(msg, wbd.getApplication().getName());
            logger.log(Level.SEVERE, msg, de);
            throw de;
        }
    }
}

