/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.webservices.client;

import com.sun.enterprise.security.ee.authentication.jakarta.callback.ClientContainerCallbackHandler;
import com.sun.enterprise.security.webservices.LogUtils;
import com.sun.enterprise.security.webservices.SoapAuthenticationService;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.PipeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterPipeImpl;
import com.sun.xml.ws.security.secconv.SecureConversationInitiator;
import com.sun.xml.ws.security.secconv.WSSecureConversationException;
import com.sun.xml.wss.provider.wsit.PacketMapMessageInfo;
import com.sun.xml.wss.provider.wsit.PacketMessageInfo;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.config.ClientAuthContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.ws.WebServiceException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;

public class ClientSecurityPipe
extends AbstractFilterPipeImpl
implements SecureConversationInitiator {
    protected static final Logger _logger = LogUtils.getLogger();
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ClientSecurityPipe.class);
    private static final String WSIT_CLIENT_AUTH_CONTEXT = "com.sun.xml.wss.provider.wsit.WSITClientAuthContext";
    protected SoapAuthenticationService soapAuthenticationService;

    public ClientSecurityPipe(Map<String, Object> properties, Pipe next) {
        super(next);
        properties.put("SECURITY_PIPE", (Object)this);
        WSDLPort wsdlModel = (WSDLPort)properties.get("WSDL_MODEL");
        if (wsdlModel != null) {
            properties.put("WSDL_SERVICE", wsdlModel.getOwner().getName());
        }
        this.soapAuthenticationService = new SoapAuthenticationService("SOAP", properties, (CallbackHandler)new ClientContainerCallbackHandler());
    }

    protected ClientSecurityPipe(ClientSecurityPipe that, PipeCloner cloner) {
        super((AbstractFilterPipeImpl)that, cloner);
        this.soapAuthenticationService = that.soapAuthenticationService;
    }

    public final Pipe copy(PipeCloner cloner) {
        return new ClientSecurityPipe(this, cloner);
    }

    public SoapAuthenticationService getAuthenticationService() {
        return this.soapAuthenticationService;
    }

    public JAXBElement startSecureConversation(Packet packet) throws WSSecureConversationException {
        PacketMapMessageInfo info = new PacketMapMessageInfo(packet, new Packet());
        JAXBElement token = null;
        try {
            Subject clientSubject = ClientSecurityPipe.getClientSubject(packet);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("SECURITY_TOKEN", info);
            this.soapAuthenticationService.getSessionToken(map, (MessageInfo)info, clientSubject);
            Object securityToken = info.getMap().get("SECURITY_TOKEN");
            if (securityToken != null && securityToken instanceof JAXBElement) {
                token = (JAXBElement)securityToken;
            }
        }
        catch (Exception e) {
            if (e instanceof WSSecureConversationException) {
                throw (WSSecureConversationException)e;
            }
            throw new WSSecureConversationException("Secure Conversation failure: ", (Throwable)e);
        }
        return token;
    }

    public Packet process(Packet request) {
        Packet response;
        PacketMapMessageInfo info = new PacketMapMessageInfo(request, new Packet());
        info.getMap().put("jakarta.xml.ws.wsdl.service", this.soapAuthenticationService.getProperty("WSDL_SERVICE"));
        AuthStatus status = AuthStatus.SEND_SUCCESS;
        Subject clientSubject = ClientSecurityPipe.getClientSubject(request);
        ClientAuthContext clientAuthContext = null;
        try {
            clientAuthContext = this.soapAuthenticationService.getClientAuthContext((MessageInfo)info, clientSubject);
            if (clientAuthContext != null) {
                status = clientAuthContext.secureRequest((MessageInfo)info, clientSubject);
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "AS-WSSECURITY-00004", e);
            throw new WebServiceException(localStrings.getLocalString("enterprise.webservice.cantSecureRequst", "Cannot secure request for {0}", new Object[]{this.soapAuthenticationService.getModelName()}), (Throwable)e);
        }
        if (status == AuthStatus.FAILURE) {
            _logger.log(Level.FINE, "ws.status_secure_request", status);
            response = info.getResponsePacket();
        } else {
            response = this.processSecureRequest((PacketMessageInfo)info, clientAuthContext, clientSubject);
        }
        return response;
    }

    public void preDestroy() {
        try {
            Packet request = new Packet();
            PacketMapMessageInfo info = new PacketMapMessageInfo(request, new Packet());
            Subject clientSubject = ClientSecurityPipe.getClientSubject(request);
            ClientAuthContext clientAuthContext = this.soapAuthenticationService.getClientAuthContext((MessageInfo)info, clientSubject);
            if (clientAuthContext != null && WSIT_CLIENT_AUTH_CONTEXT.equals(clientAuthContext.getClass().getName())) {
                clientAuthContext.cleanSubject((MessageInfo)info, clientSubject);
            }
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "Exception when pre-destroying the client security pipe", ex);
        }
        this.soapAuthenticationService.disable();
    }

    private Packet processSecureRequest(PacketMessageInfo info, ClientAuthContext clientAuthContext, Subject clientSubject) throws WebServiceException {
        Packet response = this.next.process(info.getRequestPacket());
        Message responseMessage = response.getMessage();
        if (responseMessage != null && clientAuthContext != null) {
            AuthStatus status;
            info.setResponsePacket(response);
            try {
                status = clientAuthContext.validateResponse((MessageInfo)info, clientSubject, null);
            }
            catch (Exception e) {
                throw new WebServiceException(localStrings.getLocalString("enterprise.webservice.cantValidateResponse", "Cannot validate response for {0}", new Object[]{this.soapAuthenticationService.getModelName()}), (Throwable)e);
            }
            response = status == AuthStatus.SEND_CONTINUE ? this.processSecureRequest(info, clientAuthContext, clientSubject) : info.getResponsePacket();
        }
        return response;
    }

    private static Subject getClientSubject(Packet packet) {
        Subject subject = null;
        if (packet != null) {
            subject = (Subject)packet.invocationProperties.get("CLIENT_SUBJECT");
        }
        if (subject == null) {
            subject = SoapAuthenticationService.getClientSubject();
            if (packet != null) {
                packet.invocationProperties.put("CLIENT_SUBJECT", subject);
            }
        }
        return subject;
    }
}

