/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.java;

import org.glassfish.rmic.tools.java.ClassDefinition;
import org.glassfish.rmic.tools.java.ClassNotFound;
import org.glassfish.rmic.tools.java.CompilerError;
import org.glassfish.rmic.tools.java.Constants;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.java.Identifier;
import org.glassfish.rmic.tools.java.Type;

public final class ClassDeclaration
implements Constants {
    int status;
    Type type;
    ClassDefinition definition;
    private boolean found = false;

    public ClassDeclaration(Identifier name) {
        this.type = Type.tClass(name);
    }

    public int getStatus() {
        return this.status;
    }

    public Identifier getName() {
        return this.type.getClassName();
    }

    public Type getType() {
        return this.type;
    }

    public boolean isDefined() {
        switch (this.status) {
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public ClassDefinition getClassDefinition() {
        return this.definition;
    }

    public ClassDefinition getClassDefinition(Environment env) throws ClassNotFound {
        env.dtEvent("getClassDefinition: " + this.getName() + ", status " + this.getStatus());
        if (this.found) {
            return this.definition;
        }
        block5: while (true) {
            switch (this.status) {
                case 0: 
                case 1: 
                case 3: {
                    env.loadDefinition(this);
                    continue block5;
                }
                case 2: 
                case 4: {
                    if (!this.definition.isInsideLocal()) {
                        this.definition.basicCheck(env);
                    }
                    this.found = true;
                    return this.definition;
                }
                case 5: 
                case 6: {
                    this.found = true;
                    return this.definition;
                }
            }
            break;
        }
        throw new ClassNotFound(this.getName());
    }

    public ClassDefinition getClassDefinitionNoCheck(Environment env) throws ClassNotFound {
        env.dtEvent("getClassDefinition: " + this.getName() + ", status " + this.getStatus());
        block4: while (true) {
            switch (this.status) {
                case 0: 
                case 1: 
                case 3: {
                    env.loadDefinition(this);
                    continue block4;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    return this.definition;
                }
            }
            break;
        }
        throw new ClassNotFound(this.getName());
    }

    public void setDefinition(ClassDefinition definition, int status) {
        if (definition != null && !this.getName().equals(definition.getName())) {
            throw new CompilerError("setDefinition: name mismatch: " + this + ", " + definition);
        }
        this.definition = definition;
        this.status = status;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClassDeclaration) {
            return this.type.equals(((ClassDeclaration)obj).type);
        }
        return false;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public String toString() {
        String nested;
        String name = this.getName().toString();
        String type = "type ";
        String string = nested = this.getName().isInner() ? "nested " : "";
        if (this.getClassDefinition() != null) {
            type = this.getClassDefinition().isInterface() ? "interface " : "class ";
            if (!this.getClassDefinition().isTopLevel()) {
                nested = "inner ";
                if (this.getClassDefinition().isLocal()) {
                    nested = "local ";
                    if (!this.getClassDefinition().isAnonymous()) {
                        name = this.getClassDefinition().getLocalName() + " (" + name + ")";
                    }
                }
            }
        }
        return nested + type + name;
    }
}

