/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.interceptors;

import com.sun.ejb.containers.interceptors.CallbackInvocationContext;
import jakarta.ejb.EJBException;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class CallbackInterceptor {
    protected int index;
    protected Method method;

    CallbackInterceptor(int index, Method method) {
        this.index = index;
        this.method = method;
        try {
            if (!method.trySetAccessible()) {
                throw new InaccessibleObjectException("Unable to make accessible: " + String.valueOf(method));
            }
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    Object intercept(CallbackInvocationContext invContext) throws Throwable {
        try {
            return this.method.invoke(invContext.getInterceptorInstances()[this.index], invContext);
        }
        catch (InvocationTargetException invEx) {
            throw invEx.getCause();
        }
    }

    boolean isBeanCallback() {
        return false;
    }

    public String toString() {
        return "callback[" + this.index + "]: " + String.valueOf(this.method);
    }
}

