/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.admin.cluster.Strings;
import jakarta.inject.Inject;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service(name="update-node-config")
@I18n(value="update.node.config")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Node.class, opType=RestEndpoint.OpType.POST, path="update-node-config", description="Update Node Config", params={@RestParam(name="id", value="$parent")})})
public class UpdateNodeConfigCommand
implements AdminCommand {
    @Inject
    private CommandRunner cr;
    @Inject
    ServiceLocator habitat;
    @Inject
    private Nodes nodes;
    @Param(name="name", primary=true)
    private String name;
    @Param(name="nodehost", optional=true)
    private String nodehost;
    @Param(name="installdir", optional=true)
    private String installdir;
    @Param(name="nodedir", optional=true)
    private String nodedir;
    private static final String NL = System.getProperty("line.separator");
    private Logger logger = null;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        StringBuilder msg = new StringBuilder();
        Node node = null;
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        this.logger = context.getLogger();
        node = this.nodes.getNode(this.name);
        if (node == null) {
            String m = Strings.get("noSuchNode", this.name);
            this.logger.warning(m);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(m);
            return;
        }
        if (node.isDefaultLocalNode()) {
            String m = Strings.get("update.node.config.defaultnode", this.name);
            this.logger.warning(m);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(m);
            return;
        }
        if (!StringUtils.ok((String)this.nodehost) && !StringUtils.ok((String)node.getNodeHost())) {
            String m = Strings.get("update.node.config.missing.attribute", node.getName(), "nodehost");
            this.logger.warning(m);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(m);
            return;
        }
        ParameterMap map = new ParameterMap();
        map.add((Object)"DEFAULT", (Object)this.name);
        if (this.installdir != null) {
            map.add((Object)"installdir", (Object)this.installdir);
        }
        if (this.nodehost != null) {
            map.add((Object)"nodehost", (Object)this.nodehost);
        }
        if (this.nodedir != null) {
            map.add((Object)"nodedir", (Object)this.nodedir);
        }
        map.add((Object)"type", (Object)"CONFIG");
        if (map.size() > 1) {
            CommandRunner.CommandInvocation ci = this.cr.getCommandInvocation("_update-node", report, context.getSubject());
            ci.parameters(map);
            ci.execute();
            if (StringUtils.ok((String)report.getMessage())) {
                if (msg.length() > 0) {
                    msg.append(NL);
                }
                msg.append(report.getMessage());
            }
            report.setMessage(msg.toString());
        }
    }
}

