/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.node;

import com.sun.enterprise.deployment.WebServiceHandlerChain;
import com.sun.enterprise.deployment.node.DisplayableComponentNode;
import com.sun.enterprise.deployment.node.XMLElement;
import java.util.List;
import java.util.Map;
import org.glassfish.webservices.node.WebServiceHandlerNode;
import org.w3c.dom.Node;

public class WebServiceHandlerChainNode
extends DisplayableComponentNode<WebServiceHandlerChain> {
    private static final XMLElement TAG = new XMLElement("handler-chain");

    public WebServiceHandlerChainNode() {
        this.registerElementHandler(new XMLElement("handler"), WebServiceHandlerNode.class, "addHandler");
    }

    @Override
    protected WebServiceHandlerChain createDescriptor() {
        return new WebServiceHandlerChain();
    }

    @Override
    protected XMLElement getXMLRootTag() {
        return TAG;
    }

    @Override
    protected Map<String, String> getDispatchTable() {
        Map<String, String> table = super.getDispatchTable();
        table.put("service-name-pattern", "setServiceNamePattern");
        table.put("port-name-pattern", "setPortNamePattern");
        table.put("protocol-bindings", "setProtocolBindings");
        return table;
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        super.setElementValue(element, value);
    }

    @Override
    public Node writeDescriptor(Node parent, String nodeName, WebServiceHandlerChain handler) {
        Node wshNode = super.writeDescriptor(parent, nodeName, handler);
        if (handler.getServiceNamePattern() != null) {
            WebServiceHandlerChainNode.appendTextChild(wshNode, "service-name-pattern", handler.getServiceNamePattern());
        }
        if (handler.getPortNamePattern() != null) {
            WebServiceHandlerChainNode.appendTextChild(wshNode, "port-name-pattern", handler.getPortNamePattern());
        }
        if (handler.getProtocolBindings() != null) {
            WebServiceHandlerChainNode.appendTextChild(wshNode, "protocol-bindings", handler.getProtocolBindings());
        }
        WebServiceHandlerNode handlerNode = new WebServiceHandlerNode();
        handlerNode.writeWebServiceHandlers(wshNode, handler.getHandlers());
        return wshNode;
    }

    public void writeWebServiceHandlerChains(Node parent, List<WebServiceHandlerChain> handlerChain) {
        if (!handlerChain.isEmpty()) {
            parent = super.writeDescriptor(parent, "handler-chains", null);
        }
        for (WebServiceHandlerChain next : handlerChain) {
            this.writeDescriptor(parent, "handler-chain", next);
        }
    }
}

