/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.persistent.timer;

import com.sun.ejb.EJBUtils;
import com.sun.ejb.containers.EJBTimerSchedule;
import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.TimerPrimaryKey;
import com.sun.logging.LogDomains;
import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.Lob;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.PostLoad;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

@Entity(name="Timer")
@NamedQueries(value={@NamedQuery(name="findTimerIdsByContainer", query="SELECT t.timerId FROM Timer t WHERE t.containerId = ?1"), @NamedQuery(name="findTimerIdsByContainerAndState", query="SELECT t.timerId FROM Timer t WHERE t.containerId = ?1 AND t.state=?2"), @NamedQuery(name="findTimerIdsByContainersAndState", query="SELECT t.timerId FROM Timer t WHERE t.state=?2 AND t.containerId IN ?1"), @NamedQuery(name="findTimerIdsByContainerAndOwner", query="SELECT t.timerId FROM Timer t WHERE t.containerId = ?1 AND t.ownerId=?2"), @NamedQuery(name="findTimerIdsByContainerAndOwnerAndState", query="SELECT t.timerId FROM Timer t WHERE t.containerId = ?1 AND t.ownerId=?2 AND t.state=?3"), @NamedQuery(name="findTimerIdsByOwner", query="SELECT t.timerId FROM Timer t WHERE t.ownerId = ?1"), @NamedQuery(name="findTimerIdsByOwnerAndState", query="SELECT t.timerId FROM Timer t WHERE t.ownerId = ?1 AND t.state=?2"), @NamedQuery(name="findTimersByContainer", query="SELECT t FROM Timer t WHERE t.containerId = ?1"), @NamedQuery(name="findTimersByContainerAndState", query="SELECT t FROM Timer t WHERE t.containerId = ?1 AND t.state=?2"), @NamedQuery(name="findTimersByContainerAndOwner", query="SELECT t FROM Timer t WHERE t.containerId = ?1 AND t.ownerId=?2"), @NamedQuery(name="findTimersByContainerAndOwnerAndState", query="SELECT t FROM Timer t WHERE t.containerId = ?1 AND t.ownerId=?2 AND t.state=?3"), @NamedQuery(name="findTimersByOwner", query="SELECT t FROM Timer t WHERE t.ownerId = ?1 ORDER BY t.timerId"), @NamedQuery(name="findTimersByOwnerAndState", query="SELECT t FROM Timer t WHERE t.ownerId = ?1 AND t.state=?2"), @NamedQuery(name="countTimersByApplication", query="SELECT COUNT(t) FROM Timer t WHERE t.applicationId = ?1"), @NamedQuery(name="countTimersByOwner", query="SELECT COUNT(t) FROM Timer t WHERE t.ownerId = ?1"), @NamedQuery(name="countTimersByOwnerAndState", query="SELECT COUNT(t) FROM Timer t WHERE t.ownerId = ?1 AND t.state=?2"), @NamedQuery(name="countTimersByContainer", query="SELECT COUNT(t) FROM Timer t WHERE t.containerId = ?1"), @NamedQuery(name="countTimersByContainerAndState", query="SELECT COUNT(t) FROM Timer t WHERE t.containerId = ?1 AND t.state=?2"), @NamedQuery(name="countTimersByContainerAndOwner", query="SELECT COUNT(t) FROM Timer t WHERE t.containerId = ?1 AND t.ownerId=?2"), @NamedQuery(name="countTimersByContainerAndOwnerAndState", query="SELECT COUNT(t) FROM Timer t WHERE t.containerId = ?1 AND t.ownerId=?2 AND t.state=?3"), @NamedQuery(name="updateTimersFromOwnerToNewOwner", query="UPDATE Timer t SET t.ownerId = :toOwner WHERE t.ownerId = :fromOwner"), @NamedQuery(name="deleteTimersByContainer", query="DELETE FROM Timer t WHERE t.containerId = :containerId"), @NamedQuery(name="deleteTimersByApplication", query="DELETE FROM Timer t WHERE t.applicationId = :applicationId")})
@Table(name="EJB__TIMER__TBL")
@IdClass(value=TimerPrimaryKey.class)
public class TimerState {
    @Id
    @Column(name="TIMERID")
    private String timerId;
    @Column(name="CREATIONTIMERAW")
    private long creationTimeRaw;
    @Column(name="INITIALEXPIRATIONRAW")
    private long initialExpirationRaw;
    @Column(name="LASTEXPIRATIONRAW")
    private long lastExpirationRaw;
    @Column(name="INTERVALDURATION")
    private long intervalDuration;
    @Column(name="STATE")
    private int state;
    @Column(name="CONTAINERID")
    private long containerId;
    @Column(name="APPLICATIONID")
    private long applicationId;
    @Column(name="PKHASHCODE")
    private int pkHashCode;
    @Column(name="OWNERID")
    private String ownerId;
    @Column(name="SCHEDULE")
    private String schedule;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Column(name="BLOB")
    private Blob blob;
    @Transient
    private boolean blobLoaded_;
    @Transient
    private Object timedObjectPrimaryKey_;
    @Transient
    private Serializable info_;
    @Transient
    private Date creationTime_;
    @Transient
    private Date initialExpiration_;
    @Transient
    private Date lastExpiration_;
    @Transient
    private EJBTimerSchedule timerSchedule_;

    String getTimerId() {
        return this.timerId;
    }

    void setTimerId(String timerId) {
        this.timerId = timerId;
    }

    String getOwnerId() {
        return this.ownerId;
    }

    void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    long getCreationTimeRaw() {
        return this.creationTimeRaw;
    }

    void setCreationTimeRaw(long creationTime) {
        this.creationTimeRaw = creationTime;
    }

    long getInitialExpirationRaw() {
        return this.initialExpirationRaw;
    }

    void setInitialExpirationRaw(long initialExpiration) {
        this.initialExpirationRaw = initialExpiration;
    }

    long getLastExpirationRaw() {
        return this.lastExpirationRaw;
    }

    void setLastExpirationRaw(long lastExpiration) {
        this.lastExpirationRaw = lastExpiration;
    }

    long getIntervalDuration() {
        return this.intervalDuration;
    }

    void setIntervalDuration(long intervalDuration) {
        this.intervalDuration = intervalDuration;
    }

    int getState() {
        return this.state;
    }

    void setState(int state) {
        this.state = state;
    }

    long getContainerId() {
        return this.containerId;
    }

    void setContainerId(long containerId) {
        this.containerId = containerId;
    }

    long getApplicationId() {
        return this.applicationId;
    }

    void setApplicationId(long applicationId) {
        this.applicationId = applicationId;
    }

    String getSchedule() {
        return this.schedule;
    }

    void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    Blob getBlob() {
        return this.blob;
    }

    void setBlob(Blob blob) {
        this.blob = blob;
    }

    int getPkHashCode() {
        return this.pkHashCode;
    }

    void setPkHashCode(int pkHash) {
        this.pkHashCode = pkHash;
    }

    EJBTimerSchedule getTimerSchedule() {
        return this.timerSchedule_;
    }

    TimerState() {
    }

    TimerState(String timerId, long containerId, long applicationId, String ownerId, Object timedObjectPrimaryKey, Date initialExpiration, long intervalDuration, EJBTimerSchedule schedule, Serializable info) throws IOException {
        this.timerId = timerId;
        this.ownerId = ownerId;
        this.creationTime_ = new Date();
        this.creationTimeRaw = this.creationTime_.getTime();
        this.initialExpirationRaw = initialExpiration.getTime();
        this.initialExpiration_ = initialExpiration;
        this.lastExpirationRaw = 0L;
        this.lastExpiration_ = null;
        this.intervalDuration = intervalDuration;
        this.timerSchedule_ = schedule;
        if (this.timerSchedule_ != null) {
            this.schedule = this.timerSchedule_.getScheduleAsString();
        }
        this.containerId = containerId;
        this.applicationId = applicationId;
        this.timedObjectPrimaryKey_ = timedObjectPrimaryKey;
        this.info_ = info;
        this.blobLoaded_ = true;
        this.blob = new Blob(timedObjectPrimaryKey, info);
        this.state = 0;
    }

    String stateToString() {
        return EJBTimerService.timerStateToString(this.state);
    }

    private void loadBlob(ClassLoader cl) {
        try {
            this.timedObjectPrimaryKey_ = this.blob.getTimedObjectPrimaryKey(cl);
            this.info_ = this.blob.getInfo(cl);
            this.blobLoaded_ = true;
        }
        catch (Exception e) {
            RuntimeException ex = new RuntimeException();
            ex.initCause(e);
            throw ex;
        }
    }

    @PostLoad
    void load() {
        this.lastExpiration_ = this.lastExpirationRaw > 0L ? new Date(this.lastExpirationRaw) : null;
        this.creationTime_ = new Date(this.creationTimeRaw);
        this.initialExpiration_ = new Date(this.initialExpirationRaw);
        if (this.schedule != null) {
            this.timerSchedule_ = new EJBTimerSchedule(this.schedule);
        }
        this.timedObjectPrimaryKey_ = null;
        this.info_ = null;
        this.blobLoaded_ = false;
    }

    boolean repeats() {
        return this.intervalDuration > 0L;
    }

    Serializable getInfo() {
        if (!this.blobLoaded_) {
            this.loadBlob(EJBTimerService.getEJBTimerService().getTimerClassLoader(this.getContainerId()));
        }
        return this.info_;
    }

    Object getTimedObjectPrimaryKey() {
        if (!this.blobLoaded_) {
            this.loadBlob(EJBTimerService.getEJBTimerService().getTimerClassLoader(this.getContainerId()));
        }
        return this.timedObjectPrimaryKey_;
    }

    Date getCreationTime() {
        return this.creationTime_;
    }

    Date getInitialExpiration() {
        return this.initialExpiration_;
    }

    Date getLastExpiration() {
        return this.lastExpiration_;
    }

    void setLastExpiration(Date lastExpiration) {
        this.lastExpiration_ = lastExpiration;
        this.lastExpirationRaw = lastExpiration != null ? lastExpiration.getTime() : 0L;
    }

    boolean isActive() {
        return this.state == 0;
    }

    boolean isCancelled() {
        return this.state == 1;
    }

    static class Blob
    implements Serializable {
        private byte[] primaryKeyBytes_ = null;
        private byte[] infoBytes_ = null;
        private static final long serialVersionUID = 5022674828003386360L;
        private static final Logger logger = LogDomains.getLogger(TimerState.class, (String)"jakarta.enterprise.system.container.ejb");

        Blob() {
        }

        Blob(Object primaryKey, Serializable info) throws IOException {
            if (primaryKey != null) {
                this.primaryKeyBytes_ = EJBUtils.serializeObject(primaryKey);
            }
            if (info != null) {
                this.infoBytes_ = EJBUtils.serializeObject(info);
            }
        }

        Blob(byte[] primaryKeyBytes, byte[] infoBytes) {
            this.primaryKeyBytes_ = primaryKeyBytes;
            this.infoBytes_ = infoBytes;
        }

        Object getTimedObjectPrimaryKey(ClassLoader cl) throws Exception {
            Object pKey = null;
            if (this.primaryKeyBytes_ != null) {
                pKey = EJBUtils.deserializeObject(this.primaryKeyBytes_, cl);
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Deserialized blob : " + String.valueOf(pKey));
                }
            }
            return pKey;
        }

        Serializable getInfo(ClassLoader cl) throws Exception {
            Serializable info = null;
            if (this.infoBytes_ != null) {
                info = (Serializable)EJBUtils.deserializeObject(this.infoBytes_, cl);
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Deserialized blob : " + String.valueOf(info));
                }
            }
            return info;
        }
    }
}

