/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.util;

import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SQLTypeUtil {
    public static String getString(String key) {
        return ResourceBundle.getBundle("org.netbeans.modules.dbschema.resources.Bundle").getString(key);
    }

    public static String getSqlTypeString(int sqlType) {
        switch (sqlType) {
            case -5: {
                return SQLTypeUtil.getString("SQL_BIGINT");
            }
            case -2: {
                return SQLTypeUtil.getString("SQL_BINARY");
            }
            case -7: {
                return SQLTypeUtil.getString("SQL_BIT");
            }
            case -15: 
            case 1: {
                return SQLTypeUtil.getString("SQL_CHAR");
            }
            case 91: {
                return SQLTypeUtil.getString("SQL_DATE");
            }
            case 3: {
                return SQLTypeUtil.getString("SQL_DECIMAL");
            }
            case 8: {
                return SQLTypeUtil.getString("SQL_DOUBLE");
            }
            case 6: {
                return SQLTypeUtil.getString("SQL_FLOAT");
            }
            case 4: {
                return SQLTypeUtil.getString("SQL_INTEGER");
            }
            case -4: {
                return SQLTypeUtil.getString("SQL_LONGVARBINARY");
            }
            case -16: 
            case -1: {
                return SQLTypeUtil.getString("SQL_LONGVARCHAR");
            }
            case 0: {
                return SQLTypeUtil.getString("SQL_NULL");
            }
            case 2: {
                return SQLTypeUtil.getString("SQL_NUMERIC");
            }
            case 1111: {
                return SQLTypeUtil.getString("SQL_OTHER");
            }
            case 7: {
                return SQLTypeUtil.getString("SQL_REAL");
            }
            case 5: {
                return SQLTypeUtil.getString("SQL_SMALLINT");
            }
            case 92: {
                return SQLTypeUtil.getString("SQL_TIME");
            }
            case 93: {
                return SQLTypeUtil.getString("SQL_TIMESTAMP");
            }
            case -6: {
                return SQLTypeUtil.getString("SQL_TINYINT");
            }
            case -3: {
                return SQLTypeUtil.getString("SQL_VARBINARY");
            }
            case -9: 
            case 12: {
                return SQLTypeUtil.getString("SQL_VARCHAR");
            }
            case 2000: {
                return SQLTypeUtil.getString("SQL_JAVA_OBJECT");
            }
            case 2001: {
                return SQLTypeUtil.getString("SQL_DISTINCT");
            }
            case 2002: {
                return SQLTypeUtil.getString("SQL_STRUCT");
            }
            case 2003: {
                return SQLTypeUtil.getString("SQL_ARRAY");
            }
            case 2004: {
                return SQLTypeUtil.getString("SQL_BLOB");
            }
            case 2005: 
            case 2011: {
                return SQLTypeUtil.getString("SQL_CLOB");
            }
            case 2006: {
                return SQLTypeUtil.getString("SQL_REF");
            }
        }
        Logger.getLogger(SQLTypeUtil.class.getName()).log(Level.WARNING, "Unknown JDBC column type: " + sqlType + ". Returns null.");
        return SQLTypeUtil.getString("SQL_UNKNOWN");
    }

    public static boolean isNumeric(int type) {
        switch (type) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static boolean isCharacter(int type) {
        switch (type) {
            case -16: 
            case -15: 
            case -9: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBlob(int type) {
        switch (type) {
            case -4: 
            case -3: 
            case -2: 
            case 1111: 
            case 2004: 
            case 2005: 
            case 2011: {
                return true;
            }
        }
        return false;
    }

    public static boolean isLob(int type) {
        return SQLTypeUtil.isBlob(type) || 2005 == type || -1 == type;
    }

    public static boolean isCompatibleType(int type1, int type2) {
        return type1 == type2 || SQLTypeUtil.isCharacter(type1) && SQLTypeUtil.isCharacter(type2) || SQLTypeUtil.isNumeric(type1) && SQLTypeUtil.isNumeric(type2) || SQLTypeUtil.isBlob(type1) && SQLTypeUtil.isBlob(type2);
    }
}

