/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.cli;

import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.SecurityLifecycle;
import com.sun.enterprise.security.auth.login.LoginContextDriver;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.realm.RealmsManager;
import com.sun.enterprise.security.auth.realm.User;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.config.types.Property;

public class SecurityUtil {
    private static final String DAS_CONFIG = "server-config";
    private static String ADMIN_REALM = "admin-realm";
    private static String FILE_REALM_CLASSNAME = "com.sun.enterprise.security.auth.realm.file.FileRealm";
    private Domain domain;

    public SecurityUtil(Domain domain) {
        this.domain = domain;
        this._loadRealms();
    }

    public RealmsManager getRealmsManager() {
        RealmsManager mgr = Globals.getDefaultHabitat().getService(RealmsManager.class, new Annotation[0]);
        return mgr;
    }

    private SecurityService getSecurityService() {
        Config config = (Config)this.domain.getConfigs().getConfig().get(0);
        return config.getSecurityService();
    }

    private void _loadRealms() {
        List authRealmConfigs = this.getSecurityService().getAuthRealm();
        ArrayList<String> goodRealms = new ArrayList<String>();
        for (AuthRealm authRealm : authRealmConfigs) {
            List propConfigs = authRealm.getProperty();
            Properties props = new Properties();
            for (Property p : propConfigs) {
                String value = p.getValue();
                props.setProperty(p.getName(), value);
            }
            try {
                Realm.instantiate((String)authRealm.getName(), (String)authRealm.getClassname(), (Properties)props);
                goodRealms.add(authRealm.getName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!goodRealms.isEmpty()) {
            try {
                String defaultRealm = this.getSecurityService().getDefaultRealm();
                Realm.getInstance((String)defaultRealm);
                Realm.setDefaultRealm((String)defaultRealm);
            }
            catch (Exception e) {
                Realm.setDefaultRealm((String)((String)goodRealms.iterator().next()));
                e.printStackTrace();
            }
        }
    }

    private String[] _getRealmNames() {
        Enumeration es = this.getRealmsManager().getRealmNames();
        ArrayList<String> l = new ArrayList<String>();
        while (es.hasMoreElements()) {
            l.add((String)es.nextElement());
        }
        return l.toArray(new String[l.size()]);
    }

    public String[] getRealmNames() {
        try {
            return this._getRealmNames();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String[] getPredefinedAuthRealmClassNames() {
        List items = this.getRealmsManager().getPredefinedAuthRealmClassNames();
        return items.toArray(new String[items.size()]);
    }

    public String getDefaultRealmName() {
        return this.getRealmsManager().getDefaultRealmName();
    }

    public void setDefaultRealmName(String realmName) {
        this.getRealmsManager().setDefaultRealmName(realmName);
    }

    private Realm getRealm(String realmName) {
        Realm realm = this.getRealmsManager().getFromLoadedRealms(realmName);
        if (realm == null) {
            throw new IllegalArgumentException("No such realm: " + realmName);
        }
        return realm;
    }

    public void addUser(String realmName, String user, String password, String[] groupList) {
        this.checkSupportsUserManagement(realmName);
        try {
            Realm realm = this.getRealm(realmName);
            realm.addUser(user, password.toCharArray(), groupList);
            realm.persist();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void updateUser(String realmName, String existingUser, String newUser, String password, String[] groupList) {
        this.checkSupportsUserManagement(realmName);
        try {
            Realm realm = this.getRealm(realmName);
            realm.updateUser(existingUser, newUser, password.toCharArray(), groupList);
            realm.persist();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void removeUser(String realmName, String user) {
        this.checkSupportsUserManagement(realmName);
        try {
            Realm realm = this.getRealm(realmName);
            realm.removeUser(user);
            realm.persist();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean supportsUserManagement(String realmName) {
        return this.getRealm(realmName).supportsUserManagement();
    }

    private void checkSupportsUserManagement(String realmName) {
        if (!this.supportsUserManagement(realmName)) {
            throw new IllegalStateException("Realm " + realmName + " does not support user management");
        }
    }

    public String[] getUserNames(String realmName) {
        try {
            Enumeration es = this.getRealm(realmName).getUserNames();
            ArrayList<String> l = new ArrayList<String>();
            while (es.hasMoreElements()) {
                l.add((String)es.nextElement());
            }
            return l.toArray(new String[l.size()]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String[] getGroupNames(String realmName) {
        try {
            Enumeration es = this.getRealm(realmName).getGroupNames();
            ArrayList<String> l = new ArrayList<String>();
            while (es.hasMoreElements()) {
                l.add((String)es.nextElement());
            }
            return l.toArray(new String[l.size()]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String[] getGroupNames(String realmName, String user) {
        try {
            Enumeration es = this.getRealm(realmName).getGroupNames(user);
            ArrayList<String> l = new ArrayList<String>();
            while (es.hasMoreElements()) {
                l.add((String)es.nextElement());
            }
            return l.toArray(new String[l.size()]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Object> getUserAttributes(String realmName, String username) {
        try {
            User user = this.getRealm(realmName).getUser(username);
            HashMap<String, Object> m = new HashMap<String, Object>();
            Enumeration e = user.getAttributeNames();
            ArrayList<String> attrNames = new ArrayList<String>();
            while (e.hasMoreElements()) {
                attrNames.add((String)e.nextElement());
            }
            for (String attrName : attrNames) {
                m.put(attrName, user.getAttribute(attrName));
            }
            return m;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getAnonymousUser(ServiceLocator habitat) {
        String user = null;
        AuthRealm adminFileAuthRealm = null;
        for (AuthRealm auth : this.domain.getConfigNamed(DAS_CONFIG).getSecurityService().getAuthRealm()) {
            if (!auth.getName().equals(ADMIN_REALM)) continue;
            adminFileAuthRealm = auth;
            break;
        }
        if (adminFileAuthRealm == null) {
            throw new IllegalStateException("Cannot find admin realm");
        }
        String fileRealmClassName = adminFileAuthRealm.getClassname();
        if (fileRealmClassName != null && !fileRealmClassName.equals(FILE_REALM_CLASSNAME)) {
            return null;
        }
        List props = adminFileAuthRealm.getProperty();
        Property keyfileProp = null;
        for (Property prop : props) {
            if (!"file".equals(prop.getName())) continue;
            keyfileProp = prop;
        }
        if (keyfileProp == null) {
            throw new IllegalStateException("Cannot find property 'file'");
        }
        String keyFile = keyfileProp.getValue();
        if (keyFile == null) {
            throw new IllegalStateException("Cannot find key file");
        }
        String[] usernames = this.getUserNames(adminFileAuthRealm.getName());
        if (usernames.length == 1) {
            try {
                habitat.getService(SecurityLifecycle.class, new Annotation[0]);
                LoginContextDriver.login((String)usernames[0], (char[])new char[0], (String)ADMIN_REALM);
                user = usernames[0];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return user;
    }
}

