/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.replication.buffer;

class LogBufferElement {
    private final byte[] bufferdata;
    private int position;
    private long greatestInstant;
    private boolean recycleMe;

    protected LogBufferElement(int n) {
        this.bufferdata = new byte[n];
        this.init();
    }

    protected void init() {
        this.position = 0;
        this.greatestInstant = 0L;
        this.recycleMe = true;
    }

    protected void appendLog(long l, byte[] byArray, int n, int n2) {
        this.greatestInstant = l;
        this.position = this.appendBytes(byArray, n, this.position, n2);
    }

    protected byte[] getData() {
        return this.bufferdata;
    }

    protected long getLastInstant() {
        return this.greatestInstant;
    }

    protected int freeSize() {
        return this.bufferdata.length - this.position;
    }

    protected int size() {
        return this.position;
    }

    protected boolean isRecyclable() {
        return this.recycleMe;
    }

    protected void setRecyclable(boolean bl) {
        this.recycleMe = bl;
    }

    private int appendBytes(byte[] byArray, int n, int n2, int n3) {
        System.arraycopy(byArray, n, this.bufferdata, n2, n3);
        return n2 + n3;
    }
}

