/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.node;

import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.node.DisplayableComponentNode;
import com.sun.enterprise.deployment.node.InjectionTargetNode;
import com.sun.enterprise.deployment.node.JndiEnvRefNode;
import com.sun.enterprise.deployment.node.XMLElement;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.webservices.connector.LogUtils;
import org.glassfish.webservices.node.AddressingNode;
import org.glassfish.webservices.node.RespectBindingNode;
import org.glassfish.webservices.node.WebServiceHandlerChainNode;
import org.glassfish.webservices.node.WebServiceHandlerNode;
import org.jvnet.hk2.annotations.Service;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Service(name="service-ref")
@PerLookup
public class ServiceReferenceNode
extends DisplayableComponentNode<ServiceReferenceDescriptor>
implements JndiEnvRefNode<ServiceReferenceDescriptor> {
    private static final Logger logger = LogUtils.getLogger();
    private ServiceRefPortInfo portInfo;

    public ServiceReferenceNode() {
        this.registerElementHandler(new XMLElement("handler"), WebServiceHandlerNode.class, "addHandler");
        this.registerElementHandler(new XMLElement("handler-chain"), WebServiceHandlerChainNode.class, "addHandlerChain");
        this.registerElementHandler(new XMLElement("addressing"), AddressingNode.class, "setAddressing");
        this.registerElementHandler(new XMLElement("respect-binding"), RespectBindingNode.class, "setRespectBinding");
        this.registerElementHandler(new XMLElement("injection-target"), InjectionTargetNode.class, "addInjectionTarget");
    }

    @Override
    protected Map<String, String> getDispatchTable() {
        Map<String, String> table = super.getDispatchTable();
        table.put("service-ref-name", "setName");
        table.put("service-interface", "setServiceInterface");
        table.put("wsdl-file", "setWsdlFileUri");
        table.put("jaxrpc-mapping-file", "setMappingFileUri");
        table.put("mapped-name", "setMappedName");
        table.put("lookup-name", "setLookupName");
        table.put("service-ref-type", "setInjectionTargetType");
        return table;
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        String qname = element.getQName();
        if ("service-endpoint-interface".equals(qname)) {
            this.portInfo = this.getDescriptor().getPortInfoBySEI(value);
            if (this.portInfo == null) {
                this.portInfo = this.getDescriptor().addContainerManagedPort(value);
            }
        } else if ("service-qname".equals(qname)) {
            String prefix = this.getPrefixFromQName(value);
            String localPart = this.getLocalPartFromQName(value);
            String namespaceUri = this.resolvePrefix(element, prefix);
            if (namespaceUri == null) {
                logger.log(Level.SEVERE, "AS-WSCONNECTOR-00046", new Object[]{prefix, this.getDescriptor().getName()});
            } else {
                QName serviceName = new QName(namespaceUri, localPart);
                this.getDescriptor().setServiceName(serviceName, prefix);
            }
        } else if ("enable-mtom".equals(qname)) {
            this.portInfo.setMtomEnabled(value);
        } else if ("port-component-link".equals(qname)) {
            this.portInfo.setPortComponentLinkName(value);
            this.portInfo = null;
        } else {
            super.setElementValue(element, value);
        }
    }

    @Override
    public Node writeDeploymentDescriptor(Node parent, ServiceReferenceDescriptor descriptor) {
        Node serviceRefNode = super.writeDescriptor(parent, "service-ref", descriptor);
        this.writeDisplayableComponentInfo(serviceRefNode, descriptor);
        ServiceReferenceNode.appendTextChild(serviceRefNode, "service-ref-name", descriptor.getName());
        ServiceReferenceNode.appendTextChild(serviceRefNode, "service-interface", descriptor.getServiceInterface());
        ServiceReferenceNode.appendTextChild(serviceRefNode, "lookup-name", descriptor.getLookupName());
        ServiceReferenceNode.appendTextChild(serviceRefNode, "service-ref-type", descriptor.getInjectionTargetType());
        ServiceReferenceNode.appendTextChild(serviceRefNode, "wsdl-file", descriptor.getWsdlFileUri());
        ServiceReferenceNode.appendTextChild(serviceRefNode, "jaxrpc-mapping-file", descriptor.getMappingFileUri());
        if (descriptor.hasServiceName()) {
            QName serviceName = descriptor.getServiceName();
            this.appendQNameChild("service-qname", serviceRefNode, serviceName.getNamespaceURI(), serviceName.getLocalPart(), descriptor.getServiceNameNamespacePrefix());
        }
        for (ServiceRefPortInfo element : descriptor.getPortsInfo()) {
            String sei = element.getServiceEndpointInterface();
            Element portComponentRefNode = ServiceReferenceNode.appendChild(serviceRefNode, "port-component-ref");
            ServiceReferenceNode.appendTextChild((Node)portComponentRefNode, "service-endpoint-interface", sei);
            ServiceReferenceNode.appendTextChild((Node)portComponentRefNode, "enable-mtom", element.getMtomEnabled());
            if (descriptor.getAddressing() != null) {
                AddressingNode adNode = new AddressingNode();
                adNode.writeDescriptor((Node)portComponentRefNode, "addressing", descriptor.getAddressing());
            }
            ServiceReferenceNode.appendTextChild((Node)portComponentRefNode, "port-component-link", element.getPortComponentLinkName());
        }
        WebServiceHandlerNode handlerNode = new WebServiceHandlerNode();
        handlerNode.writeWebServiceHandlers(serviceRefNode, descriptor.getHandlers());
        WebServiceHandlerChainNode handlerChainNode = new WebServiceHandlerChainNode();
        handlerChainNode.writeWebServiceHandlerChains(serviceRefNode, descriptor.getHandlerChain());
        ServiceReferenceNode.appendTextChild(serviceRefNode, "mapped-name", descriptor.getMappedName());
        if (descriptor.isInjectable()) {
            InjectionTargetNode ijNode = new InjectionTargetNode();
            for (InjectionTarget target : descriptor.getInjectionTargets()) {
                ijNode.writeDescriptor(serviceRefNode, "injection-target", target);
            }
        }
        return serviceRefNode;
    }

    @Override
    public ServiceReferenceDescriptor getDescriptor() {
        return (ServiceReferenceDescriptor)super.getDescriptor();
    }

    @Override
    public String getTagName() {
        return "service-ref";
    }
}

