/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.deploy.shared.MemoryMappedArchive;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.appclient.client.acc.ACCClassLoader;
import org.glassfish.appclient.client.acc.Launchable;
import org.glassfish.appclient.client.acc.Util;
import org.glassfish.deployment.common.ModuleDescriptor;
import org.glassfish.hk2.api.ServiceLocator;
import org.xml.sax.SAXException;

public class MainClassLaunchable
implements Launchable {
    private static final System.Logger LOG = System.getLogger(MainClassLaunchable.class.getName());
    private final Class<?> mainClass;
    private ApplicationClientDescriptor acDesc;
    private ClassLoader classLoader;
    private AppClientArchivist archivist;

    MainClassLaunchable(ServiceLocator habitat, Class<?> mainClass) {
        this.mainClass = mainClass;
    }

    @Override
    public Class<?> getMainClass() throws ClassNotFoundException {
        return this.mainClass;
    }

    @Override
    public ApplicationClientDescriptor getDescriptor(URLClassLoader loader) throws IOException, SAXException {
        if (this.acDesc == null) {
            ReadableArchive tempArchive = null;
            PrivilegedAction<ACCClassLoader> action = () -> new ACCClassLoader(loader.getURLs(), loader.getParent());
            ACCClassLoader tempLoader = AccessController.doPrivileged(action);
            tempArchive = this.createArchive((ClassLoader)((Object)tempLoader), this.mainClass);
            AppClientArchivist acArchivist = this.getArchivist(tempArchive, (ClassLoader)((Object)tempLoader));
            this.archivist.setClassLoader((ClassLoader)((Object)tempLoader));
            this.archivist.setDescriptor((BundleDescriptor)this.acDesc);
            this.archivist.setAnnotationProcessingRequested(true);
            this.acDesc = (ApplicationClientDescriptor)acArchivist.open(tempArchive);
            Application.createVirtualApplication(null, (ModuleDescriptor)this.acDesc.getModuleDescriptor());
            this.acDesc.getApplication().setAppName(this.appNameFromMainClass(this.mainClass));
            this.classLoader = loader;
        }
        return this.acDesc;
    }

    private String appNameFromMainClass(Class c) {
        return c.getName();
    }

    private ReadableArchive createArchive(ClassLoader loader, Class<?> mainClass) throws IOException {
        int bytesRead;
        LOG.log(System.Logger.Level.DEBUG, "createArchive(loader, mainClass={0})", mainClass);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Manifest mf = new Manifest();
        Attributes mainAttrs = mf.getMainAttributes();
        mainAttrs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        mainAttrs.put(Attributes.Name.MAIN_CLASS, mainClass.getName());
        JarOutputStream jos = new JarOutputStream((OutputStream)baos, mf);
        String mainClassResourceName = mainClass.getName().replace('.', '/') + ".class";
        ZipEntry mainClassEntry = new ZipEntry(mainClassResourceName);
        jos.putNextEntry(mainClassEntry);
        InputStream is = loader.getResourceAsStream(mainClassResourceName);
        byte[] buffer = new byte[1024];
        while ((bytesRead = is.read(buffer)) != -1) {
            jos.write(buffer, 0, bytesRead);
        }
        is.close();
        jos.closeEntry();
        jos.close();
        MemoryMappedArchive mma = new MemoryMappedArchive(baos.toByteArray());
        mma.setURI(URI.create("file:///tempClient.jar"));
        return mma;
    }

    private AppClientArchivist getArchivist(ReadableArchive clientRA, ClassLoader classLoader) throws IOException {
        if (this.archivist == null) {
            ArchivistFactory af = Util.getArchivistFactory();
            this.archivist = (AppClientArchivist)af.getArchivist(DOLUtils.carType());
            this.archivist.setAnnotationProcessingRequested(true);
        }
        return this.archivist;
    }

    @Override
    public void validateDescriptor() {
        this.archivist.validate(this.classLoader);
    }

    @Override
    public URI getURI() {
        return null;
    }

    @Override
    public String getAnchorDir() {
        return null;
    }
}

