/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.model.jdo.impl;

import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.ModelVetoException;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.jdo.impl.PersistenceMemberElementImpl;
import com.sun.jdo.spi.persistence.utility.JavaTypeHelper;
import java.beans.PropertyVetoException;

public class PersistenceFieldElementImpl
extends PersistenceMemberElementImpl
implements PersistenceFieldElement.Impl {
    private static final int READ_SENSITIVE = 1;
    private static final int WRITE_SENSITIVE = 2;
    private int _persistenceType = 0;
    private int _derivedModifier;
    private boolean _isKey;

    public PersistenceFieldElementImpl() {
        this(null);
    }

    public PersistenceFieldElementImpl(String name) {
        super(name);
    }

    @Override
    public int getPersistenceType() {
        return this._persistenceType;
    }

    @Override
    public void setPersistenceType(int type) throws ModelException {
        Integer old = new Integer(this.getPersistenceType());
        Integer newType = new Integer(type);
        try {
            this.fireVetoableChange("persistence", old, newType);
            this._persistenceType = type;
            this.firePropertyChange("persistence", old, newType);
        }
        catch (PropertyVetoException e) {
            throw new ModelVetoException(e);
        }
    }

    @Override
    public boolean isReadSensitive() {
        return 1 == this.getPersistenceType() ? (this._derivedModifier & 1) != 0 : false;
    }

    @Override
    public void setReadSensitive(boolean flag) throws ModelException {
        Boolean old = JavaTypeHelper.valueOf(this.isReadSensitive());
        Boolean newFlag = JavaTypeHelper.valueOf(flag);
        try {
            this.fireVetoableChange("sensitivity", old, newFlag);
            this._derivedModifier = flag ? (this._derivedModifier |= 1) : (this._derivedModifier &= 1);
            this.firePropertyChange("sensitivity", old, newFlag);
        }
        catch (PropertyVetoException e) {
            throw new ModelVetoException(e);
        }
    }

    @Override
    public boolean isWriteSensitive() {
        return 1 == this.getPersistenceType() ? (this._derivedModifier & 2) != 0 : false;
    }

    @Override
    public void setWriteSensitive(boolean flag) throws ModelException {
        Boolean old = JavaTypeHelper.valueOf(this.isWriteSensitive());
        Boolean newFlag = JavaTypeHelper.valueOf(flag);
        try {
            this.fireVetoableChange("sensitivity", old, newFlag);
            this._derivedModifier = flag ? (this._derivedModifier |= 2) : (this._derivedModifier &= 2);
            this.firePropertyChange("sensitivity", old, newFlag);
        }
        catch (PropertyVetoException e) {
            throw new ModelVetoException(e);
        }
    }

    @Override
    public boolean isKey() {
        return this._isKey;
    }

    @Override
    public void setKey(boolean flag) throws ModelException {
        Boolean old = JavaTypeHelper.valueOf(this.isKey());
        Boolean newFlag = JavaTypeHelper.valueOf(flag);
        try {
            this.fireVetoableChange("keyField", old, newFlag);
            this._isKey = flag;
            this.firePropertyChange("keyField", old, newFlag);
        }
        catch (PropertyVetoException e) {
            throw new ModelVetoException(e);
        }
    }
}

