/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.model.jdo;

import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.jdo.ConcurrencyGroupElement;
import com.sun.jdo.api.persistence.model.jdo.FieldElementHolder;
import com.sun.jdo.api.persistence.model.jdo.PersistenceElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.jdo.RelationshipElement;
import com.sun.jdo.spi.persistence.utility.StringHelper;
import java.util.ArrayList;
import org.glassfish.persistence.common.I18NHelper;

public class PersistenceClassElement
extends PersistenceElement
implements FieldElementHolder {
    public static final int APPLICATION_IDENTITY = 0;
    public static final int DATABASE_IDENTITY = 1;
    public static final int UNMANAGED_IDENTITY = 2;

    public PersistenceClassElement() {
        this(null);
    }

    public PersistenceClassElement(Impl impl) {
        super(impl);
    }

    public static PersistenceClassElement forName(String name, Model model) {
        return model.getPersistenceClass(name);
    }

    final Impl getClassImpl() {
        return (Impl)this.getImpl();
    }

    public String getPackage() {
        String className = this.getName();
        int index = className.lastIndexOf(46);
        return index != -1 ? className.substring(0, index) : "";
    }

    public boolean isModified() {
        return this.getClassImpl().isModified();
    }

    public void setModified(boolean flag) {
        this.getClassImpl().setModified(flag);
    }

    public int getObjectIdentityType() {
        return this.getClassImpl().getObjectIdentityType();
    }

    public void setObjectIdentityType(int type) throws ModelException {
        this.getClassImpl().setObjectIdentityType(type);
    }

    public String getKeyClass() {
        return this.getClassImpl().getKeyClass();
    }

    public void setKeyClass(String name) throws ModelException {
        boolean hasValue;
        boolean bl = hasValue = name != null;
        if (hasValue) {
            name = name.trim();
        }
        if (hasValue && name.length() > 0) {
            String nameSuffix;
            String className = this.getName();
            boolean hasPrefix = name.startsWith(className);
            String string = nameSuffix = hasPrefix ? name.substring(className.length()) : name;
            if (!hasPrefix || !nameSuffix.equalsIgnoreCase("Key") && !nameSuffix.equalsIgnoreCase(".OID") && !nameSuffix.equalsIgnoreCase("$OID")) {
                throw new ModelException(I18NHelper.getMessage(PersistenceClassElement.getMessages(), "jdo.class.key_class_invalid", name, className));
            }
        }
        this.getClassImpl().setKeyClass(name);
    }

    @Override
    public void setName(String name) throws ModelException {
        String oldKeyClass;
        String oldName = this.getName();
        super.setName(name);
        if (!StringHelper.isEmpty(name) && (oldKeyClass = this.getKeyClass()) != null && oldKeyClass.startsWith(oldName)) {
            this.setKeyClass(name + oldKeyClass.substring(oldName.length()));
        }
    }

    @Override
    public void addField(PersistenceFieldElement field) throws ModelException {
        this.addFields(new PersistenceFieldElement[]{field});
    }

    @Override
    public void addFields(PersistenceFieldElement[] fields) throws ModelException {
        this.getClassImpl().changeFields(fields, 1);
    }

    @Override
    public void removeField(PersistenceFieldElement field) throws ModelException {
        this.removeFields(new PersistenceFieldElement[]{field});
    }

    @Override
    public void removeFields(PersistenceFieldElement[] fields) throws ModelException {
        int count = fields != null ? fields.length : 0;
        this.getClassImpl().changeFields(fields, -1);
        for (int i = 0; i < count; ++i) {
            PersistenceFieldElement field = fields[i];
            ConcurrencyGroupElement[] groups = field.getConcurrencyGroups();
            int groupCount = groups != null ? groups.length : 0;
            for (int j = 0; j < groupCount; ++j) {
                groups[j].removeField(field);
            }
        }
    }

    @Override
    public PersistenceFieldElement[] getFields() {
        return this.getClassImpl().getFields();
    }

    @Override
    public void setFields(PersistenceFieldElement[] fields) throws ModelException {
        this.getClassImpl().changeFields(fields, 0);
    }

    @Override
    public PersistenceFieldElement getField(String name) {
        return this.getClassImpl().getField(name);
    }

    @Override
    public boolean containsField(PersistenceFieldElement field) {
        return this.getClassImpl().getField(field.getName()) != null;
    }

    public RelationshipElement[] getRelationships() {
        PersistenceFieldElement[] fields = this.getFields();
        int count = fields != null ? fields.length : 0;
        ArrayList<PersistenceFieldElement> relationships = new ArrayList<PersistenceFieldElement>(count);
        for (int i = 0; i < count; ++i) {
            PersistenceFieldElement field = fields[i];
            if (!(field instanceof RelationshipElement)) continue;
            relationships.add(field);
        }
        count = relationships.size();
        return relationships.toArray(new RelationshipElement[count]);
    }

    public RelationshipElement getRelationship(String name) {
        RelationshipElement[] relationships = this.getRelationships();
        int count = relationships != null ? relationships.length : 0;
        for (int i = 0; i < count; ++i) {
            RelationshipElement relationship = relationships[i];
            if (!name.equals(relationship.getName())) continue;
            return relationship;
        }
        return null;
    }

    public void addConcurrencyGroup(ConcurrencyGroupElement group) throws ModelException {
        this.addConcurrencyGroups(new ConcurrencyGroupElement[]{group});
    }

    public void addConcurrencyGroups(ConcurrencyGroupElement[] groups) throws ModelException {
        this.getClassImpl().changeConcurrencyGroups(groups, 1);
    }

    public void removeConcurrencyGroup(ConcurrencyGroupElement group) throws ModelException {
        this.removeConcurrencyGroups(new ConcurrencyGroupElement[]{group});
    }

    public void removeConcurrencyGroups(ConcurrencyGroupElement[] groups) throws ModelException {
        this.getClassImpl().changeConcurrencyGroups(groups, -1);
    }

    public ConcurrencyGroupElement[] getConcurrencyGroups() {
        return this.getClassImpl().getConcurrencyGroups();
    }

    public void setConcurrencyGroups(ConcurrencyGroupElement[] groups) throws ModelException {
        this.getClassImpl().changeConcurrencyGroups(groups, 0);
    }

    public ConcurrencyGroupElement getConcurrencyGroup(String name) {
        return this.getClassImpl().getConcurrencyGroup(name);
    }

    public boolean containsConcurrencyGroup(ConcurrencyGroupElement group) {
        return this.getClassImpl().getConcurrencyGroup(group.getName()) != null;
    }

    public static interface Impl
    extends PersistenceElement.Impl {
        public boolean isModified();

        public void setModified(boolean var1);

        public int getObjectIdentityType();

        public void setObjectIdentityType(int var1) throws ModelException;

        public String getKeyClass();

        public void setKeyClass(String var1) throws ModelException;

        public void changeFields(PersistenceFieldElement[] var1, int var2) throws ModelException;

        public PersistenceFieldElement[] getFields();

        public PersistenceFieldElement getField(String var1);

        public void changeConcurrencyGroups(ConcurrencyGroupElement[] var1, int var2) throws ModelException;

        public ConcurrencyGroupElement[] getConcurrencyGroups();

        public ConcurrencyGroupElement getConcurrencyGroup(String var1);
    }
}

