/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.remote;

import com.sun.appserv.management.client.prefs.LoginInfo;
import com.sun.appserv.management.client.prefs.LoginInfoStore;
import com.sun.appserv.management.client.prefs.LoginInfoStoreFactory;
import com.sun.appserv.management.client.prefs.StoreException;
import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.DirectoryClassLoader;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.remote.ClientCookieStore;
import com.sun.enterprise.admin.cli.remote.ReExecuted;
import com.sun.enterprise.admin.remote.RemoteAdminCommand;
import com.sun.enterprise.admin.util.CachedCommandModel;
import com.sun.enterprise.admin.util.CommandModelData;
import com.sun.enterprise.module.single.StaticModulesRegistry;
import com.sun.enterprise.security.store.AsadminSecurityUtil;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.common.util.admin.ManPageFinder;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.BuilderHelper;

public class RemoteCommand
extends CLICommand {
    private static final LocalStringsImpl strings = new LocalStringsImpl(RemoteCommand.class);
    private boolean returnOutput;
    private String output;
    private boolean returnAttributes;
    private Map<String, String> attrs;
    private String usage;
    private String responseFormatType;
    private OutputStream userOut;
    private File outputDir;
    private CLIRemoteAdminCommand rac;
    private static ClassLoader moduleClassLoader;
    private static ServiceLocator manServiceLocator;

    public RemoteCommand() throws CommandException {
    }

    public RemoteCommand(String name, ProgramOptions po, Environment env) throws CommandException {
        super(name, po, env);
    }

    public RemoteCommand(String name, ProgramOptions po, Environment env, String responseFormatType, OutputStream userOut) throws CommandException {
        this(name, po, env);
        this.responseFormatType = responseFormatType;
        this.userOut = userOut;
    }

    private void reExecuteAfterMetadataUpdate() throws ReExecuted, CommandException {
        if (this.rac == null) {
            return;
        }
        if (this.rac.getCommandModel() == null) {
            return;
        }
        if (!this.rac.isCommandModelFromCache()) {
            return;
        }
        String eTag = CachedCommandModel.computeETag((CommandModel)this.rac.getCommandModel());
        this.rac = null;
        this.initializeRemoteAdminCommand();
        this.rac.fetchCommandModel();
        String newETag = CachedCommandModel.computeETag((CommandModel)this.rac.getCommandModel());
        if (eTag != null && eTag.equals(newETag)) {
            return;
        }
        logger.log(Level.WARNING, "Command signature of {0} command was changed. Reexecuting with new metadata.", this.name);
        this.options = null;
        this.operands = null;
        int result = this.execute(this.argv);
        throw new ReExecuted(result);
    }

    @Override
    public int execute(String ... argv) throws CommandException {
        try {
            return super.execute(argv);
        }
        catch (ReExecuted reex) {
            return reex.getExecutionResult();
        }
    }

    public void setFileOutputDirectory(File dir) {
        this.outputDir = dir;
    }

    @Override
    protected void prepare() throws CommandException, CommandValidationException {
        try {
            this.processProgramOptions();
            this.initializeAuth();
            this.initializeRemoteAdminCommand();
            if (this.responseFormatType != null) {
                this.rac.setResponseFormatType(this.responseFormatType);
            }
            if (this.userOut != null) {
                this.rac.setUserOut(this.userOut);
            }
            this.initializeCookieManager();
            if (this.programOpts.isHelp()) {
                this.commandModel = this.helpModel();
                this.rac.setCommandModel(this.commandModel);
                return;
            }
            this.commandModel = this.rac.getCommandModel();
            if (this.programOpts.isNotifyCommand()) {
                this.commandModel.add((CommandModel.ParamModel)new CommandModelData.ParamModelData("notify", Boolean.TYPE, true, "false"));
            }
        }
        catch (CommandException e) {
            logger.log(Level.SEVERE, "RemoteCommand.prepare throws exception.", e);
            throw e;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "RemoteCommand.prepare throws exception.", e);
            throw new CommandException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void prevalidate() throws CommandException {
        try {
            super.prevalidate();
        }
        catch (CommandException ex) {
            this.reExecuteAfterMetadataUpdate();
            throw ex;
        }
    }

    @Override
    protected void validate() throws CommandException, CommandValidationException {
        if (this.programOpts.isHelp()) {
            return;
        }
        try {
            super.validate();
        }
        catch (CommandValidationException ex) {
            this.reExecuteAfterMetadataUpdate();
            throw ex;
        }
    }

    @Override
    protected void inject() throws CommandException {
        try {
            super.prevalidate();
        }
        catch (CommandValidationException ex) {
            this.reExecuteAfterMetadataUpdate();
            throw ex;
        }
    }

    @Override
    protected boolean checkHelp() throws CommandException, CommandValidationException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int executeCommand() throws CommandException, CommandValidationException {
        String returnVal;
        try {
            this.options.set((Object)"DEFAULT", (Collection)this.operands);
            this.output = this.rac.executeCommand(this.options);
            if (this.returnAttributes) {
                this.attrs = this.rac.getAttributes();
            } else if (!this.returnOutput && this.output.length() > 0) {
                logger.info(this.output);
            }
        }
        catch (CommandValidationException cve) {
            this.reExecuteAfterMetadataUpdate();
            throw cve;
        }
        catch (CommandException ex) {
            if (this.programOpts.isHelp()) {
                BufferedReader r = this.getLocalManPage();
                BufferedReader br = null;
                try {
                    if (r != null) {
                        int cnt;
                        br = new BufferedReader(r);
                        PrintWriter pw = new PrintWriter(System.out, false, Charset.defaultCharset());
                        char[] buf = new char[8192];
                        while ((cnt = br.read(buf)) > 0) {
                            pw.write(buf, 0, cnt);
                        }
                        pw.flush();
                        int n = 0;
                        return n;
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        if (br != null) {
                            br.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            throw ex;
        }
        Map racAttrs = this.rac.getAttributes();
        String string = returnVal = racAttrs != null ? (String)racAttrs.get("exit-code") : null;
        if (returnVal != null && "WARNING".equals(returnVal)) {
            return 4;
        }
        return 0;
    }

    public String executeAndReturnOutput(String ... args) throws CommandException, CommandValidationException {
        this.returnOutput = true;
        this.execute(args);
        this.returnOutput = false;
        return this.output;
    }

    public Map<String, String> executeAndReturnAttributes(String ... args) throws CommandException, CommandValidationException {
        this.returnAttributes = true;
        this.execute(args);
        this.returnAttributes = false;
        return this.attrs;
    }

    @Override
    public String getUsage() {
        if (this.usage == null) {
            if (this.rac == null) {
                return this.getCommandUsage();
            }
            this.usage = this.rac.getUsage();
        }
        if (this.usage == null) {
            return super.getUsage();
        }
        StringBuilder usageText = new StringBuilder();
        usageText.append(strings.get("Usage", new Object[]{this.getBriefCommandUsage()}));
        usageText.append(" ");
        usageText.append(this.usage);
        return usageText.toString();
    }

    @Override
    public BufferedReader getManPage() {
        try {
            this.initializeRemoteAdminCommand();
            this.rac.setCommandModel(this.helpModel());
            ParameterMap params = new ParameterMap();
            params.set((Object)"help", (Object)"true");
            String manpage = this.rac.executeCommand(params);
            return new BufferedReader(new StringReader(manpage));
        }
        catch (CommandException params) {
            BufferedReader r = this.getLocalManPage();
            return r != null ? r : super.getManPage();
        }
    }

    private CommandModel helpModel() {
        CommandModelData cm = new CommandModelData(this.name);
        cm.add((CommandModel.ParamModel)new CommandModelData.ParamModelData("help", Boolean.TYPE, true, "false", "?"));
        return cm;
    }

    private BufferedReader getLocalManPage() {
        logger.fine(strings.get("NoRemoteManPage"));
        String cmdClass = RemoteCommand.getCommandClass(this.getName());
        ClassLoader mcl = RemoteCommand.getModuleClassLoader();
        if (cmdClass != null && mcl != null) {
            return ManPageFinder.getCommandManPage((String)this.getName(), (String)cmdClass, (Locale)Locale.getDefault(), (ClassLoader)mcl, (Logger)logger);
        }
        return null;
    }

    private void initializeRemoteAdminCommand() throws CommandException {
        if (this.rac == null) {
            this.rac = new CLIRemoteAdminCommand(this.name, this.programOpts.getHost(), this.programOpts.getPort(), this.programOpts.isSecure(), this.programOpts.getUser(), this.programOpts.getPassword(), logger, this.programOpts.getAuthToken());
            this.rac.setFileOutputDirectory(this.outputDir);
            this.rac.setInteractive(this.programOpts.isInteractive());
        }
    }

    private void initializeAuth() throws CommandException {
        LoginInfo li = null;
        try {
            LoginInfoStore store = LoginInfoStoreFactory.getDefaultStore();
            li = store.read(this.programOpts.getHost(), this.programOpts.getPort());
            if (li == null) {
                return;
            }
        }
        catch (StoreException se) {
            logger.finer("Login info could not be read from ~/.asadminpass file");
            return;
        }
        if (this.programOpts.getUser() == null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Getting user name from ~/.asadminpass: " + li.getUser());
            }
            this.programOpts.setUser(li.getUser());
            if (this.programOpts.getPassword() == null) {
                logger.finer("Getting password from ~/.asadminpass");
                this.programOpts.setPassword(li.getPassword(), ProgramOptions.PasswordLocation.LOGIN_FILE);
            }
        } else if (this.programOpts.getUser().equals(li.getUser()) && this.programOpts.getPassword() == null) {
            logger.finer("Getting password from ~/.asadminpass");
            this.programOpts.setPassword(li.getPassword(), ProgramOptions.PasswordLocation.LOGIN_FILE);
        }
    }

    private void initializeCookieManager() {
        CookieStore defaultCookieStore = new CookieManager().getCookieStore();
        CookieManager manager = new CookieManager(defaultCookieStore, CookiePolicy.ACCEPT_ALL);
        CookieHandler.setDefault(manager);
    }

    private static String getCommandClass(String cmdName) {
        ServiceLocator h = RemoteCommand.getManHabitat();
        String cname = "org.glassfish.api.admin.AdminCommand";
        for (ActiveDescriptor ad : h.getDescriptors((Filter)BuilderHelper.createContractFilter((String)cname))) {
            if (ad.getName() == null || !ad.getName().equals(cmdName)) continue;
            return ad.getImplementation();
        }
        return null;
    }

    private static synchronized ServiceLocator getManHabitat() {
        ServiceLocator serviceLocator;
        if (manServiceLocator != null) {
            return manServiceLocator;
        }
        StaticModulesRegistry registry = new StaticModulesRegistry(RemoteCommand.getModuleClassLoader());
        manServiceLocator = serviceLocator = registry.createServiceLocator("default");
        return manServiceLocator;
    }

    private static synchronized ClassLoader getModuleClassLoader() {
        if (moduleClassLoader != null) {
            return moduleClassLoader;
        }
        File installDir = new File(System.getProperty("com.sun.aas.installRoot"));
        File modulesDir = new File(installDir, "modules");
        moduleClassLoader = new DirectoryClassLoader(modulesDir, CLICommand.class.getClassLoader());
        return moduleClassLoader;
    }

    private class CLIRemoteAdminCommand
    extends RemoteAdminCommand {
        private static final String JSESSIONID = "JSESSIONID";
        private static final String COOKIE_HEADER = "Cookie";
        private CookieManager cookieManager;
        private final File sessionCache;

        private CLIRemoteAdminCommand(String name, String host, int port, boolean secure, String user, char[] password, Logger logger, String authToken) throws CommandException {
            super(name, host, port, secure, user, password, logger, CLICommand.getCommandScope(), authToken, true);
            this.sessionCache = AsadminSecurityUtil.getGfClientSessionFile((String)host, (int)port);
        }

        public void fetchCommandModel() throws CommandException {
            super.fetchCommandModel();
        }

        protected boolean updateAuthentication() {
            Console cons;
            if (RemoteCommand.this.programOpts.isInteractive() && (cons = System.console()) != null) {
                String puser;
                char[] password;
                ProgramOptions.PasswordLocation pwloc = RemoteCommand.this.programOpts.getPasswordLocation();
                if (pwloc == ProgramOptions.PasswordLocation.PASSWORD_FILE) {
                    this.logger.fine(strings.get("BadPasswordFromFile", new Object[]{RemoteCommand.this.programOpts.getPasswordFile()}));
                } else if (pwloc == ProgramOptions.PasswordLocation.LOGIN_FILE) {
                    try {
                        LoginInfoStore store = LoginInfoStoreFactory.getDefaultStore();
                        this.logger.fine(strings.get("BadPasswordFromLogin", new Object[]{store.getName()}));
                    }
                    catch (StoreException store) {
                        // empty catch block
                    }
                }
                String user = null;
                if (RemoteCommand.this.programOpts.getUser() == null) {
                    cons.printf("%s ", strings.get("AdminUserPrompt"));
                    user = cons.readLine();
                    if (user == null) {
                        return false;
                    }
                }
                if ((password = RemoteCommand.ok(puser = RemoteCommand.ok(user) ? user : RemoteCommand.this.programOpts.getUser()) ? RemoteCommand.this.readPassword(strings.get("AdminUserPasswordPrompt", new Object[]{puser})) : RemoteCommand.this.readPassword(strings.get("AdminPasswordPrompt"))) == null) {
                    return false;
                }
                if (RemoteCommand.ok(user)) {
                    RemoteCommand.this.programOpts.setUser(user);
                    this.user = user;
                }
                RemoteCommand.this.programOpts.setPassword(password, ProgramOptions.PasswordLocation.USER);
                this.password = password;
                return true;
            }
            return false;
        }

        protected String getFromEnvironment(String name) {
            return RemoteCommand.this.env.getStringOption(name);
        }

        protected boolean retryUsingSecureConnection(String host, int port) {
            String msg = strings.get("ServerMaybeSecure", new Object[]{host, "" + port});
            this.logger.info(msg);
            return true;
        }

        protected String reportAuthenticationException() {
            String msg = null;
            ProgramOptions.PasswordLocation pwloc = RemoteCommand.this.programOpts.getPasswordLocation();
            if (pwloc == ProgramOptions.PasswordLocation.PASSWORD_FILE) {
                msg = strings.get("InvalidCredentialsFromFile", new Object[]{RemoteCommand.this.programOpts.getUser(), RemoteCommand.this.programOpts.getPasswordFile()});
            } else if (pwloc == ProgramOptions.PasswordLocation.LOGIN_FILE) {
                try {
                    LoginInfoStore store = LoginInfoStoreFactory.getDefaultStore();
                    msg = strings.get("InvalidCredentialsFromLogin", new Object[]{RemoteCommand.this.programOpts.getUser(), store.getName()});
                }
                catch (StoreException storeException) {
                    // empty catch block
                }
            }
            if (msg == null) {
                msg = strings.get("InvalidCredentials", new Object[]{RemoteCommand.this.programOpts.getUser()});
            }
            return msg;
        }

        protected synchronized void addAdditionalHeaders(URLConnection urlConnection) {
            this.addCookieHeaders(urlConnection);
        }

        private void addCookieHeaders(URLConnection urlConnection) {
            long modifiedTime = this.sessionCache.lastModified();
            if (modifiedTime == 0L) {
                return;
            }
            ((CookieManager)CookieHandler.getDefault()).getCookieStore().removeAll();
            this.cookieManager = new CookieManager(new ClientCookieStore(new CookieManager().getCookieStore(), this.sessionCache), CookiePolicy.ACCEPT_ALL);
            try {
                ((ClientCookieStore)this.cookieManager.getCookieStore()).load();
            }
            catch (IOException e) {
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.finer("Unable to load cookies: " + String.valueOf(e));
                }
                return;
            }
            if (this.isSessionCookieExpired(this.cookieManager, modifiedTime)) {
                this.logger.finer("Cookie session file has expired.");
                if (!this.sessionCache.delete()) {
                    this.logger.finer("Unable to delete session file.");
                }
                return;
            }
            StringBuilder sb = new StringBuilder("$Version=1");
            boolean hasCookies = false;
            for (HttpCookie cookie : this.cookieManager.getCookieStore().getCookies()) {
                hasCookies = true;
                sb.append("; ").append(cookie.getName()).append("=").append(cookie.getValue());
            }
            if (hasCookies) {
                urlConnection.setRequestProperty(COOKIE_HEADER, sb.toString());
            }
        }

        private boolean isSessionCookieExpired(CookieManager manager, long creationTime) {
            for (URI uri : manager.getCookieStore().getURIs()) {
                for (HttpCookie cookie : manager.getCookieStore().get(uri)) {
                    if (!cookie.getName().equals(JSESSIONID)) continue;
                    return creationTime / 1000L + cookie.getMaxAge() < System.currentTimeMillis() / 1000L;
                }
            }
            return true;
        }

        protected synchronized void processHeaders(URLConnection urlConnection) {
            this.processCookieHeaders(urlConnection);
        }

        private void processCookieHeaders(URLConnection urlConnection) {
            block23: {
                CookieManager systemCookieManager = (CookieManager)CookieHandler.getDefault();
                if (systemCookieManager == null) {
                    this.logger.finer("Assertion failed: null system CookieManager");
                    return;
                }
                CookieStore systemCookieJar = systemCookieManager.getCookieStore();
                List<HttpCookie> newCookies = systemCookieJar.getCookies();
                if (newCookies.isEmpty()) {
                    return;
                }
                if (this.sessionCache.lastModified() == 0L) {
                    block22: {
                        if (this.cookieManager == null) {
                            this.cookieManager = new CookieManager(new ClientCookieStore(new CookieManager().getCookieStore(), this.sessionCache), CookiePolicy.ACCEPT_ALL);
                        }
                        try {
                            this.cookieManager.put(((ClientCookieStore)this.cookieManager.getCookieStore()).getStaticURI(), urlConnection.getHeaderFields());
                        }
                        catch (IOException e) {
                            if (this.logger.isLoggable(Level.FINER)) {
                                this.logger.finer("Unable to save cookies: " + e.toString());
                            }
                            return;
                        }
                        try {
                            ((ClientCookieStore)this.cookieManager.getCookieStore()).store();
                        }
                        catch (IOException e) {
                            if (!this.logger.isLoggable(Level.FINER)) break block22;
                            this.logger.finer("Unable to store cookies: " + e.toString());
                        }
                    }
                    return;
                }
                if (this.cookieManager == null) {
                    this.cookieManager = new CookieManager(new ClientCookieStore(new CookieManager().getCookieStore(), this.sessionCache), CookiePolicy.ACCEPT_ALL);
                    try {
                        ((ClientCookieStore)this.cookieManager.getCookieStore()).load();
                    }
                    catch (IOException e) {
                        if (this.logger.isLoggable(Level.FINER)) {
                            this.logger.finer("Unable to load cookies: " + e.toString());
                        }
                        return;
                    }
                }
                boolean newCookieFound = false;
                for (HttpCookie cookie : systemCookieJar.getCookies()) {
                    int cookieIndex = this.cookieManager.getCookieStore().getCookies().indexOf(cookie);
                    if (cookieIndex == -1) {
                        newCookieFound = true;
                        break;
                    }
                    HttpCookie c1 = this.cookieManager.getCookieStore().getCookies().get(cookieIndex);
                    if (c1.getValue().equals(cookie.getValue())) continue;
                    newCookieFound = true;
                    break;
                }
                if (newCookieFound) {
                    try {
                        try {
                            this.cookieManager.put(((ClientCookieStore)this.cookieManager.getCookieStore()).getStaticURI(), urlConnection.getHeaderFields());
                        }
                        catch (IOException e) {
                            if (this.logger.isLoggable(Level.FINER)) {
                                this.logger.finer("Unable to save cookies: " + e.toString());
                            }
                            return;
                        }
                        ((ClientCookieStore)this.cookieManager.getCookieStore()).store();
                    }
                    catch (IOException e) {
                        if (this.logger.isLoggable(Level.FINER)) {
                            this.logger.finer("Unable to store cookies: " + e.toString());
                        }
                        break block23;
                    }
                }
                ((ClientCookieStore)this.cookieManager.getCookieStore()).touchStore();
            }
        }
    }
}

