/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.ValueConvert;
import com.sun.messaging.jmq.util.io.FilteringObjectInputStream;
import com.sun.messaging.jms.MessageEOFException;
import jakarta.jms.JMSException;
import jakarta.jms.MessageFormatException;
import jakarta.jms.StreamMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;

public class StreamMessageImpl
extends MessageImpl
implements StreamMessage {
    private byte[] messageBody = null;
    private ByteArrayOutputStream byteArrayOutputStream = null;
    private ObjectOutputStream objectOutputStream = null;
    private ByteArrayInputStream byteArrayInputStream = null;
    private ObjectInputStream objectInputStream = null;
    private boolean bufferIsDirty = false;
    private boolean byteArrayReadState = false;
    private ByteArrayInputStream byteArrayFieldInputStream = null;
    private Object notYetProcessedPrimitiveObject = null;

    protected StreamMessageImpl() throws JMSException {
        this.setPacketType(4);
    }

    protected StreamMessageImpl(boolean constructOutputStream) throws JMSException {
        this();
        if (constructOutputStream) {
            this.initOutputStream();
        }
    }

    protected void initOutputStream() throws JMSException {
        try {
            this.byteArrayOutputStream = new ByteArrayOutputStream();
            this.objectOutputStream = new ObjectOutputStream(this.byteArrayOutputStream);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4038");
        }
    }

    @Override
    protected void setMessageBodyToPacket() throws JMSException {
        this.reset();
        this.setMessageBody(this.messageBody);
    }

    @Override
    protected void getMessageBodyFromPacket() throws JMSException {
        this.messageBody = this.getMessageBody();
        this.reset();
    }

    private Object readPrimitiveObject() throws JMSException {
        Object obj = null;
        this.checkReadAccess();
        this.checkReadBytesState();
        try {
            if (this.notYetProcessedPrimitiveObject != null) {
                obj = this.notYetProcessedPrimitiveObject;
                this.notYetProcessedPrimitiveObject = null;
            } else {
                obj = this.objectInputStream.readObject();
            }
        }
        catch (EOFException eofe) {
            String errorString = ExceptionHandler.getExceptionMessage(eofe, "C4013");
            MessageEOFException meofe = new MessageEOFException(errorString, "C4013");
            ExceptionHandler.handleException((Exception)eofe, (JMSException)((Object)meofe));
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4038");
        }
        return obj;
    }

    private void writePrimitiveObject(Object obj) throws JMSException {
        this.checkMessageAccess();
        try {
            this.objectOutputStream.writeObject(obj);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4038");
        }
        this.setBufferIsDirty(true);
    }

    private void checkReadBytesState() throws MessageFormatException {
        if (this.byteArrayReadState) {
            String errorString = AdministeredObject.cr.getKString("C4017");
            throw new MessageFormatException(errorString, "C4017");
        }
    }

    protected void setBufferIsDirty(boolean state) {
        this.bufferIsDirty = state;
    }

    protected boolean getBufferIsDirty() {
        return this.bufferIsDirty;
    }

    @Override
    public void clearBody() throws JMSException {
        this.messageBody = null;
        this.setMessageBody(null);
        this.initOutputStream();
        this.setMessageReadMode(false);
    }

    public boolean readBoolean() throws JMSException {
        Object obj = this.readPrimitiveObject();
        return ValueConvert.toBoolean(obj);
    }

    public byte readByte() throws JMSException {
        Object obj = this.readPrimitiveObject();
        try {
            byte b = ValueConvert.toByte(obj);
            return b;
        }
        catch (NumberFormatException nfe) {
            this.notYetProcessedPrimitiveObject = obj;
            throw nfe;
        }
    }

    public short readShort() throws JMSException {
        Object obj = this.readPrimitiveObject();
        return ValueConvert.toShort(obj);
    }

    public char readChar() throws JMSException {
        Object obj = this.readPrimitiveObject();
        return ValueConvert.toChar(obj);
    }

    public int readInt() throws JMSException {
        Object obj = this.readPrimitiveObject();
        return ValueConvert.toInt(obj);
    }

    public long readLong() throws JMSException {
        Object obj = this.readPrimitiveObject();
        return ValueConvert.toLong(obj);
    }

    public float readFloat() throws JMSException {
        Object obj = this.readPrimitiveObject();
        return ValueConvert.toFloat(obj);
    }

    public double readDouble() throws JMSException {
        Object obj = this.readPrimitiveObject();
        return ValueConvert.toDouble(obj);
    }

    public String readString() throws JMSException {
        Object obj = this.readPrimitiveObject();
        return ValueConvert.toString(obj);
    }

    public int readBytes(byte[] value) throws JMSException {
        int bytesRead = -1;
        if (this.messageBody == null) {
            this.checkReadAccess();
            return -1;
        }
        if (!this.byteArrayReadState) {
            Object obj = this.readPrimitiveObject();
            if (obj == null) {
                return -1;
            }
            if (!(obj instanceof byte[])) {
                String errorString = AdministeredObject.cr.getKString("C4017");
                throw new MessageFormatException(errorString, "C4017");
            }
            byte[] data = (byte[])obj;
            if (data.length == 0) {
                return 0;
            }
            this.byteArrayFieldInputStream = new ByteArrayInputStream(data);
            this.byteArrayReadState = true;
        }
        if ((bytesRead = this.byteArrayFieldInputStream.read(value, 0, value.length)) < value.length) {
            this.byteArrayReadState = false;
            try {
                this.byteArrayFieldInputStream.close();
                this.byteArrayFieldInputStream = null;
            }
            catch (IOException e) {
                ExceptionHandler.handleException((Exception)e, "C4038");
            }
        }
        return bytesRead;
    }

    public Object readObject() throws JMSException {
        Object obj = this.readPrimitiveObject();
        return obj;
    }

    public void writeBoolean(boolean value) throws JMSException {
        this.writePrimitiveObject(value);
    }

    public void writeByte(byte value) throws JMSException {
        this.writePrimitiveObject(value);
    }

    public void writeShort(short value) throws JMSException {
        this.writePrimitiveObject(value);
    }

    public void writeChar(char value) throws JMSException {
        this.writePrimitiveObject(Character.valueOf(value));
    }

    public void writeInt(int value) throws JMSException {
        this.writePrimitiveObject(value);
    }

    public void writeLong(long value) throws JMSException {
        this.writePrimitiveObject(value);
    }

    public void writeFloat(float value) throws JMSException {
        this.writePrimitiveObject(Float.valueOf(value));
    }

    public void writeDouble(double value) throws JMSException {
        this.writePrimitiveObject(value);
    }

    public void writeString(String value) throws JMSException {
        this.writePrimitiveObject(value);
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.writePrimitiveObject(value);
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        byte[] out = new byte[length];
        System.arraycopy(value, offset, out, 0, length);
        this.writePrimitiveObject(out);
    }

    public void writeObject(Object value) throws JMSException {
        this.checkValidObjectType(value);
        this.writePrimitiveObject(value);
    }

    private void checkValidObjectType(Object value) throws MessageFormatException {
        if (value == null) {
            return;
        }
        if (!(value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Character || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof String || value instanceof byte[])) {
            String errorString = AdministeredObject.cr.getKString("C4017");
            throw new MessageFormatException(errorString, "C4017");
        }
    }

    public void reset() throws JMSException {
        try {
            if (this.bufferIsDirty) {
                this.objectOutputStream.flush();
                this.messageBody = this.byteArrayOutputStream.toByteArray();
                this.objectOutputStream.close();
                this.byteArrayOutputStream.close();
            }
            if (this.messageBody != null) {
                this.byteArrayInputStream = new ByteArrayInputStream(this.messageBody);
                this.objectInputStream = new FilteringObjectInputStream(this.byteArrayInputStream);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4012");
        }
        this.setBufferIsDirty(false);
        this.setMessageReadMode(true);
        this.byteArrayReadState = false;
        this.notYetProcessedPrimitiveObject = null;
    }

    @Override
    public void dump(PrintStream ps) {
        ps.println("------ StreamMessageImpl dump ------");
        super.dump(ps);
    }
}

